/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import javafx.scene.paint.Color;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.overlay.OverlayAlertMessage;
import open.batoru.networking.PacketParser;
import open.batoru.parsers.LanguageParser;

public abstract class ActionPlayerChoice<T>
extends GameAction<T> {
    private final TargetFilter filter;

    public ActionPlayerChoice(TargetFilter filter) {
        this.filter = filter;
    }

    public TargetFilter getFilter() {
        return this.filter;
    }

    @Override
    protected void dispatch() {
        if (!this.isDataReceived() && this.getDataTable().isEmpty()) {
            this.requestData();
            return;
        }
        if (this.isSuccessful()) {
            this.dispatchOnSuccess();
            return;
        }
        if (this.isTargeted() && (this.filter == null || this.filter.isTargeted() && !this.filter.getHintLocationsData().contains((Object)GameConst.CardLocation.LOOKED) && !this.filter.getHintLocationsData().contains((Object)GameConst.CardLocation.HAND))) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_TARGETS"), Color.RED, 600);
        }
        this.setAsCompleted();
    }

    protected abstract void dispatchOnSuccess();

    protected boolean isTargeted() {
        return true;
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (!pp.getDataArgument(1).isEmpty()) {
            this.processReceivedData(pp);
        }
        if (this.getDataTable().isEmpty()) {
            this.getDataTable().add(null);
        }
    }

    protected abstract void processReceivedData(PacketParser var1);
}

