/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionPlayerChoice;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.events.EventTarget;
import open.batoru.game.FieldZone;
import open.batoru.game.animations.AnimationTexturedMeshFlash;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventTarget;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionPlayerChoiceCard
extends ActionPlayerChoice<CardIndex> {
    public ActionPlayerChoiceCard() {
        super(null);
    }

    public ActionPlayerChoiceCard(TargetFilter filter) {
        super(filter);
    }

    @Override
    protected void dispatchOnSuccess() {
        int i;
        AnimationTracker tracker = new AnimationTracker(this.getDataTable().size());
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        Game.GamePlayerRole sourceTargetRole = this.getFilter() != null ? this.getFilter().getSourceTargetRole() : this.getSourceCardIndex().getIndexedInstance().getCurrentOwner();
        for (i = 0; i < this.getDataTable().size(); ++i) {
            CardIndex cardIndex = (CardIndex)this.getDataTable().get(i);
            if (cardIndex == null || cardIndex.getIndexedInstance() == null) continue;
            if (this.getFilter() != null) {
                if (this.getFilter().isTargeted()) {
                    UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenTarget(this.getSourceAbility(), sourceTargetRole, cardIndex);
                }
                if (this.getSourceCost() == null) {
                    this.setLogEvent(new LogEventTarget(cardIndex, this.getSourceCardIndex(), sourceTargetRole));
                }
            }
            if (!GameConst.CardLocation.isOnField(cardIndex.getLocation())) continue;
            FieldZone zone = (FieldZone)cardIndex.getZoneByLocation();
            AnimationTexturedMeshFlash aniFlash = new AnimationTexturedMeshFlash(zone.getZoneMesh(), zone.getDefaultColor(), zone.isFlipped() ? Color.GREEN : Color.RED, true);
            aniFlash.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniFlash);
        }
        if (!seqAni.getAnimationList().isEmpty()) {
            if (this.getFilter() != null && this.getFilter().isTargeted()) {
                for (i = 0; i < this.getDataTable().size(); ++i) {
                    EventTarget event = new EventTarget((CardIndex)this.getDataTable().get(i), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), sourceTargetRole);
                    event.setAtOnce(i, this.getDataTable().size());
                    Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(event);
                }
                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            }
            seqAni.play();
        } else {
            this.setAsCompleted();
        }
    }

    @Override
    protected void processReceivedData(PacketParser pp) {
        for (int i = 1; i < pp.getDataArgsNum(); ++i) {
            CardIndex.getCardFromPacketData(pp.getDataArgument(i)).ifPresent(card3D -> this.getDataTable().add(card3D.getCardIndex()));
        }
    }
}

