/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.control.ControlTemporaryCardRules;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventEner;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionPutInEner
extends TransientCardGameAction {
    public ActionPutInEner(CardIndex cardIndex) {
        super(cardIndex);
    }

    public ActionPutInEner() {
    }

    @Override
    protected void dispatch() {
        if (!this.isDataReceived() && (this.getCardIndex() == null || this.getCardIndex().getIndexedInstance() == null || this.getTotalNumAtOnce() > 1 && Game.getCurrentGame().isNeutralPerspectiveGame())) {
            this.requestData();
            return;
        }
        if (this.getCardIndex() == null || this.getCardIndex().getLocation() == GameConst.CardLocation.ENER || this.getCardIndex().getIndexedInstance() != null && (this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.getCardIndex(), this, new Object[]{GameConst.CardLocation.ENER}) == RuleCheck.RuleCheckState.BLOCK || this.getSourceAbility() != null && this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK)) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        GameEvent[] listEvents = new GameEvent[]{new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.ENER), new EventEner(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility())};
        this.setLogEvent(new LogEventMove((EventMove)listEvents[0], AbilityConst.ActionHint.ENER), this.getSourceCardIndex() == null);
        for (GameEvent event : listEvents) {
            event.setAtOnce(this);
        }
        if (this.applyActiveOverrideActions(this.getCardIndex().getCurrentOwnerSafe(), listEvents) || ControlTemporaryCardRules.applyLocationOverrideOnLeaveField(this.getCardIndex(), this)) {
            return;
        }
        if (this.getCardIndex().getLocation() == GameConst.CardLocation.LIFE_CLOTH) {
            UI.getTabGame().getFieldSceneOverlay().getGameLog().getLifeClothTracker(this.getCardIndex().getCurrentOwnerSafe()).moveNext(this.getCardIndex().getImageSet(), false, this.getLogEvent());
        }
        this.addCardIndexData();
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(listEvents);
        if (this.isLastAtOnce()) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        }
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getCardIndex().getCurrentOwnerSafe()).getEnerZone());
        aniMove.setAnimationTracker(tracker);
        aniMove.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (this.getCardIndex() != null) {
            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(1), this.getCardIndex().getSourceCard3D());
        } else {
            CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> this.setCardIndex(card3D.getCardIndex()));
        }
    }
}

