/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.Optional;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.PieceAbility;
import open.batoru.data.ability.events.EventUsePiece;
import open.batoru.game.PlayerField;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.ui.UI;

public class ActionPutOnFieldPiece
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;

    public ActionPutOnFieldPiece(CardIndex cardIndex) {
        this.cardIndex = cardIndex;
    }

    @Override
    protected void dispatch() {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getIndexedInstance().getCurrentOwner());
        if (!CardIndex.isOwnCard(this.cardIndex)) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.cardIndex);
        }
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(() -> {
            Optional<PieceAbility> found = PieceAbility.findPieceAbility(this.cardIndex);
            found.ifPresent(CheckZoneAbility::updateDynamicCost);
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(new EventUsePiece(this.cardIndex));
            this.setAsCompleted();
        });
        AnimationCardMove aniMove = new AnimationCardMove(this.cardIndex.getSourceCard3D(), field.getCheckZone());
        aniMove.setAnimationTracker(tracker);
        aniMove.play();
    }
}

