/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.CardConst;
import open.batoru.data.ability.events.EventMove;
import open.batoru.game.FieldData;
import open.batoru.game.FieldStackZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.log.events.LogEventMove;

public class ActionPutOnZone
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;
    private final GameConst.CardLocation targetLocation;
    private final GameConst.CardUnderType underType;

    public ActionPutOnZone(CardIndex cardIndex, GameConst.CardLocation targetLocation, GameConst.CardUnderType underType) {
        this.cardIndex = cardIndex;
        this.targetLocation = targetLocation;
        this.underType = underType;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || this.underType.getUnderCategory() != GameConst.CardUnderCategory.ZONE || !GameConst.CardLocation.isSIGNI(this.targetLocation) && !GameConst.CardLocation.isLRIG(this.targetLocation) || this.cardIndex.getLocation() == this.targetLocation) {
            this.setAsCompleted();
            return;
        }
        this.getDataTable().add(this.cardIndex);
        this.setLogEvent(new LogEventMove(new EventMove(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), this.targetLocation), TargetFilter.TargetHint.ZONE));
        FieldStackZone zoneTarget = (FieldStackZone)FieldData.getZoneByLocation(this.cardIndex.getCurrentOwnerSafe(), this.targetLocation);
        this.cardIndex.setUnderType(this.underType);
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(() -> {
            this.cardIndex.setCardFace(CardConst.CardFace.BACK);
            zoneTarget.getZoneUnderCardsIndicators().addUnderType(this.underType);
            zoneTarget.updateZone(null);
            this.cardIndex.setUnderType(this.underType);
            this.setAsCompleted();
        });
        AnimationCardMove aniMove = new AnimationCardMove(this.cardIndex.getSourceCard3D(), (Zone)zoneTarget, Zone.ZonePosition.BOTTOM);
        aniMove.setRotationOffset(new Vector3D(0.0, 180.0, 0.0));
        aniMove.setAnimationTracker(tracker);
        if (zoneTarget.getZoneLocation() == GameConst.CardLocation.LRIG && (this.cardIndex.getLocation() == GameConst.CardLocation.LOOKED || this.cardIndex.getLocation() == GameConst.CardLocation.REVEALED)) {
            aniMove.setDelay(300.0);
        }
        aniMove.play();
    }
}

