/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameAction;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneDeck;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.CardViewUnderCardsButton;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.ui.UI;

public class ActionRefresh
extends GameAction<Void> {
    private final Game.GamePlayerRole rolePlayer;

    public ActionRefresh(Game.GamePlayerRole rolePlayer) {
        this.rolePlayer = rolePlayer;
    }

    @Override
    protected void dispatch() {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer);
        if (Game.getCurrentGame().getGameSpeedController().getMultiplier() != 0.01) {
            CardViewUnderCardsButton.showViewDeckWindow(field.getTrashZone(Deck.DeckType.MAIN));
        }
        ZoneDeck zoneDeck = field.getDeckZone(Deck.DeckType.MAIN);
        ZoneDeck zoneTrash = field.getTrashZone(Deck.DeckType.MAIN);
        AnimationTracker tracker = new AnimationTracker(zoneTrash.getTotalCards());
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        for (int i = zoneTrash.getTotalCards() - 1; i >= 0; --i) {
            Card3D card3D = zoneTrash.getZoneCardList().get(i);
            AnimationCardMove aniMove = new AnimationCardMove(card3D, zoneDeck);
            aniMove.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniMove);
        }
        seqAni.play();
    }
}

