/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import open.batoru.Log;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.game.ZoneDeck;
import open.batoru.game._3d.Card3D;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.ui.UI;

public class ActionRequestInfoDeck
extends GameAction<CardIndex> {
    private final Game.GamePlayerRole rolePlayer;
    private int numToRequest;
    private final Deck.DeckPosition position;
    private int numInDeck;
    private List<String> cacheReceived = new ArrayList<String>();

    public ActionRequestInfoDeck() {
        this(Game.getCurrentGame().getPlayerRole(), 0, Deck.DeckPosition.TOP);
    }

    public ActionRequestInfoDeck(Game.GamePlayerRole rolePlayer, int numToRequest, Deck.DeckPosition position) {
        this.rolePlayer = rolePlayer;
        this.numToRequest = numToRequest;
        this.position = position;
    }

    @Override
    protected void dispatch() {
        this.numInDeck = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getDeckZone(Deck.DeckType.MAIN).getTotalCards();
        if (this.numToRequest == 0) {
            this.numToRequest = this.numInDeck;
        }
        this.requestDataChunk(0);
    }

    private void requestDataChunk(int chunkId) {
        try {
            GameSendActionAttempt attempt = new GameSendActionAttempt("RQDINFO", this.getOrderId(), String.valueOf(chunkId));
            Player.getNetworkFrame().getGameReceiver().setCustomPacketRedirectByToken("DINFO", pp -> {
                if (pp.getDataArgsNum() < 1 || pp.getDataArgument(0).equals("!3")) {
                    return;
                }
                ZoneDeck zoneDeck = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getDeckZone(Deck.DeckType.MAIN);
                if (!pp.getDataArgument(0).equals(String.valueOf(0))) {
                    for (int i = 0; i < pp.getDataArgsNum(); ++i) {
                        if (this.cacheReceived.contains(pp.getDataArgument(i))) {
                            return;
                        }
                        this.cacheReceived.add(pp.getDataArgument(i));
                        Card3D card3D = this.position == Deck.DeckPosition.TOP ? zoneDeck.getTopCard(this.getDataTable().size()) : zoneDeck.getBottomCard(this.getDataTable().size());
                        CardIndex.assignCardFromShortPacketData(pp.getDataArgument(i), card3D);
                        if (card3D == null) continue;
                        this.getDataTable().add(card3D.getCardIndex());
                    }
                    if (pp.getDataArgsNum() > 1 && this.getDataTable().size() < this.numToRequest && this.getDataTable().size() < this.numInDeck) {
                        attempt.setReceivedPacketAsSatisfying();
                        this.requestDataChunk(chunkId + 1);
                        return;
                    }
                } else {
                    this.getDataTable().add(null);
                }
                attempt.setReceivedPacketAsSatisfying();
                Player.getNetworkFrame().getGameReceiver().stopPacketRedirectByToken("DINFO");
                this.setAsCompleted();
            });
            attempt.send();
        }
        catch (UnknownHostException ex) {
            Log.printMessage(ex);
        }
    }
}

