/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.control.ControlTemporaryCardRules;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventMove;
import open.batoru.game.FieldData;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.ui.UI;

public class ActionReturnToDeck
extends TransientCardGameAction {
    private final Deck.DeckPosition position;

    public ActionReturnToDeck(CardIndex cardIndex, Deck.DeckPosition position) {
        super(cardIndex);
        this.position = position;
    }

    @Override
    protected void dispatch() {
        GameConst.CardLocation sendLocation;
        GameConst.CardLocation cardLocation = sendLocation = Card3D.isMainDeckCard(this.getCardIndex().getSourceCard3D()) ? GameConst.CardLocation.DECK_MAIN : GameConst.CardLocation.DECK_LRIG;
        if (this.getCardIndex().getIndexedInstance() != null && (this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.getCardIndex(), this, new Object[]{sendLocation}) == RuleCheck.RuleCheckState.BLOCK || this.getSourceAbility() != null && this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK)) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        EventMove eventMove = new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), sendLocation);
        eventMove.setAtOnce(this);
        this.setLogEvent(new LogEventMove(eventMove, this.position == Deck.DeckPosition.TOP ? AbilityConst.ActionHint.TOP : AbilityConst.ActionHint.BOTTOM));
        if (this.applyActiveOverrideActions(this.getCardIndex().getCurrentOwnerSafe(), eventMove) || ControlTemporaryCardRules.applyLocationOverrideOnLeaveField(this.getCardIndex(), this)) {
            return;
        }
        if (this.getCardIndex().getLocation() == GameConst.CardLocation.LIFE_CLOTH) {
            UI.getTabGame().getFieldSceneOverlay().getGameLog().getLifeClothTracker(this.getCardIndex().getCurrentOwnerSafe()).moveNext(this.getCardIndex().getImageSet(), false, this.getLogEvent());
        }
        this.addCardIndexData();
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventMove);
        if (this.isLastAtOnce()) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        }
        if (!CardIndex.isOwnCard(this.getCardIndex()) && this.getCardIndex().getIndexedInstance() != null) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.getCardIndex());
        }
        AnimationTracker tracker = new AnimationTracker(this.getTotalNumAtOnce() <= 5 && this.getCardIndex().getIndexedInstance() != null && !GameConst.CardLocation.isOnField(this.getCardIndex().getLocation()) && this.getCardIndex().getLocation() != GameConst.CardLocation.REVEALED && GameConst.CardLocation.isPublic(this.getCardIndex().getLocation()) ? 2 : 1);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        if (tracker.getMaxCount() > 1) {
            AnimationCardMove aniReveal = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getCardIndex().getCurrentOwnerSafe()).getRevealZone());
            aniReveal.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniReveal);
        }
        AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), FieldData.getZoneByLocation(this.getCardIndex().getIndexedInstance() != null ? CardIndex.getOriginalOwner(this.getCardIndex().getId()) : Card3D.getCurrentOwner(this.getCardIndex().getSourceCard3D()), sendLocation), this.position == Deck.DeckPosition.TOP || sendLocation != GameConst.CardLocation.DECK_MAIN ? Zone.ZonePosition.TOP : Zone.ZonePosition.BOTTOM);
        if (tracker.getMaxCount() > 1) {
            aniMove.setDelay(300.0);
        }
        aniMove.setAnimationTracker(tracker);
        seqAni.getAnimationList().add(aniMove);
        seqAni.play();
    }
}

