/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import javafx.application.Platform;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.Card;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.events.EventTransform;
import open.batoru.game.Zone;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardFlip;
import open.batoru.game.animations.AnimationCardLift;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;

public class ActionTransform
extends GameAction<Card.IndexedInstance> {
    private final CardIndex target;
    private String imageSetSource;
    private final ChronoDuration chronoDuration;
    private int oldId;
    private String oldImageSet;
    private GameConst.CardUnderType oldUnderType;

    public ActionTransform(CardIndex target, String imageSetSource, ChronoDuration chronoDuration) {
        this.target = target;
        this.imageSetSource = imageSetSource;
        this.chronoDuration = chronoDuration;
    }

    @Override
    protected void dispatch() {
        if (this.target == null || this.target.getIndexedInstance() == null) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        if (CardLoader.getImageSetMaskType(this.target.getImageSet()) == CardDataImageSet.MaskType.DOUBLE_FACED_UR) {
            this.imageSetSource = this.imageSetSource + "U";
        }
        if (CardLoader.getCardByImageSet(this.imageSetSource) == null || this.target.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.target, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        Zone zone = this.target.getZoneByLocation();
        Card3D card3D = this.target.getSourceCard3D();
        if (zone instanceof ZoneSIGNI) {
            ZoneSIGNI zoneSIGNI = (ZoneSIGNI)zone;
            zoneSIGNI.getZoneNumbers().setVisible(false);
            zoneSIGNI.removeListeners(this.target);
        }
        AnimationTracker tracker = new AnimationTracker(4);
        tracker.setOnTrackerAllFinished(() -> {
            if (zone instanceof ZoneSIGNI) {
                ZoneSIGNI zoneSIGNI = (ZoneSIGNI)zone;
                zoneSIGNI.resetListeners();
            }
            this.target.getZoneByLocation().updateZone(null);
            EventTransform event = new EventTransform(this.target, this.getSourceAbility());
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(event);
            if (this.isLastAtOnce()) {
                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            }
            this.setAsCompleted();
        });
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        AnimationCardLift aniLift = new AnimationCardLift(card3D);
        aniLift.setAnimationTracker(tracker);
        seqAni.getAnimationList().add(aniLift);
        AnimationCardFlip aniFlip = new AnimationCardFlip(card3D, false);
        aniFlip.setAnimationTracker(tracker);
        seqAni.getAnimationList().add(aniFlip);
        seqAni.getAnimationList().add(aniFlip);
        seqAni.getAnimationList().add(aniLift);
        this.oldId = this.target.getId();
        this.oldImageSet = this.target.getImageSet();
        this.oldUnderType = this.target.getUnderType();
        seqAni.setOnTrackerFinished(ani -> {
            if (tracker.getFinishedCount() != 2) {
                return;
            }
            aniLift.reverse();
            this.target.getIndexedInstance().getAbilityList().forEach(Ability::disable);
            int oldFlags = this.target.getIndexedInstance().getCardStateFlags().getValue() & 0x194008;
            this.target.getIndexedInstance().resetStats(true);
            CardIndex cardIndexCopy = Game.getCurrentGame().getIndexRegistry().createFreeIndex(this.target.getIndexedInstance().getCurrentOwner(), this.target.getLocation());
            cardIndexCopy.setImageSet(cardIndexCopy.getId(), this.imageSetSource);
            this.target.setImageSet(cardIndexCopy.getId(), this.imageSetSource);
            Game.getCurrentGame().getIndexRegistry().addIndex(this.target.getId(), this.target);
            this.target.getSourceCard3D().updateImageSet();
            this.target.getIndexedInstance().updateCardIndex();
            this.target.getIndexedInstance().updateInstanceId();
            this.target.getIndexedInstance().initCardAbilities();
            this.target.getIndexedInstance().getAbilityList().forEach(ability -> ability.setSourceCardId(this.target.getId()));
            if (this.target.getIndexedInstance().isState(8)) {
                this.target.getIndexedInstance().getCardStateFlags().removeValue(8);
            }
            if (oldFlags != 0) {
                this.target.getIndexedInstance().getCardStateFlags().addValue(oldFlags);
            }
            if (this.oldUnderType != GameConst.CardUnderType.NONE) {
                this.target.setUnderType(this.oldUnderType);
            }
            this.target.getIndexedInstance().setOriginalImageSet(this.oldImageSet);
            this.getDataTable().add(this.target.getIndexedInstance());
            this.addRestoreChronoRecord();
        });
        seqAni.play();
    }

    private void addRestoreChronoRecord() {
        ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(this.target, this.chronoDuration);
        record.setAsProtected(true);
        record.setOnChronoRecordExpired(() -> {
            if (this.target.getIndexedInstance() == null) {
                return;
            }
            Zone patt0$temp = this.target.getZoneByLocation();
            if (patt0$temp instanceof ZoneSIGNI) {
                ZoneSIGNI zoneSIGNI = (ZoneSIGNI)patt0$temp;
                zoneSIGNI.removeListeners(this.target);
                Platform.runLater(zoneSIGNI::resetListeners);
            }
            this.target.getIndexedInstance().getAbilityList().forEach(Ability::disable);
            int oldFlags = this.target.getIndexedInstance().getCardStateFlags().getValue() & 0x194008;
            this.target.getIndexedInstance().resetStats(true);
            this.target.setImageSet(this.oldId, this.oldImageSet);
            Game.getCurrentGame().getIndexRegistry().addIndex(this.oldId, this.target);
            this.target.getIndexedInstance().updateCardIndex();
            this.target.getIndexedInstance().updateInstanceId();
            Platform.runLater(() -> {
                this.target.getSourceCard3D().updateImageSet();
                this.target.getZoneByLocation().updateZone(null);
            });
            if (oldFlags != 0) {
                this.target.getIndexedInstance().getCardStateFlags().addValue(oldFlags);
            }
            if (this.oldUnderType != GameConst.CardUnderType.NONE) {
                this.target.setUnderType(this.oldUnderType);
            }
            this.target.getIndexedInstance().setOriginalImageSet(null);
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
        });
        Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
    }
}

