/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.game.FieldZone;
import open.batoru.game.ZoneSIGNI;

public class ActionZoneDelete
extends GameAction<Void> {
    private final Game.GamePlayerRole rolePlayer;
    private final FieldZone fieldZone;
    private final ChronoDuration chronoDuration;
    private final boolean restore;

    public ActionZoneDelete(Game.GamePlayerRole rolePlayer, FieldZone fieldZone, ChronoDuration chronoDuration) {
        this.rolePlayer = rolePlayer;
        this.fieldZone = fieldZone;
        this.chronoDuration = chronoDuration;
        this.restore = false;
    }

    public ActionZoneDelete(Game.GamePlayerRole rolePlayer, FieldZone fieldZone) {
        this.rolePlayer = rolePlayer;
        this.fieldZone = fieldZone;
        this.chronoDuration = null;
        this.restore = true;
    }

    @Override
    protected void dispatch() {
        FieldZone fieldZone = this.fieldZone;
        if (!(fieldZone instanceof ZoneSIGNI)) {
            this.setAsCompleted();
            return;
        }
        ZoneSIGNI zoneSIGNI = (ZoneSIGNI)fieldZone;
        this.fieldZone.getNode().setVisible(this.restore);
        if (!this.restore) {
            ActionTrash prevAction = null;
            for (int i = 0; i < this.fieldZone.getTotalCards(); ++i) {
                ActionTrash actionTrash = new ActionTrash(this.fieldZone.getTopCard(i).getCardIndex());
                actionTrash.setAtOnce(prevAction, i, this.fieldZone.getTotalCards());
                prevAction = actionTrash;
                Game.getCurrentGame().getActionQueue().addAction(actionTrash);
            }
            zoneSIGNI.getZoneUnderCardsIndicators().clearAll();
            if (this.chronoDuration != ChronoDuration.permanent()) {
                ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(this.chronoDuration);
                record.setOnChronoRecordExpired(() -> Game.getCurrentGame().getActionQueue().addAction(new ActionZoneDelete(this.rolePlayer, this.fieldZone)));
                Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
            }
        }
        this.setAsCompleted();
    }
}

