/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions.override;

import java.util.LinkedHashSet;
import java.util.List;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.override.OverrideActionList;
import open.batoru.core.gameplay.actions.override.OverrideResult;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.ActionOverrideRuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.ConstantAbilityShared;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.data.ability.events.PlayerGameEvent;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.data.ability.modifiers.RuleCheckModifier;

public class OverrideAction {
    private final GameConst.GameEventId event;
    private final OverrideScope overrideScope;
    private int overrideFlags;
    private final ActionOverrideCondition condition;
    private final ActionOverrideHandler handler;
    private Ability sourceAbilityRC;
    private GameEvent sourceEvent;

    public OverrideAction(GameConst.GameEventId event, OverrideScope overrideScope, int overrideFlags, ActionOverrideHandler handler) {
        this(event, overrideScope, overrideFlags, ActionOverrideCondition.ALWAYS_TRUE, handler);
    }

    public OverrideAction(GameConst.GameEventId event, OverrideScope overrideScope, int overrideFlags, ActionOverrideCondition condition, ActionOverrideHandler handler) {
        this.event = event;
        this.overrideScope = overrideScope;
        this.overrideFlags = overrideFlags;
        this.condition = condition;
        this.handler = handler;
    }

    public GameConst.GameEventId getActionEvent() {
        return this.event;
    }

    public OverrideScope getOverrideScope() {
        return this.overrideScope;
    }

    public int getOverrideFlags() {
        return this.overrideFlags;
    }

    public void setOverrideFlags(int overrideFlags) {
        this.overrideFlags = overrideFlags;
    }

    public void setSourceAbilityRC(Ability sourceAbilityRC) {
        this.sourceAbilityRC = sourceAbilityRC;
    }

    public Ability getSourceAbilityRC() {
        return this.sourceAbilityRC;
    }

    public void setSourceEvent(GameEvent sourceEvent) {
        this.sourceEvent = sourceEvent;
    }

    public GameEvent getSourceEvent() {
        return this.sourceEvent;
    }

    public ActionOverrideCondition getCondition() {
        return this.condition;
    }

    public ActionOverrideHandler getHandler() {
        return this.handler;
    }

    public OverrideActionList prepareOverrideActionList(OverrideResult sourceOverrideResult) {
        OverrideActionList list = new OverrideActionList(sourceOverrideResult, this.sourceAbilityRC, this.overrideFlags);
        if ((this.overrideFlags & 1) != 0) {
            list.addNonMandatoryChoiceAction();
        } else {
            OverrideAction overrideAction = sourceOverrideResult.getCurrentOverrideAction();
            if (this.sourceAbilityRC != null && overrideAction.getOverrideScope() == OverrideScope.CALLER && !overrideAction.getSourceEvent().isLastAtOnce() && overrideAction.getSourceEvent().getCallerCardIndex() != this.sourceAbilityRC.getSourceCardIndex() && overrideAction.getSourceEvent().getCaller().getOwner() == this.sourceAbilityRC.getAbilityOwner()) {
                this.overrideFlags |= 1;
                list.addNonMandatoryChoiceAction();
                list.getAction(0, 0).setOnActionCompleted(() -> {
                    if (!list.getAction(0, 0).isSuccessful()) {
                        this.sourceAbilityRC.enable();
                    }
                });
            }
        }
        GameEvent sourceEvent = sourceOverrideResult.getCurrentOverrideAction().getSourceEvent();
        TargetFilter.setDefaultSources(sourceEvent.getCallerCardIndex() != null ? sourceEvent.getCallerCardIndex() : null, this.sourceAbilityRC);
        this.handler.handle(list, this.sourceAbilityRC);
        return list;
    }

    public boolean matchesScope(CardIndex cardIndex, GameEvent event) {
        return this.overrideScope == OverrideScope.CALLER && event.getCallerCardIndex() == cardIndex || this.overrideScope == OverrideScope.SOURCE && event.getSourceCardIndex() == cardIndex || this.overrideScope == OverrideScope.GLOBAL;
    }

    public boolean matchesCondition(CardIndex cardIndex, GameEvent event) {
        TargetFilter.setDefaultSources(event.getCallerCardIndex() != null ? event.getCallerCardIndex() : null, this.sourceAbilityRC);
        return this.condition.check(cardIndex, event, this.sourceAbilityRC);
    }

    public static OverrideResult findActiveOverrideActions(Game.GamePlayerRole roleOwner, GameAction<?> sourceAction, GameEvent ... events) {
        OverrideResult result = new OverrideResult(roleOwner, sourceAction);
        List<ConstantModifier> cacheActiveModifiers = Game.getCurrentGame().getGameData().getCachedActiveModifiersList();
        LinkedHashSet<CardIndex> cacheCardIndexes = new LinkedHashSet<CardIndex>();
        for (ConstantModifier modifier : cacheActiveModifiers) {
            ConstantAbility sourceAbilityRC;
            RuleCheckModifier modifierRC;
            if (!(modifier instanceof RuleCheckModifier) || (modifierRC = (RuleCheckModifier)modifier).getRuleCheckType() != CardRuleCheckRegistry.CardRuleCheckType.ACTION_OVERRIDE || (sourceAbilityRC = modifierRC.getSourceAbility()).isDisabled() || sourceAbilityRC.isMuted()) continue;
            if (sourceAbilityRC instanceof ConstantAbilityShared) {
                ConstantAbilityShared sourceAbilityShared = (ConstantAbilityShared)sourceAbilityRC;
                List<CardIndex> cachedTargets = sourceAbilityShared.getCachedTargetsList();
                for (CardIndex cardIndex : cachedTargets) {
                    if (cardIndex.getIndexedInstance() == null) continue;
                    cacheCardIndexes.add(cardIndex);
                }
                continue;
            }
            CardIndex cardIndex = sourceAbilityRC.getSourceCardIndex();
            cacheCardIndexes.add(cardIndex);
        }
        for (CardIndex cardIndex : cacheCardIndexes) {
            ActionOverrideRuleCheck.OverrideActionListWrapper wrapper = ActionOverrideRuleCheck.getCardOverrideActions((ActionOverrideRuleCheck)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.ACTION_OVERRIDE), sourceAction);
            for (OverrideAction override : wrapper.getOverrideActions()) {
                for (GameEvent event : events) {
                    if (override.getActionEvent() != event.getId() || !override.matchesScope(cardIndex, event) || !override.matchesCondition(cardIndex, event)) continue;
                    result.addOverrideAction(override, event);
                }
            }
        }
        ActionOverrideRuleCheck.OverrideActionListWrapper wrapper = ActionOverrideRuleCheck.getPlayerOverrideActions((ActionOverrideRuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(roleOwner).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.ACTION_OVERRIDE), sourceAction);
        for (OverrideAction override : wrapper.getOverrideActions()) {
            for (GameEvent event : events) {
                if (!(event instanceof PlayerGameEvent)) continue;
                PlayerGameEvent playerEvent = (PlayerGameEvent)event;
                if (override.getActionEvent() != event.getId() || roleOwner != playerEvent.getPlayer() || override.getOverrideScope() != OverrideScope.GLOBAL || !override.matchesCondition(null, event)) continue;
                result.addOverrideAction(override, event);
            }
        }
        return result;
    }

    @FunctionalInterface
    public static interface ActionOverrideCondition {
        public static final ActionOverrideCondition ALWAYS_TRUE = (cardIndex, event, sourceAbilityRC) -> true;

        public boolean check(CardIndex var1, GameEvent var2, Ability var3);
    }

    public static enum OverrideScope {
        CALLER,
        SOURCE,
        GLOBAL;

    }

    @FunctionalInterface
    public static interface ActionOverrideHandler {
        public void handle(OverrideActionList var1, Ability var2);
    }
}

