/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.callback;

import javafx.application.Platform;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CutInResponse;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEffectActivateResolve;
import open.batoru.core.gameplay.actions.ActionManualChoiceEventSource;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.actions.override.OverrideResult;
import open.batoru.core.gameplay.callback.CallbackThread;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.DataTable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.CardAbilities;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.PieceAbility;
import open.batoru.data.ability.SpellAbility;
import open.batoru.data.ability.events.EventActivateAbility;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.GameField;
import open.batoru.game.animations.AnimationFlashEffect;
import open.batoru.game.animations.AnimationFlashEffectNegate;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.game.overlay.log.events.LogEventEffectResolve;
import open.batoru.ui.UI;

public class EffectCallbackThread
extends CallbackThread {
    private final ActionEffectActivateResolve sourceAction;
    private final Ability sourceAbility;
    private EffectBucket sourceBucket;
    private LogEvent logEventEffectResolution;

    public EffectCallbackThread(ActionEffectActivateResolve sourceAction) {
        super(sourceAction);
        this.sourceAction = sourceAction;
        this.sourceAbility = sourceAction.getSourceAbility();
    }

    @Override
    public void run() {
        EffectBucket.setCurrentResolvingAbilityAndEvent(this.sourceAbility, this.sourceAction.getSourceEvent());
        this.sourceBucket = Game.getCurrentGame().getGameRules().getEffectProcessor().getSourceBucket(this.sourceAbility);
        if (this.sourceAbility instanceof SpellAbility && (this.sourceAbility.getConditionState(this.sourceAbility.getSourceCardIndex()) == AbilityCondition.ConditionState.BAD || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.sourceBucket.getOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_SPELL).check(this.sourceBucket.getOwner(), this.sourceAbility.getSourceCardIndex(), new Object[0]) == RuleCheck.RuleCheckState.BLOCK)) {
            this.sourceAbility.cancel();
            this.sourceBucket.resetReorderLock();
            this.resolveEffect();
            return;
        }
        if (Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse() == null && EffectCallbackThread.canBeCutIn(this.sourceAbility)) {
            CutInResponse cutInResponse = new CutInResponse(this, this.sourceAbility);
            Game.getCurrentGame().getGameRules().getEffectProcessor().setCutInResponse(cutInResponse);
            ((CheckZoneAbility)this.sourceAbility).onActivatedPreTarget();
            Platform.runLater(() -> {
                UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectAsWaitingCutInResponse(this.sourceAbility, true);
                UI.getTabGame().getFieldSceneOverlay().getGameControls().getButtonNextPhase().setDisable(Game.getCurrentGame().getPlayerRole() == this.sourceBucket.getOwner());
                GameField.setHighlightDefaultPlayer(Game.GamePlayerRole.getOpponentRole(this.sourceBucket.getOwner()));
            });
            Game.getCurrentGame().getGameRules().getEffectProcessor().setAsIdle(true);
            cutInResponse.setIsWaitingForOpponentResponse(true);
            Log.printMessage(">>>CUT-IN: " + this.sourceAbility.getSourceCardIndex().getCardReference().getName());
            this.setThreadLock("cut-in");
            Log.printMessage(">>>END CUT-IN: " + this.sourceAbility.getSourceCardIndex().getCardReference().getName());
            cutInResponse.setIsWaitingForOpponentResponse(false);
            Game.getCurrentGame().getGameRules().getEffectProcessor().setAsIdle(false);
            Game.getCurrentGame().getGameRules().getEffectProcessor().setCutInResponse(null);
            if (cutInResponse.hasBeenResponded() && !this.sourceAbility.isCancelled()) {
                Platform.runLater(() -> this.playFlashEffectAnimation(false));
                this.setThreadLock("ani");
            }
            Platform.runLater(() -> {
                UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectAsWaitingCutInResponse(this.sourceAbility, false);
                UI.getTabGame().getFieldSceneOverlay().getGameControls().getButtonNextPhase().setDisable(Game.getCurrentGame().getPlayerRole() != this.sourceBucket.getOwner());
                GameField.setHighlightDefaultPlayer(null);
            });
        } else {
            Ability ability = this.sourceAbility;
            if (ability instanceof CheckZoneAbility) {
                CheckZoneAbility sourceAbilityCZ = (CheckZoneAbility)ability;
                sourceAbilityCZ.onActivatedPreTarget();
            }
        }
        this.sourceBucket.resetReorderLock();
        this.resolveEffect();
    }

    private void resolveEffect() {
        DataTable<CardIndex> data;
        AutoAbility autoAbility;
        GameEvent sourceEvent = this.sourceAction.getSourceEvent();
        Ability ability = this.sourceAbility;
        if (ability instanceof AutoAbility && (autoAbility = (AutoAbility)ability).getEventAccumulator() != null && autoAbility.isUseLimited() && (data = autoAbility.getEventAccumulator().getData(sourceEvent)).size() > autoAbility.getUseLimit()) {
            GameAction action;
            if (PlayerControl.isChoosingPlayer(this.sourceAbility.getAbilityOwner())) {
                action = new ActionManualChoiceEventSource(data);
            } else {
                action = new ActionPlayerChoiceCard();
                action.setSourceCardIndex(this.sourceAbility.getSourceCardIndex());
            }
            action.treatAsMidEffAction();
            action.setCallbackAction(CardAbilities.getEffectCallbackAction());
            Game.getCurrentGame().getActionQueue().addAction(action);
            CardIndex caller = (CardIndex)action.getDataTable().get();
            sourceEvent = autoAbility.getEventAccumulator().getEvents(data).stream().filter(event -> event.getCallerCardIndex() == caller).findFirst().orElse(sourceEvent);
        }
        EffectBucket.setCurrentResolvingAbilityAndEvent(this.sourceAbility, sourceEvent);
        EffectBucket.setLastAbilityAndEvent(this.sourceAbility, sourceEvent);
        EventActivateAbility event2 = new EventActivateAbility(this.sourceAbility);
        this.logEventEffectResolution = new LogEventEffectResolve(event2);
        Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(this.logEventEffectResolution));
        OverrideResult overrideResult = OverrideAction.findActiveOverrideActions(Game.GamePlayerRole.getOpponentRole(this.sourceBucket.getOwner()), this.sourceAction, event2);
        if (!overrideResult.isEmpty()) {
            this.sourceAction.setSourceOverrideResult(overrideResult);
            if (overrideResult.execThreadedActionOverride(CardAbilities.getEffectCallbackAction())) {
                this.sourceAbility.cancel();
            }
        }
        if (!this.sourceAbility.isCancelled()) {
            this.sourceAbility.resolveEffect(sourceEvent.getCallerCardIndex());
            if ((this.sourceAbility.getFlags().getValue() & 0x200) != 0) {
                this.logEventEffectResolution = new LogEventEffectResolve(event2);
                Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(this.logEventEffectResolution));
                this.sourceAbility.resolveEffect(sourceEvent.getCallerCardIndex());
                this.sourceAbility.getFlags().removeValue(512);
            }
        } else {
            this.sourceAbility.getFlags().removeValue(128);
            Platform.runLater(() -> {
                if (this.logEventEffectResolution != null) {
                    this.logEventEffectResolution.disable();
                }
                this.playFlashEffectAnimation(true);
            });
            this.setThreadLock("ani");
        }
        this.sourceAbility.setLastEffectCallbackAction(null);
        this.sourceAbility.onAbilityEnd(true);
        Game.getCurrentGame().getGameLog().addRecord(event2);
        if (this.sourceAction.hasChangedHighlightOwner()) {
            Platform.runLater(() -> GameField.setHighlightDefaultPlayer(null));
        }
        EffectBucket.setCurrentResolvingAbilityAndEvent(null, null);
        Game.getCurrentGame().getGameData().clearTempCardsWithOverriddenLocations();
        Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().removeEffect(this.sourceAbility));
        Game.getCurrentGame().getGameRules().getEffectProcessor().setEffectAsCompleted(this.sourceBucket);
        CutInResponse currentCutInResponse = Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse();
        if (currentCutInResponse != null && currentCutInResponse.getSourceEffectBucket() != this.sourceBucket) {
            currentCutInResponse.setHasBeenResponded();
            Game.getCurrentGame().getGameRules().getEffectProcessor().setAsIdle(true);
        }
    }

    private void playFlashEffectAnimation(boolean isNegated) {
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(() -> this.releaseThreadLock("ani"));
        AnimationFlashEffect aniFlash = !isNegated ? new AnimationFlashEffect(this.sourceAbility) : new AnimationFlashEffectNegate(this.sourceAbility);
        aniFlash.setAnimationTracker(tracker);
        aniFlash.play();
    }

    public EffectBucket getSourceBucket() {
        return this.sourceBucket;
    }

    private static boolean canBeCutIn(Ability sourceAbility) {
        return sourceAbility instanceof SpellAbility || sourceAbility instanceof PieceAbility && sourceAbility.getSourceCardIndex().getCardReference().getLRIGTeam() != null && sourceAbility.getSourceCardIndex().getCardReference().getLRIGTeam() != CardConst.CardLRIGTeam.DREAM_TEAM;
    }
}

