/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.control;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import javafx.scene.paint.Color;
import open.batoru.Settings;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionPutOnFieldSIGNI;
import open.batoru.core.gameplay.control.UtilCardPlayableControl;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.ZonePicker;
import open.batoru.data.DataTable;
import open.batoru.data.ability.AbilityConst;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneCrossIndicatorGuides;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.overlay.OverlayAlertMessage;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.game.overlay.window.OverlayWindowCardList;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ControlPutOnFieldSIGNI {
    public static void attempt(Card3D source) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
        UtilCardPlayableControl.PlayableResult resultPlayable = UtilCardPlayableControl.isPlayable(Game.getCurrentGame().getPlayerRole(), source.getCardIndex(), null);
        if (resultPlayable == UtilCardPlayableControl.PlayableResult.NOT_ALLOWED) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_ALLOWED"));
            return;
        }
        if (resultPlayable == UtilCardPlayableControl.PlayableResult.LRIG_TYPE_MISMATCH) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LRIG"));
            return;
        }
        if (resultPlayable == UtilCardPlayableControl.PlayableResult.LRIG_EXCEED_LEVEL) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LEVEL"));
            return;
        }
        if (source.getCardIndex().getIndexedInstance().getUseCondition() != GameConst.UseCondition.RISE) {
            PutOnFieldZoneSelector selector = new PutOnFieldZoneSelector(source, resultPlayable);
            selector.attempt(zonePicked -> {
                GameConst.SIGNIZonePosition zonePosition = GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(zonePicked.getZoneLocation());
                source.getOwnerZone().swapWithKnownAlternativeIfAvailable(source);
                try {
                    int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
                    GameSendActionAttempt attempt = new GameSendActionAttempt("SIGNI", nextOrder, source.getCardIndex().getId() + "|" + zonePosition.getId());
                    Player.getNetworkFrame().getGameReceiver().setPacketRedirectByToken("SELZX", attempt, RedirectedReceiver.RedirectValidator.ofGameAction(nextOrder), pp -> {
                        selector.release();
                        ActionPutOnFieldSIGNI action = new ActionPutOnFieldSIGNI(source.getCardIndex(), zonePicked.getZoneLocation(), 0);
                        action.setOnActionCompleted(() -> Game.getCurrentGame().getPlayerControl().setCurrentPicker(null));
                        Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, action);
                    });
                    attempt.send();
                }
                catch (UnknownHostException ex) {
                    System.err.println(ex.getMessage());
                }
            });
        } else {
            TargetFilter filter = source.getCardIndex().getIndexedInstance().getUseConditionTargetFilter();
            if (resultPlayable == UtilCardPlayableControl.PlayableResult.USE_CONDITION_FAIL) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_RISE"));
                return;
            }
            int numPicksToRise = source.getCardIndex().getIndexedInstance().getUseConditionNumPicks();
            if (filter.getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
                PutOnFieldZoneSelector selector = new PutOnFieldZoneSelector(source, resultPlayable);
                selector.attempt(zonePicked -> {
                    selector.release();
                    OverlayWindowCardList window = new OverlayWindowCardList(null, LanguageParser.getString("UI_GAME_WINDOW_RISE_DESC"), UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getTrashZone(Deck.DeckType.MAIN).getZoneCardList(), null, filter.getCardValidator(), null, 0, numPicksToRise, AbilityConst.ChoiceLogic.BOOLEAN);
                    field.getHand().getHandHoverAnimation(source).setLock(true);
                    Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    window.getConfirmButton().setOnAction(e -> {
                        if (window.getPickedCount() == 0) {
                            OverlayWindow.removeFromFieldOverlay(window);
                            field.getHand().getHandHoverAnimation(source).setLock(false);
                            Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
                            return;
                        }
                        window.getConfirmButton().setDisable(true);
                        Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
                        StringBuilder packetData = new StringBuilder();
                        for (Card3D card3D : window.getPickedList()) {
                            packetData.append(card3D.getCardIndex().getId()).append("|");
                        }
                        GameConst.SIGNIZonePosition zonePosition = GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(zonePicked.getZoneLocation());
                        try {
                            int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
                            GameSendActionAttempt attempt = new GameSendActionAttempt("SIGNI", nextOrder, source.getCardIndex().getId() + "|" + String.valueOf(packetData) + zonePosition.getId());
                            Player.getNetworkFrame().getGameReceiver().setPacketRedirectByToken("SELCX", attempt, RedirectedReceiver.RedirectValidator.ofGameAction(nextOrder), pp -> {
                                OverlayWindow.removeFromFieldOverlay(window);
                                field.getHand().getHandHoverAnimation(source).setLock(false);
                                Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
                                Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, new ActionPutOnFieldSIGNI(source.getCardIndex(), new DataTable<CardIndex>(window.getCachedPickedListCardIndexes()), zonePicked.getZoneLocation(), 0));
                            });
                            attempt.send();
                        }
                        catch (UnknownHostException ex) {
                            System.err.println(ex.getMessage());
                        }
                    });
                    OverlayWindow.addToFieldOverlay(window);
                });
                return;
            }
            CardPicker picker = new CardPicker(0, numPicksToRise);
            HashMap<GameConst.CardLocation, AnimationBorderIcon> mapAniBorder = new HashMap<GameConst.CardLocation, AnimationBorderIcon>();
            DataTable data = filter.getExportedData();
            for (int i = 0; i < data.size(); ++i) {
                AnimationBorderIcon aniBorder = new AnimationBorderIcon(((CardIndex)data.get(i)).getZoneByLocation(), filter.getHintTargetType());
                aniBorder.play();
                mapAniBorder.put(((CardIndex)data.get(i)).getLocation(), aniBorder);
            }
            if (data.isEmpty()) {
                AnimationBorderIcon.stopAll(mapAniBorder);
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LIMIT"));
                return;
            }
            if (resultPlayable == UtilCardPlayableControl.PlayableResult.ZONE_NO_AVAILABLE) {
                AnimationBorderIcon.stopAll(mapAniBorder);
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_ZONE"));
                return;
            }
            OverlayWindowCard window = new OverlayWindowCard(null, LanguageParser.getString("UI_GAME_WINDOW_RISE_DESC"), 0, numPicksToRise, AbilityConst.ChoiceLogic.BOOLEAN);
            window.setConfirmButtonText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CONFIRM"), LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CANCEL"));
            picker.setOnPickValidate(card3D -> data.contains(card3D.getCardIndex()));
            picker.setOnPickHandled((card3D, wasAdded) -> {
                window.updatePickedCount(picker.getPickedCount());
                if (numPicksToRise > 1) {
                    if (picker.getPickedCount() == numPicksToRise) {
                        mapAniBorder.forEach((location, aniBorder) -> aniBorder.colorize(location == card3D.getCardIndex().getLocation() ? Color.LIMEGREEN : Color.GREY));
                    } else if (picker.getPickedCount() == numPicksToRise - 1 && !wasAdded) {
                        mapAniBorder.values().forEach(aniBorder -> aniBorder.colorize(Color.WHITE));
                    }
                }
            });
            field.getHand().getHandHoverAnimation(source).setLock(true);
            source.getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.SELECTED));
            Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
            window.getConfirmButton().setOnAction(e -> {
                if (picker.getPickedCount() > 0) {
                    Card3D card3D = (Card3D)picker.getPickedList().getLast();
                    if (!UtilCardPlayableControl.isZoneAvailable(Game.getCurrentGame().getPlayerRole(), card3D.getCardIndex(), null, card3D.getCardIndex().getLocation())) {
                        ((FieldZone)card3D.getOwnerZone()).flashZoneMesh(Color.RED);
                        OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_PLACE"), Color.RED);
                        return;
                    }
                }
                if (picker.getPickedCount() == 0) {
                    AnimationBorderIcon.stopAll(mapAniBorder);
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(window);
                    field.getHand().getHandHoverAnimation(source).setLock(false);
                    source.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                    return;
                }
                window.getConfirmButton().setDisable(true);
                Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
                StringJoiner packetData = new StringJoiner("|");
                for (Card3D card3D : picker.getPickedList()) {
                    packetData.add(String.valueOf(card3D.getCardIndex().getId()));
                }
                source.getOwnerZone().swapWithKnownAlternativeIfAvailable(source);
                try {
                    int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
                    GameSendActionAttempt attempt = new GameSendActionAttempt("SIGNI", nextOrder, source.getCardIndex().getId() + "|" + String.valueOf(packetData));
                    Player.getNetworkFrame().getGameReceiver().setPacketRedirectByToken("SELCX", attempt, RedirectedReceiver.RedirectValidator.ofGameAction(nextOrder), pp -> {
                        AnimationBorderIcon.stopAll(mapAniBorder);
                        field.getHand().getHandHoverAnimation(source).setLock(false);
                        source.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                        for (Card3D card3D : picker.getPickedList()) {
                            card3D.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                        }
                        Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
                        ActionPutOnFieldSIGNI action = new ActionPutOnFieldSIGNI(source.getCardIndex(), new DataTable<CardIndex>(picker.getPickedCardIndexList()), 0);
                        action.setOnActionCompleted(() -> Game.getCurrentGame().getPlayerControl().setCurrentPicker(null));
                        Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, action);
                        OverlayWindow.removeFromFieldOverlay(window);
                    });
                    attempt.send();
                }
                catch (UnknownHostException ex) {
                    System.err.println(ex.getMessage());
                }
            });
            OverlayWindow.addToFieldOverlay(window);
        }
    }

    private ControlPutOnFieldSIGNI() {
    }

    public static class PutOnFieldZoneSelector {
        private final Card3D source;
        private final UtilCardPlayableControl.PlayableResult playableResult;
        private final List<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
        private OverlayWindowCard window;
        private FieldZone zonePicked;

        public PutOnFieldZoneSelector(Card3D source, UtilCardPlayableControl.PlayableResult playableResult) {
            this.source = source;
            this.playableResult = playableResult;
        }

        public void attempt(OnZoneSelectedHandler handler) {
            if (this.playableResult == UtilCardPlayableControl.PlayableResult.ZONE_NO_AVAILABLE) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_ZONE"));
                return;
            }
            if (this.playableResult == UtilCardPlayableControl.PlayableResult.LRIG_EXCEED_LIMIT) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LIMIT"));
                return;
            }
            Game.GamePlayerRole rolePlayer = Game.getCurrentGame().getPlayerRole();
            PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
            FieldZoneCrossIndicatorGuides crossIndicatorGuides = new FieldZoneCrossIndicatorGuides();
            for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
                if (ZoneSIGNI.isOccupied(zoneSIGNI) || !UtilCardPlayableControl.isZoneAvailable(rolePlayer, this.source.getCardIndex(), null, zoneSIGNI.getZoneLocation())) continue;
                AnimationBorderIcon aniBorder = new AnimationBorderIcon(zoneSIGNI, TargetFilter.TargetHint.GENERIC);
                aniBorder.play();
                this.listAniBorder.add(aniBorder);
                crossIndicatorGuides.apply(this.source.getCardIndex(), zoneSIGNI);
            }
            if (this.listAniBorder.isEmpty()) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_ZONE"));
                return;
            }
            this.window = new OverlayWindowCard(null, LanguageParser.getString("UI_GAME_WINDOW_SIGNI_DESC"), 0, 1);
            this.window.setConfirmButtonText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CONTINUE"), LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CANCEL"));
            this.window.setShowPickedCount(false);
            this.window.setAutoConfirm(Settings.INSTANCE.shouldAutoConfirmSIGNIPlacement());
            field.getHand().getHandHoverAnimation(this.source).setLock(true);
            this.source.getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.SELECTED));
            ZonePicker picker = new ZonePicker(0, 1);
            picker.setOnPickValidate(zone -> !zone.isFlipped() && GameConst.CardLocation.isSIGNI(zone.getZoneLocation()) && !ZoneSIGNI.isOccupied(zone) && UtilCardPlayableControl.isZoneAvailable(rolePlayer, this.source.getCardIndex(), null, zone.getZoneLocation()));
            picker.setOnPickHandled((zone, wasAdded) -> this.window.updatePickedCount(picker.getPickedCount()));
            Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
            this.window.getConfirmButton().setOnAction(e -> {
                crossIndicatorGuides.clear();
                if (picker.getPickedCount() == 0) {
                    AnimationBorderIcon.stopAll(this.listAniBorder);
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(this.window);
                    field.getHand().getHandHoverAnimation(this.source).setLock(false);
                    this.source.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                    return;
                }
                this.window.getConfirmButton().setDisable(true);
                Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
                Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
                this.zonePicked = (FieldZone)picker.getPickedList().getFirst();
                handler.handle(this.zonePicked);
            });
            OverlayWindow.addToFieldOverlay(this.window);
        }

        public void release() {
            AnimationBorderIcon.stopAll(this.listAniBorder);
            OverlayWindow.removeFromFieldOverlay(this.window);
            UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getHand().getHandHoverAnimation(this.source).setLock(false);
            this.source.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
            this.zonePicked.getZoneMesh().getMaterial().setDiffuseColor(this.zonePicked.getDefaultColor());
            Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
        }

        @FunctionalInterface
        public static interface OnZoneSelectedHandler {
            public void handle(FieldZone var1);
        }
    }
}

