/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.control;

import java.util.Optional;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.RuleCheckCanPlaceSIGNIOnZone;
import open.batoru.data.CardConst;
import open.batoru.data.DataTable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.SpellAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneSIGNI;
import open.batoru.ui.UI;

public final class UtilCardPlayableControl {
    public static PlayableResult isPlayable(Game.GamePlayerRole rolePlayerUser, CardIndex cardIndex, Ability sourceAbility) {
        return UtilCardPlayableControl.isPlayable(rolePlayerUser, cardIndex, sourceAbility, null);
    }

    public static PlayableResult isPlayable(Game.GamePlayerRole rolePlayerUser, CardIndex cardIndex, Ability sourceAbility, GameConst.CardLocation newLocation) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayerUser);
        CardIndex cardIndexLRIG = field.getLRIGZone().getTopCard().getCardIndex();
        if (cardIndex.getIndexedInstance().getLRIGType().getPrimaryValue() != CardConst.CardLRIGType.NO_LRIG_LIMIT && !cardIndex.getIndexedInstance().getLRIGType().matches(cardIndexLRIG.getIndexedInstance().getLRIGType())) {
            return PlayableResult.LRIG_TYPE_MISMATCH;
        }
        switch (cardIndex.getCardReference().getType()) {
            case RESONA: 
            case SIGNI: {
                if (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_NEWLY_PUT_ON_FIELD).check(cardIndex, sourceAbility, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(cardIndex, sourceAbility, new Object[]{GameConst.CardLocation.SIGNI_CENTER}) == RuleCheck.RuleCheckState.BLOCK) {
                    return PlayableResult.NOT_ALLOWED;
                }
                if (cardIndex.getIndexedInstance().getLevel().getValue() > cardIndexLRIG.getIndexedInstance().getLevel().getValue()) {
                    return PlayableResult.LRIG_EXCEED_LEVEL;
                }
                if (cardIndex.getIndexedInstance().getUseCondition() != GameConst.UseCondition.RISE || cardIndex.getIndexedInstance().getUseConditionTargetFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
                    if (field.getSIGNICount(true) + 1 > Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayerUser).getRuleValue(PlayerRuleCheckRegistry.PlayerRuleValueType.MAX_ALLOWED_SIGNI).getValue()) {
                        return PlayableResult.ZONE_NO_AVAILABLE;
                    }
                    if (cardIndex.getSIGNILimitConsumption() + (double)field.getSIGNILimitSum() > cardIndexLRIG.getIndexedInstance().getLimit().getValue()) {
                        return PlayableResult.LRIG_EXCEED_LIMIT;
                    }
                    if (cardIndex.getIndexedInstance().getUseConditionTargetFilter() != null && cardIndex.getIndexedInstance().getUseConditionTargetFilter().getExportedData().size() < cardIndex.getIndexedInstance().getUseConditionNumPicks()) {
                        return PlayableResult.USE_CONDITION_FAIL;
                    }
                    if (newLocation == null) {
                        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
                            if (FieldZone.isOccupied(zoneSIGNI) || !UtilCardPlayableControl.isZoneAvailable(rolePlayerUser, cardIndex, sourceAbility, zoneSIGNI.getZoneLocation())) continue;
                            return PlayableResult.OK;
                        }
                    } else {
                        ZoneSIGNI zoneSIGNI = field.getSIGNIZone(GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(newLocation));
                        if (!FieldZone.isOccupied(zoneSIGNI) && UtilCardPlayableControl.isZoneAvailable(rolePlayerUser, cardIndex, sourceAbility, zoneSIGNI.getZoneLocation())) {
                            return PlayableResult.OK;
                        }
                    }
                } else {
                    TargetFilter filter = cardIndex.getIndexedInstance().getUseConditionTargetFilter();
                    DataTable data = filter.getExportedData();
                    if (data.size() < cardIndex.getIndexedInstance().getUseConditionNumPicks()) {
                        return PlayableResult.USE_CONDITION_FAIL;
                    }
                    if (newLocation == null) {
                        for (int i = 0; i < data.size(); ++i) {
                            CardIndex cardIndexToRiseOn = (CardIndex)data.get(i);
                            if (!UtilCardPlayableControl.isZoneAvailable(rolePlayerUser, cardIndex, sourceAbility, cardIndexToRiseOn.getLocation())) continue;
                            return PlayableResult.OK;
                        }
                    } else if (UtilCardPlayableControl.isZoneAvailable(rolePlayerUser, cardIndex, sourceAbility, newLocation)) {
                        return PlayableResult.OK;
                    }
                }
                return PlayableResult.ZONE_NO_AVAILABLE;
            }
            case SPELL: {
                if (Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayerUser).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_SPELL).check(rolePlayerUser, cardIndex, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
                    return PlayableResult.NOT_ALLOWED;
                }
                Optional<SpellAbility> abilitySpell = SpellAbility.findSpellAbility(cardIndex);
                return abilitySpell.isPresent() && abilitySpell.get().getConditionState(cardIndex) != AbilityCondition.ConditionState.BAD && abilitySpell.get().canPayCost() ? PlayableResult.OK : PlayableResult.GENERIC_FAIL;
            }
        }
        return PlayableResult.GENERIC_FAIL;
    }

    public static boolean isZoneAvailable(Game.GamePlayerRole rolePlayerUser, CardIndex cardIndex, Ability sourceAbility, GameConst.CardLocation location) {
        PlayerRuleCheckRegistry registry = Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayerUser);
        GameConst.SIGNIZonePosition zonePosition = GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(location);
        return RuleCheckCanPlaceSIGNIOnZone.matchesResult((RuleCheckCanPlaceSIGNIOnZone)registry.getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_PLACE_SIGNI_ON_ZONE), rolePlayerUser, zonePosition) && registry.getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_NEWLY_PUT_SIGNI_ON_FIELD).check(rolePlayerUser, cardIndex, sourceAbility, new Object[]{zonePosition}) == RuleCheck.RuleCheckState.OK && AbilityCostList.canPayDataCostLists(((AbilityCost)registry.getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.COST_TO_PLACE_SIGNI_ON_ZONE).check(rolePlayerUser, sourceAbility != null ? sourceAbility.getSourceCardIndex() : null, sourceAbility, new Object[]{cardIndex, zonePosition})).getSourceCostList().getSourceDataCostLists());
    }

    private UtilCardPlayableControl() {
    }

    public static enum PlayableResult {
        NOT_ALLOWED,
        ZONE_NO_AVAILABLE,
        LRIG_TYPE_MISMATCH,
        LRIG_EXCEED_LEVEL,
        LRIG_EXCEED_LIMIT,
        USE_CONDITION_FAIL,
        GENERIC_FAIL,
        OK;

    }
}

