/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.phases;

import java.util.ArrayList;
import java.util.List;
import open.batoru.Log;
import open.batoru.Settings;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.phases.Phase;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class AttackPhaseSIGNI
extends Phase {
    private final List<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();

    public AttackPhaseSIGNI(GameConst.GamePhase id) {
        super(id);
    }

    @Override
    void onStart() {
        Log.printMessage("start: atk/signi");
    }

    @Override
    void onEnd() {
        if (Game.getCurrentGame().getGameRules().isOwnTurn() || Game.getCurrentGame().isNeutralPerspectiveGame()) {
            FX.run(this::hideAvailableAttackers);
        }
    }

    @Override
    public void onIdle() {
        this.resetAvailableAttackers();
        if (Game.getCurrentGame().getGameRules().isOwnTurn() && this.listAniBorder.isEmpty() && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
            UI.getTabGame().getFieldSceneOverlay().getGameControls().setPhaseButtonHighlight(true);
            if (Settings.INSTANCE.shouldAutoSkipSIGNIAttackPhase()) {
                Game.getCurrentGame().getPlayerControl().onManualPhaseNext();
            }
        }
    }

    @Override
    public void onBusy() {
        if (Game.getCurrentGame().getGameRules().isOwnTurn() || Game.getCurrentGame().isNeutralPerspectiveGame()) {
            this.hideAvailableAttackers();
        }
    }

    private void resetAvailableAttackers() {
        if (!Game.getCurrentGame().getGameRules().isOwnTurn() && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
            return;
        }
        this.hideAvailableAttackers();
        this.processPlayerField(UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(!Game.getCurrentGame().isNeutralPerspectiveGame() ? Game.getCurrentGame().getPlayerRole() : Game.getCurrentGame().getGameRules().getTurnPlayer()));
    }

    private void processPlayerField(PlayerField field) {
        block0: for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            Card3D card3D;
            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
            if (!FieldZone.isOccupied(zoneSIGNI) || (card3D = zoneSIGNI.getTopCard()).getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ATTACK).check(card3D.getCardIndex()) == RuleCheck.RuleCheckState.BLOCK || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(card3D.getCardIndex().getIndexedInstance().getCurrentOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_ATTACK).check(card3D.getCardIndex().getIndexedInstance().getCurrentOwner(), card3D.getCardIndex(), new Object[0]) == RuleCheck.RuleCheckState.BLOCK) continue;
            List<AbilityCostList> dataCostListsAttack = ((AbilityCost)card3D.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_ATTACK).check(card3D.getCardIndex())).getSourceCostList().getSourceDataCostLists();
            if (dataCostListsAttack.isEmpty()) {
                AnimationBorderIcon aniBorder = new AnimationBorderIcon(zoneSIGNI, TargetFilter.TargetHint.GENERIC);
                aniBorder.play();
                this.listAniBorder.add(aniBorder);
                continue;
            }
            for (AbilityCostList costList : dataCostListsAttack) {
                if (!costList.canBePaid()) continue;
                AnimationBorderIcon aniBorder = new AnimationBorderIcon(zoneSIGNI, TargetFilter.TargetHint.GENERIC);
                aniBorder.play();
                this.listAniBorder.add(aniBorder);
                continue block0;
            }
        }
    }

    private void hideAvailableAttackers() {
        AnimationBorderIcon.stopAll(this.listAniBorder);
        this.listAniBorder.clear();
        UI.getTabGame().getFieldSceneOverlay().getGameControls().setPhaseButtonHighlight(false);
    }
}

