/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.phases;

import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionGrow;
import open.batoru.core.gameplay.actions.ActionManualGrow;
import open.batoru.core.gameplay.actions.ActionPhaseAdvanceEnd;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.phases.Phase;
import open.batoru.game.PlayerField;
import open.batoru.ui.UI;

public class GrowPhase
extends Phase {
    public GrowPhase(GameConst.GamePhase id) {
        super(id);
    }

    @Override
    void onStart() {
        Log.printMessage("start: grow");
        if (PlayerControl.isChoosingPlayer(Game.getCurrentGame().getGameRules().getTurnPlayer())) {
            PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
            CardIndex cardIndexCurrentLRIG = field.getLRIGZone().getTopCard().getCardIndex();
            int currentLRIGLevel = cardIndexCurrentLRIG.getIndexedInstance().getLevel().getValue();
            if (currentLRIGLevel != 0) {
                CardIndex cardIndexNextLRIG = ActionManualGrow.getNextGrowCandidateLRIG();
                Game.getCurrentGame().getActionQueue().addAction(new ActionManualGrow(cardIndexCurrentLRIG, cardIndexNextLRIG));
            } else {
                Game.getCurrentGame().getActionQueue().addAction(new ActionGrow());
            }
        } else {
            Game.getCurrentGame().getActionQueue().addAction(new ActionGrow());
        }
    }

    @Override
    public void onIdle() {
        Game.getCurrentGame().getActionQueue().addAction(new ActionPhaseAdvanceEnd());
    }
}

