/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.phases;

import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionPhaseAdvanceStart;
import open.batoru.data.ability.events.EventPhaseEnd;
import open.batoru.data.ability.events.EventPhaseStart;

public abstract class Phase {
    private final GameConst.GamePhase id;
    private final boolean shouldCallEffects;
    private Boolean shouldForceCallNextEffects;

    public Phase(GameConst.GamePhase id) {
        this(id, true);
    }

    public Phase(GameConst.GamePhase id, boolean shouldCallEffects) {
        this.id = id;
        this.shouldCallEffects = shouldCallEffects;
    }

    public GameConst.GamePhase getId() {
        return this.id;
    }

    public final void setShouldForceCallNextEffects(boolean set) {
        this.shouldForceCallNextEffects = set;
    }

    public final void internalOnStart() {
        Game.getCurrentGame().getChronoScheduler().tick(Game.getCurrentGame().getGameRules().getTurnPlayer(), this.getId(), false);
        Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventPhaseStart(this.id));
        Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> {
            if (this.shouldCallEffects && this.shouldForceCallNextEffects == null || this.shouldForceCallNextEffects != null && this.shouldForceCallNextEffects.booleanValue()) {
                this.shouldForceCallNextEffects = null;
                Game.getCurrentGame().getGameRules().getEffectProcessor().setOnEffectProcessingFinished(this::onStart);
                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            } else {
                this.onStart();
            }
        });
        Game.getCurrentGame().getGameRules().getRuleProcessor().process();
    }

    public final void internalOnEnd() {
        Game.getCurrentGame().getChronoScheduler().tick(Game.getCurrentGame().getGameRules().getTurnPlayer(), this.getId(), true);
        Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventPhaseEnd(this.id));
        Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> {
            if (this.shouldCallEffects && this.shouldForceCallNextEffects == null || this.shouldForceCallNextEffects != null && this.shouldForceCallNextEffects.booleanValue()) {
                this.shouldForceCallNextEffects = null;
                Game.getCurrentGame().getGameRules().getEffectProcessor().setOnEffectProcessingFinished(() -> {
                    this.onEnd();
                    Game.getCurrentGame().getActionQueue().addAction(new ActionPhaseAdvanceStart());
                });
                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            } else {
                this.onEnd();
                Game.getCurrentGame().getActionQueue().addAction(new ActionPhaseAdvanceStart());
            }
        });
        Game.getCurrentGame().getGameRules().getRuleProcessor().process();
    }

    public final void internalOnIdle() {
        Game.getCurrentGame().getGameData().processClearPrivateCardImageSets();
        this.onIdle();
    }

    abstract void onStart();

    void onEnd() {
    }

    public void onIdle() {
    }

    public void onBusy() {
    }
}

