/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.phases;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.phases.AttackPhaseLRIG;
import open.batoru.core.gameplay.phases.AttackPhasePreDef;
import open.batoru.core.gameplay.phases.AttackPhaseSIGNI;
import open.batoru.core.gameplay.phases.DrawPhase;
import open.batoru.core.gameplay.phases.EndPhase;
import open.batoru.core.gameplay.phases.EnerPhase;
import open.batoru.core.gameplay.phases.GrowPhase;
import open.batoru.core.gameplay.phases.MainPhase;
import open.batoru.core.gameplay.phases.Phase;
import open.batoru.core.gameplay.phases.UpPhase;

public class PhaseList
implements Disposable {
    private final List<Phase> listPhases = new ArrayList<Phase>();
    private int currentPhase;
    private boolean shouldSkipNextPhase;

    public PhaseList() {
        this.listPhases.add(new UpPhase(GameConst.GamePhase.UP));
        this.listPhases.add(new DrawPhase(GameConst.GamePhase.DRAW));
        this.listPhases.add(new EnerPhase(GameConst.GamePhase.ENER));
        this.listPhases.add(new GrowPhase(GameConst.GamePhase.GROW));
        this.listPhases.add(new MainPhase(GameConst.GamePhase.MAIN));
        this.listPhases.add(new AttackPhasePreDef(GameConst.GamePhase.ATTACK_PRE, true));
        this.listPhases.add(new AttackPhasePreDef(GameConst.GamePhase.ATTACK_DEF, false));
        this.listPhases.add(new AttackPhaseSIGNI(GameConst.GamePhase.ATTACK_SIGNI));
        this.listPhases.add(new AttackPhaseLRIG(GameConst.GamePhase.ATTACK_LRIG));
        this.listPhases.add(new EndPhase(GameConst.GamePhase.END));
    }

    public int getLastPhaseIndex() {
        return this.listPhases.size() - 1;
    }

    public void advancePhaseId() {
        this.setPhaseId(++this.currentPhase);
    }

    public void setPhaseId(int id) {
        this.currentPhase = id < this.listPhases.size() ? id : 0;
    }

    public Phase getCurrentPhase() {
        return this.listPhases.get(this.currentPhase);
    }

    public Phase getNextPhase() {
        int nextPhase;
        if (this.shouldSkipNextPhase) {
            this.advancePhaseId();
            this.shouldSkipNextPhase = false;
        }
        return this.listPhases.get((nextPhase = this.currentPhase + 1) < this.listPhases.size() ? nextPhase : 0);
    }

    public void skipNextPhase() {
        this.shouldSkipNextPhase = true;
    }

    @Override
    public void dispose() {
        this.listPhases.clear();
    }
}

