/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.phases;

import java.util.ArrayList;
import java.util.List;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionManualChoiceCost;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.actions.ActionPhaseAdvanceEnd;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.actions.ActionUp;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.phases.Phase;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.ui.UI;

public class UpPhase
extends Phase {
    private final List<CardIndex> listDownedCards = new ArrayList<CardIndex>();
    private final List<CardIndex> listFrozenCards = new ArrayList<CardIndex>();
    private final List<ActionUp> listUpActions = new ArrayList<ActionUp>();
    private int countUpped;

    public UpPhase(GameConst.GamePhase id) {
        super(id);
    }

    @Override
    void onStart() {
        Log.printMessage("start: up");
        Game.GamePlayerRole turnPlayer = Game.getCurrentGame().getGameRules().getTurnPlayer();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(turnPlayer);
        this.upCard(field.getLRIGZone().getTopCard());
        if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft())) {
            this.upCard(field.getLRIGAssistZoneLeft().getTopCard());
        }
        if (FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
            this.upCard(field.getLRIGAssistZoneRight().getTopCard());
        }
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
            if (!FieldZone.isOccupied(zoneSIGNI)) continue;
            this.upCard(zoneSIGNI.getTopCard());
        }
        for (int i = 0; i < this.listDownedCards.size(); ++i) {
            CardIndex cardIndex = this.listDownedCards.get(i);
            List<AbilityCostList> dataCostListsUp = ((AbilityCost)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(turnPlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.COST_TO_UP).check(new PlayerRuleCheckData(null, null, null, cardIndex))).getSourceCostList().getSourceDataCostLists();
            if (!dataCostListsUp.isEmpty()) {
                GameAction action = PlayerControl.isChoosingPlayer(turnPlayer) ? new ActionManualChoiceCost(dataCostListsUp) : new ActionPlayerChoiceInteger();
                action.setOnActionCompleted(() -> {
                    if (ActionPayCost.isCostActionSuccessful(action)) {
                        AbilityCostList costListChosen = (AbilityCostList)dataCostListsUp.get((Integer)action.getDataTable().get());
                        costListChosen.setForcedMandatoryState(false);
                        costListChosen.setOnCostHandledAll(() -> {
                            if (costListChosen.isPaid()) {
                                this.listUpActions.add(new ActionUp(cardIndex));
                            }
                            if (++this.countUpped == this.listDownedCards.size()) {
                                this.callUpActions();
                            }
                        });
                        Game.getCurrentGame().getActionQueue().addAction(new ActionPayCost(costListChosen));
                    }
                });
                action.treatAsMidEffAction();
                Game.getCurrentGame().getActionQueue().addAction(action);
                continue;
            }
            this.listUpActions.add(new ActionUp(cardIndex));
            if (++this.countUpped != this.listDownedCards.size()) continue;
            this.callUpActions();
        }
    }

    private void callUpActions() {
        ActionUp prevAction = null;
        for (int i = 0; i < this.listUpActions.size(); ++i) {
            ActionUp action = this.listUpActions.get(i);
            action.setAtOnce(prevAction, i, this.listUpActions.size());
            prevAction = action;
            Game.getCurrentGame().getActionQueue().addAction(action);
        }
        this.listDownedCards.clear();
        this.listUpActions.clear();
        this.countUpped = 0;
    }

    private void upCard(Card3D card3D) {
        CardIndex cardIndex = card3D.getCardIndex();
        if (!cardIndex.getIndexedInstance().isState(65536)) {
            if (cardIndex.getIndexedInstance().isState(16384)) {
                this.listDownedCards.add(cardIndex);
            }
        } else {
            this.listFrozenCards.add(cardIndex);
        }
    }

    @Override
    void onEnd() {
        for (CardIndex cardIndex : this.listFrozenCards) {
            cardIndex.getIndexedInstance().getCardStateFlags().removeValue(65536);
        }
        this.listFrozenCards.clear();
    }

    @Override
    public void onIdle() {
        Game.getCurrentGame().getActionQueue().addAction(new ActionPhaseAdvanceEnd());
    }
}

