/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.pickers;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Disposable;
import open.batoru.networking.PacketParser;

public abstract class Picker<T>
implements Disposable {
    private final List<T> listPicks = new ArrayList<T>();
    private final int minPicks;
    private final int maxPicks;
    private PickerStatus status;
    private boolean isLocked;

    public Picker(int minPicks, int maxPicks) {
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
    }

    public abstract void pick(Object var1);

    public void updatePickerStatus() {
        this.status = this.listPicks.isEmpty() ? PickerStatus.NO : (this.listPicks.size() < this.minPicks ? PickerStatus.FEW : (this.listPicks.size() < this.maxPicks ? PickerStatus.MIN : PickerStatus.MAX));
    }

    public PickerStatus getStatus() {
        return this.status;
    }

    public int getMinPicks() {
        return this.minPicks;
    }

    public int getMaxPicks() {
        return this.maxPicks;
    }

    public int getPickedCount() {
        return this.listPicks.size();
    }

    public void setLock(boolean lock) {
        this.isLocked = lock;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public List<T> getPickedList() {
        return this.listPicks;
    }

    public abstract void forceFakePick(PacketParser var1);

    @Override
    public void dispose() {
        this.listPicks.clear();
    }

    public static enum PickerStatus {
        NO,
        FEW,
        MIN,
        MAX;

    }
}

