/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.pickers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import open.batoru.Log;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionAttach;
import open.batoru.core.gameplay.callback.EffectCallbackThread;
import open.batoru.core.gameplay.control.UtilCardPlayableControl;
import open.batoru.core.gameplay.pickers.PickValidator;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataColor;
import open.batoru.data.CardDataLRIGType;
import open.batoru.data.CardDataSIGNIClass;
import open.batoru.data.Cost;
import open.batoru.data.DataTable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.CardFunctionalConditionalHandler;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.game.FieldData;
import open.batoru.game.FieldStackZone;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.parsers.LanguageParser;

public class TargetFilter {
    public static final int HINT_OWNER_OWN = 1;
    public static final int HINT_OWNER_OP = 2;
    private final Set<GameConst.CardLocation> hintListLocations = new LinkedHashSet<GameConst.CardLocation>();
    private int hintFlagsOwner = 3;
    private int hintFlagsFilter = 0;
    private TargetHint hintTargetType;
    private boolean isTargeted;
    private TargetContext targetContext = TargetContext.CARD;
    private TargetScope targetScope = TargetScope.CARD;
    private CardIndex sourceCardIndex;
    private Ability sourceAbility;
    private Game.GamePlayerRole sourceTargetRole;
    private CardIndex contextCardIndex;
    private static CardIndex defaultSourceCardIndex;
    private static Ability defaultSourceAbility;
    private final DataTable<Targetable> dataExported = new DataTable();
    private List<TargetFilter> requiredFilters;
    private final PickValidator<Card3D> validatorCard = this::isPickValid;
    private final PickValidator<FieldZone> validatorZone = this::isPickValid;
    private final List<PickValidator<Card3D>> listValidatorsCard = new ArrayList<PickValidator<Card3D>>();
    private final List<PickValidator<FieldZone>> listValidatorsZone = new ArrayList<PickValidator<FieldZone>>();
    private static boolean isUnsafeMode;

    public TargetFilter() {
        this(TargetHint.GENERIC);
    }

    public TargetFilter(TargetHint hintTargetType) {
        this(hintTargetType, null);
    }

    public TargetFilter(TargetHint hintTargetType, Game.GamePlayerRole sourceTargetRole) {
        this(hintTargetType, TargetFilter.getDefaultSourceCardIndex(), TargetFilter.getDefaultSourceAbility(), sourceTargetRole);
    }

    public TargetFilter(TargetHint hintTargetType, CardIndex sourceCardIndex, Ability sourceAbility, Game.GamePlayerRole sourceTargetRole) {
        this.hintTargetType = hintTargetType;
        this.sourceTargetRole = sourceTargetRole;
        this.listValidatorsCard.add(card3D -> this.hintFlagsOwner == 3 || this.hintFlagsOwner == 1 && card3D.getCardIndex().getCurrentOwnerSafe() == this.getSourceTargetRole() || this.hintFlagsOwner == 2 && card3D.getCardIndex().getCurrentOwnerSafe() != this.getSourceTargetRole());
        this.listValidatorsZone.add(fieldZone -> this.hintFlagsOwner == 3 || this.hintFlagsOwner == 1 && Zone.getZoneOwner(fieldZone) == this.getSourceTargetRole() || this.hintFlagsOwner == 2 && Zone.getZoneOwner(fieldZone) != this.getSourceTargetRole());
        if (sourceAbility != null) {
            this.setSourceAbility(sourceAbility);
        } else if (sourceCardIndex != null) {
            this.setSourceCardIndex(sourceCardIndex);
        }
    }

    public static void setDefaultSources(CardIndex sourceCardIndex, Ability sourceAbility) {
        defaultSourceCardIndex = sourceCardIndex;
        defaultSourceAbility = sourceAbility;
    }

    public static CardIndex getDefaultSourceCardIndex() {
        return isUnsafeMode || !(Thread.currentThread() instanceof EffectCallbackThread) || EffectBucket.getCurrentResolvingAbility() == null ? defaultSourceCardIndex : EffectBucket.getCurrentResolvingAbility().getSourceCardIndex();
    }

    public static Ability getDefaultSourceAbility() {
        return isUnsafeMode || !(Thread.currentThread() instanceof EffectCallbackThread) || EffectBucket.getCurrentResolvingAbility() == null ? defaultSourceAbility : EffectBucket.getCurrentResolvingAbility();
    }

    public static void setIsUnsafeMode(boolean set) {
        isUnsafeMode = set;
    }

    public void setTargetContext(TargetContext targetContext) {
        this.targetContext = targetContext;
    }

    public void setTargetHint(TargetHint hintTargetType) {
        this.hintTargetType = hintTargetType;
    }

    public void setTargetRole(Game.GamePlayerRole sourceTargetRole) {
        this.sourceTargetRole = sourceTargetRole;
    }

    public final void setSourceCardIndex(CardIndex sourceCardIndex) {
        this.sourceCardIndex = sourceCardIndex;
    }

    public final void setSourceAbility(Ability ability) {
        this.sourceAbility = ability;
        if (ability != null && ability.getSourceCardIndex() != null) {
            this.sourceCardIndex = ability.getSourceCardIndex();
        }
    }

    public final Game.GamePlayerRole getSourceTargetRole() {
        return this.sourceTargetRole == null ? this.getSourceCardIndex().getCurrentOwnerSafe() : this.sourceTargetRole;
    }

    public final CardIndex getSourceCardIndex() {
        return this.sourceCardIndex;
    }

    public final CardIndex getContextCardIndex() {
        return this.contextCardIndex;
    }

    public boolean isPickValid(Card3D card3D) {
        if (card3D.getCardIndex().getIndexedInstance() == null && !this.isCardInstanceSafe() || this.isTargeted && !this.canBeTargeted(card3D.getCardIndex())) {
            return false;
        }
        return this.listValidatorsCard.stream().allMatch(validator -> validator.isPickValid(card3D));
    }

    public boolean isPickValid(FieldZone fieldZone) {
        return this.listValidatorsZone.stream().allMatch(validator -> validator.isPickValid(fieldZone));
    }

    public boolean canBeTargeted(CardIndex cardIndex) {
        return this.sourceAbility != null && cardIndex.getIndexedInstance() != null && cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_TARGETED).check(cardIndex, this.getSourceCardIndex(), this.sourceAbility, new Object[]{this.getSourceTargetRole()}) == RuleCheck.RuleCheckState.OK;
    }

    public void setAsTargeted(boolean set) {
        this.isTargeted = set;
    }

    public boolean isTargeted() {
        return this.isTargeted;
    }

    public PickValidator<Card3D> getCardValidator() {
        return this.validatorCard;
    }

    public PickValidator<FieldZone> getZoneValidator() {
        return this.validatorZone;
    }

    public TargetFilter OP() {
        this.hintFlagsOwner = 2;
        return this;
    }

    public TargetFilter own() {
        this.hintFlagsOwner = 1;
        return this;
    }

    public TargetFilter ownedBy(Game.GamePlayerRole rolePlayer) {
        return rolePlayer == this.getSourceTargetRole() ? this.own() : this.OP();
    }

    public TargetFilter ownedBy(FieldZone fieldZone) {
        return fieldZone.isFlipped() && this.getSourceTargetRole() == Game.GamePlayerRole.HOST ? this.own() : this.OP();
    }

    public TargetFilter except(CardIndex cardIndex) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex() != cardIndex);
        this.listValidatorsZone.add(fieldZone -> fieldZone != cardIndex.getZoneByLocation());
        return this;
    }

    public TargetFilter except(int cardId) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getId() != cardId);
        return this;
    }

    public TargetFilter except(String name) {
        this.listValidatorsCard.add(card3D -> !card3D.getCardIndex().getIndexedInstance().getName().getValue().contains(name));
        return this;
    }

    public TargetFilter except(CardConst.CardType cardType) {
        this.listValidatorsCard.add(card3D -> !card3D.getCardIndex().getIndexedInstance().matchesTypeByRef(this.sourceAbility, cardType));
        return this;
    }

    public TargetFilter except(DataTable<CardIndex> data) {
        this.listValidatorsCard.add(card3D -> !data.contains(card3D.getCardIndex()));
        return this;
    }

    public TargetFilter except(GameConst.CardLocation ... locations) {
        List.of(locations).forEach(this.hintListLocations::remove);
        return this;
    }

    public TargetFilter match(CardIndex cardIndex) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex() == cardIndex);
        this.listValidatorsZone.add(fieldZone -> fieldZone == cardIndex.getZoneByLocation());
        return this;
    }

    public TargetFilter match(int cardId) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getId() == cardId);
        return this;
    }

    public TargetFilter match(DataTable<CardIndex> data) {
        if (data != null) {
            this.listValidatorsCard.add(card3D -> data.contains(card3D.getCardIndex()));
        }
        return this;
    }

    public TargetFilter unoccupied() {
        this.listValidatorsZone.add(fieldZone -> !ZoneSIGNI.isOccupied(fieldZone));
        this.targetScope = TargetScope.ZONE;
        return this;
    }

    public TargetFilter zone() {
        this.targetScope = TargetScope.ZONE;
        this.targetContext = TargetContext.ZONE;
        return this;
    }

    public TargetFilter anyCard() {
        this.listValidatorsCard.add(card3D -> !card3D.getCardIndex().getIndexedInstance().isState(8));
        this.targetScope = TargetScope.ZONE;
        return this;
    }

    public TargetFilter over(int cardId) {
        this.listValidatorsCard.add(card3D -> {
            Zone zone = card3D.getCardIndex().getZoneByLocation();
            if (!(zone instanceof FieldZone)) {
                return false;
            }
            FieldZone fieldZone = (FieldZone)zone;
            CardIndex cardIndex = Game.getCurrentGame().getIndexRegistry().getIndex(cardId);
            return fieldZone == cardIndex.getZoneByLocation() && fieldZone.getTopCard() == card3D && cardIndex != card3D.getCardIndex();
        });
        return this;
    }

    public TargetFilter under(int cardIdOver) {
        return this.under(Game.getCurrentGame().getIndexRegistry().getIndex(cardIdOver));
    }

    public TargetFilter under(CardIndex cardIndexOver) {
        return this.under(cardIndexOver, GameConst.CardUnderCategory.UNDER.getFlags());
    }

    public TargetFilter under(CardIndex cardIndexOver, int flagsUnderType) {
        this.listValidatorsCard.add(card3D -> (GameConst.CardLocation.isSIGNI(cardIndexOver.getLocation()) || GameConst.CardLocation.isLRIG(cardIndexOver.getLocation())) && card3D.getCardIndex() != cardIndexOver && card3D.getCardIndex().getZoneByLocation() == cardIndexOver.getZoneByLocation() && (card3D.getCardIndex().getUnderType().getFlags() & flagsUnderType) != 0);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_LEFT);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_CENTER);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_RIGHT);
        this.hintListLocations.add(GameConst.CardLocation.CHEER);
        this.hintListLocations.add(GameConst.CardLocation.LRIG);
        this.hintListLocations.add(GameConst.CardLocation.LRIG_ASSIST_LEFT);
        this.hintListLocations.add(GameConst.CardLocation.LRIG_ASSIST_RIGHT);
        this.targetScope = TargetScope.ZONE;
        return this;
    }

    public TargetFilter under(DataTable<CardIndex> data) {
        return this.under(data, GameConst.CardUnderCategory.UNDER.getFlags());
    }

    public TargetFilter under(DataTable<CardIndex> data, int flagsUnderType) {
        this.listValidatorsCard.add(card3D -> {
            for (int i = 0; i < data.size(); ++i) {
                CardIndex cardIndexOver = (CardIndex)data.get(i);
                if (!GameConst.CardLocation.isSIGNI(cardIndexOver.getLocation()) && !GameConst.CardLocation.isLRIG(cardIndexOver.getLocation()) || card3D.getCardIndex() == cardIndexOver || card3D.getCardIndex().getZoneByLocation() != cardIndexOver.getZoneByLocation() || (card3D.getCardIndex().getUnderType().getFlags() & flagsUnderType) == 0) continue;
                return true;
            }
            return false;
        });
        for (int i = 0; i < data.size(); ++i) {
            this.hintListLocations.add(data.get(i).getLocation());
        }
        this.targetScope = TargetScope.ZONE;
        return this;
    }

    public TargetFilter withUnderType(GameConst.CardUnderType underType) {
        return this.withUnderType(underType.getFlags());
    }

    public TargetFilter withUnderType(GameConst.CardUnderCategory underCategory) {
        return this.withUnderType(underCategory.getFlags());
    }

    public TargetFilter withUnderType(int flagsUnderType) {
        this.listValidatorsCard.add(card3D -> (card3D.getCardIndex().getUnderType().getFlags() & flagsUnderType) != 0 || card3D.getCardIndex().getUnderType().getFlags() == flagsUnderType);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_LEFT);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_CENTER);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_RIGHT);
        this.hintListLocations.add(GameConst.CardLocation.CHEER);
        this.hintListLocations.add(GameConst.CardLocation.LRIG);
        this.hintListLocations.add(GameConst.CardLocation.LRIG_ASSIST_LEFT);
        this.hintListLocations.add(GameConst.CardLocation.LRIG_ASSIST_RIGHT);
        this.targetScope = TargetScope.ZONE;
        return this;
    }

    public TargetFilter withCardsUnder(GameConst.CardUnderType underType) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getCardsUnderCount(underType) > 0);
        return this;
    }

    public TargetFilter withCardsUnder(GameConst.CardUnderCategory underCategory) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getCardsUnderCount(underCategory) > 0);
        return this;
    }

    public TargetFilter withCardsUnder(int flagsUnderType) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getCardsUnderCount(flagsUnderType) > 0);
        return this;
    }

    public TargetFilter withZoneObject(GameConst.CardUnderType underType) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().hasZoneObject(underType));
        this.listValidatorsZone.add(fieldZone -> {
            FieldStackZone fieldStackZone;
            return fieldZone instanceof FieldStackZone && (fieldStackZone = (FieldStackZone)fieldZone).hasZoneObject(underType);
        });
        return this;
    }

    public TargetFilter attachable(GameConst.CardUnderType underType) {
        this.listValidatorsCard.add(card3D -> underType.getUnderCategory() == GameConst.CardUnderCategory.ATTACHED && ActionAttach.canAttachTo(card3D.getCardIndex(), underType));
        return this;
    }

    public TargetFilter upped() {
        this.listValidatorsCard.add(card3D -> !card3D.getCardIndex().getIndexedInstance().isState(16384));
        return this;
    }

    public TargetFilter downed() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().isState(16384));
        return this;
    }

    public TargetFilter frozen() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().isState(65536));
        return this;
    }

    public TargetFilter dissona() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().isState(32));
        return this;
    }

    public TargetFilter crossed() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().isCrossed());
        return this;
    }

    public TargetFilter drive() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().isState(0x200000));
        return this;
    }

    public TargetFilter guard() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().isState(2));
        return this;
    }

    public TargetFilter lifeBurst() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().findLifeBurstAbility().isPresent());
        return this;
    }

    public TargetFilter faceUp() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().isFaceUp());
        this.targetScope = TargetScope.ZONE;
        return this;
    }

    public TargetFilter infected() {
        return this.withZoneObject(GameConst.CardUnderType.ZONE_VIRUS);
    }

    public TargetFilter fromRevealed() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getLocation() == GameConst.CardLocation.REVEALED);
        this.hintListLocations.clear();
        this.hintListLocations.add(GameConst.CardLocation.REVEALED);
        return this;
    }

    public TargetFilter fromLooked() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getLocation() == GameConst.CardLocation.LOOKED);
        this.hintListLocations.clear();
        this.hintListLocations.add(GameConst.CardLocation.LOOKED);
        return this;
    }

    public TargetFilter fromEner() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getLocation() == GameConst.CardLocation.ENER);
        this.listValidatorsZone.add(fieldZone -> fieldZone.getZoneLocation() == GameConst.CardLocation.ENER);
        this.hintListLocations.clear();
        this.hintListLocations.add(GameConst.CardLocation.ENER);
        return this;
    }

    public TargetFilter fromCheckZone() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getLocation() == GameConst.CardLocation.CHECK_ZONE);
        this.listValidatorsZone.add(fieldZone -> fieldZone.getZoneLocation() == GameConst.CardLocation.CHECK_ZONE);
        this.hintListLocations.clear();
        this.hintListLocations.add(GameConst.CardLocation.CHECK_ZONE);
        this.targetScope = TargetScope.ZONE;
        return this;
    }

    public TargetFilter fromTrash() {
        return this.fromTrash(Deck.DeckType.MAIN);
    }

    public TargetFilter fromTrash(Deck.DeckType deckType) {
        GameConst.CardLocation location = deckType == Deck.DeckType.MAIN ? GameConst.CardLocation.TRASH : GameConst.CardLocation.TRASH_LRIG;
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getLocation() == location);
        this.listValidatorsZone.add(fieldZone -> fieldZone.getZoneLocation() == location);
        this.hintListLocations.clear();
        this.hintListLocations.add(location);
        return this;
    }

    public TargetFilter fromHand() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().isEffectivelyAtLocation(GameConst.CardLocation.HAND));
        this.listValidatorsZone.add(fieldZone -> fieldZone.getZoneLocation() == GameConst.CardLocation.HAND);
        this.hintListLocations.clear();
        this.hintListLocations.add(GameConst.CardLocation.HAND);
        return this;
    }

    public TargetFilter fromLocation(GameConst.CardLocation ... locations) {
        this.listValidatorsCard.add(card3D -> Arrays.stream(locations).anyMatch(card3D.getCardIndex()::isEffectivelyAtLocation));
        this.listValidatorsZone.add(fieldZone -> Arrays.stream(locations).anyMatch(location -> fieldZone.getZoneLocation() == location));
        this.hintListLocations.clear();
        this.hintListLocations.addAll(List.of(locations));
        this.hintListLocations.add(GameConst.CardLocation.REVEALED);
        this.hintListLocations.add(GameConst.CardLocation.LOOKED);
        return this;
    }

    public TargetFilter fromSafeLocation(GameConst.CardLocation ... locations) {
        this.listValidatorsCard.add(card3D -> Arrays.stream(locations).anyMatch(location -> card3D.getCardIndex().getLocation() == location));
        this.hintListLocations.clear();
        this.hintListLocations.addAll(List.of(locations));
        this.targetScope = TargetScope.ZONE;
        this.hintFlagsFilter |= 2;
        return this;
    }

    public TargetFilter SIGNI() {
        this.listValidatorsCard.add(card3D -> {
            CardIndex cardIndex = card3D.getCardIndex();
            if (GameConst.CardLocation.isSIGNI(cardIndex.getLocation())) {
                return this.targetScope == TargetScope.ZONE && cardIndex.getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE || this.targetScope == TargetScope.CARD && cardIndex.getZoneByLocation().getTopCard().getCardIndex() == cardIndex;
            }
            return this.hintListLocations.contains((Object)cardIndex.getLocation()) && cardIndex.getIndexedInstance().matchesTypeByRef(this.sourceAbility, CardConst.CardType.SIGNI, CardConst.CardType.RESONA);
        });
        this.listValidatorsZone.add(fieldZone -> GameConst.CardLocation.isSIGNI(fieldZone.getZoneLocation()) && fieldZone.getZoneLocation() != GameConst.CardLocation.CHEER);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_LEFT);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_CENTER);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_RIGHT);
        this.hintListLocations.add(GameConst.CardLocation.CHEER);
        return this;
    }

    public TargetFilter Resona() {
        this.listValidatorsCard.add(card3D -> {
            CardIndex cardIndex = card3D.getCardIndex();
            if (GameConst.CardLocation.isSIGNI(cardIndex.getLocation()) && cardIndex.getIndexedInstance().matchesTypeByRef(this.sourceAbility, CardConst.CardType.RESONA)) {
                return this.targetScope == TargetScope.ZONE && cardIndex.getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE || this.targetScope == TargetScope.CARD && cardIndex.getZoneByLocation().getTopCard().getCardIndex() == cardIndex;
            }
            return this.hintListLocations.contains((Object)cardIndex.getLocation()) && cardIndex.getIndexedInstance().matchesTypeByRef(this.sourceAbility, CardConst.CardType.RESONA);
        });
        this.listValidatorsZone.add(fieldZone -> GameConst.CardLocation.isSIGNI(fieldZone.getZoneLocation()));
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_LEFT);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_CENTER);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_RIGHT);
        return this;
    }

    public TargetFilter anyLRIG() {
        this.listValidatorsCard.add(card3D -> {
            CardIndex cardIndex = card3D.getCardIndex();
            if (GameConst.CardLocation.isLRIG(cardIndex.getLocation()) && this.targetScope != TargetScope.ZONE) {
                return cardIndex.getZoneByLocation().getTopCard().getCardIndex() == cardIndex;
            }
            return this.hintListLocations.contains((Object)cardIndex.getLocation()) && cardIndex.getIndexedInstance().matchesTypeByRef(this.sourceAbility, CardConst.CardType.LRIG, CardConst.CardType.LRIG_ASSIST);
        });
        this.listValidatorsZone.add(fieldZone -> GameConst.CardLocation.isLRIG(fieldZone.getZoneLocation()));
        this.hintListLocations.add(GameConst.CardLocation.LRIG);
        this.hintListLocations.add(GameConst.CardLocation.LRIG_ASSIST_LEFT);
        this.hintListLocations.add(GameConst.CardLocation.LRIG_ASSIST_RIGHT);
        return this;
    }

    public TargetFilter LRIG() {
        this.listValidatorsCard.add(card3D -> {
            CardIndex cardIndex = card3D.getCardIndex();
            if (cardIndex.getLocation() == GameConst.CardLocation.LRIG) {
                return cardIndex.getZoneByLocation().getTopCard().getCardIndex() == cardIndex;
            }
            return this.hintListLocations.contains((Object)cardIndex.getLocation()) && cardIndex.getIndexedInstance().matchesTypeByRef(this.sourceAbility, CardConst.CardType.LRIG);
        });
        this.listValidatorsZone.add(fieldZone -> fieldZone.getZoneLocation() == GameConst.CardLocation.LRIG);
        this.hintListLocations.add(GameConst.CardLocation.LRIG);
        return this;
    }

    public TargetFilter spell() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().matchesTypeByRef(this.sourceAbility, CardConst.CardType.SPELL));
        this.hintListLocations.add(GameConst.CardLocation.CHECK_ZONE);
        return this;
    }

    public TargetFilter key() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().matchesTypeByRef(this.sourceAbility, CardConst.CardType.KEY));
        this.hintListLocations.add(GameConst.CardLocation.KEY);
        return this;
    }

    public TargetFilter ARTS() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().matchesTypeByRef(this.sourceAbility, CardConst.CardType.ARTS));
        this.hintListLocations.add(GameConst.CardLocation.CHECK_ZONE);
        this.hintListLocations.add(GameConst.CardLocation.DECK_LRIG);
        return this;
    }

    public TargetFilter piece() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().matchesTypeByRef(this.sourceAbility, CardConst.CardType.PIECE));
        this.hintListLocations.add(GameConst.CardLocation.CHECK_ZONE);
        this.hintListLocations.add(GameConst.CardLocation.DECK_LRIG);
        return this;
    }

    public TargetFilter left() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getLocation() == GameConst.CardLocation.getLeftSIGNILocation(this.sourceCardIndex.getLocation()));
        this.hintFlagsFilter |= 4;
        return this;
    }

    public TargetFilter right() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getLocation() == GameConst.CardLocation.getRightSIGNILocation(this.sourceCardIndex.getLocation()));
        this.hintFlagsFilter |= 8;
        return this;
    }

    public TargetFilter opposite() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getLocation() == GameConst.CardLocation.getOppositeSIGNILocation(this.sourceCardIndex.getLocation()));
        return this;
    }

    public TargetFilter anyLocation() {
        this.hintListLocations.addAll(List.of(GameConst.CardLocation.values()));
        this.hintListLocations.remove((Object)GameConst.CardLocation.BEAT);
        this.hintListLocations.remove((Object)GameConst.CardLocation.EXCLUDED);
        return this;
    }

    public TargetFilter anyZone() {
        this.targetScope = TargetScope.ZONE;
        return this.anyLocation();
    }

    public TargetFilter publicLocation() {
        this.hintListLocations.addAll(List.of(GameConst.CardLocation.values()));
        this.hintListLocations.remove((Object)GameConst.CardLocation.DECK_MAIN);
        this.hintListLocations.remove((Object)GameConst.CardLocation.DECK_LRIG);
        this.hintListLocations.remove((Object)GameConst.CardLocation.HAND);
        this.hintListLocations.remove((Object)GameConst.CardLocation.LIFE_CLOTH);
        this.hintListLocations.remove((Object)GameConst.CardLocation.LOOKED);
        this.hintListLocations.remove((Object)GameConst.CardLocation.BEAT);
        this.hintListLocations.remove((Object)GameConst.CardLocation.EXCLUDED);
        return this;
    }

    public TargetFilter fromField() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getZoneByLocation().getTopCard().getCardIndex() == card3D.getCardIndex());
        this.hintListLocations.add(GameConst.CardLocation.LRIG);
        this.hintListLocations.add(GameConst.CardLocation.LRIG_ASSIST_LEFT);
        this.hintListLocations.add(GameConst.CardLocation.LRIG_ASSIST_RIGHT);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_LEFT);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_CENTER);
        this.hintListLocations.add(GameConst.CardLocation.SIGNI_RIGHT);
        this.hintListLocations.add(GameConst.CardLocation.CHEER);
        return this;
    }

    public TargetFilter fromOutsideField() {
        this.hintListLocations.addAll(List.of(GameConst.CardLocation.values()));
        this.hintListLocations.remove((Object)GameConst.CardLocation.LRIG);
        this.hintListLocations.remove((Object)GameConst.CardLocation.LRIG_ASSIST_LEFT);
        this.hintListLocations.remove((Object)GameConst.CardLocation.LRIG_ASSIST_RIGHT);
        this.hintListLocations.remove((Object)GameConst.CardLocation.SIGNI_LEFT);
        this.hintListLocations.remove((Object)GameConst.CardLocation.SIGNI_CENTER);
        this.hintListLocations.remove((Object)GameConst.CardLocation.SIGNI_RIGHT);
        this.hintListLocations.remove((Object)GameConst.CardLocation.CHEER);
        this.hintListLocations.remove((Object)GameConst.CardLocation.BEAT);
        this.hintListLocations.remove((Object)GameConst.CardLocation.EXCLUDED);
        return this;
    }

    public TargetFilter playable() {
        return this.playable(null);
    }

    public TargetFilter playable(CardIndex contextCardIndex) {
        this.listValidatorsCard.add(card3D -> (this.hintFlagsFilter & 1) == 0 || card3D.getCardIndex().getIndexedInstance().isPlayable(this.getSourceTargetRole()));
        this.listValidatorsZone.add(fieldZone -> !ZoneSIGNI.isOccupied(fieldZone) && UtilCardPlayableControl.isZoneAvailable(Zone.getZoneOwner(fieldZone), this.getSourceCardIndex(), this.sourceAbility, fieldZone.getZoneLocation()));
        this.hintFlagsFilter |= 1;
        this.contextCardIndex = contextCardIndex;
        return this;
    }

    public TargetFilter playableAs(CardIndex cardIndexReplace) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().isPlayableAs(cardIndexReplace, this.sourceAbility));
        return this;
    }

    public TargetFilter withoutAbilities() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().hasNoAbilities());
        return this;
    }

    public TargetFilter withPower(double power) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getPower().getValue() == power);
        return this;
    }

    public TargetFilter withPower(double minValue, double maxValue) {
        this.listValidatorsCard.add(card3D -> (minValue == 0.0 || card3D.getCardIndex().getIndexedInstance().getPower().getValue() >= minValue) && (maxValue == 0.0 || card3D.getCardIndex().getIndexedInstance().getPower().getValue() <= maxValue));
        return this;
    }

    public TargetFilter withPrintedPower(int ... diffs) {
        this.listValidatorsCard.add(card3D -> Arrays.stream(diffs).anyMatch(diff -> card3D.getCardIndex().getCardReference().getPower().compareTo(card3D.getCardIndex().getIndexedInstance().getPower().getValue()) == diff));
        return this;
    }

    public TargetFilter withLevel(int level) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().matchesLevelByRef(this.sourceAbility, level, level));
        return this;
    }

    public TargetFilter withLevel(int minValue, int maxValue) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().matchesLevelByRef(this.sourceAbility, minValue, maxValue));
        return this;
    }

    public TargetFilter withColor() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getColor().getPrimaryValue() != CardConst.CardColor.COLORLESS);
        return this;
    }

    public TargetFilter withColor(CardConst.CardColor ... listColors) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getColor().matches(listColors));
        return this;
    }

    public TargetFilter withColor(CardDataColor ... listDataColors) {
        this.listValidatorsCard.add(card3D -> Arrays.stream(listDataColors).anyMatch(dataColor -> card3D.getCardIndex().getIndexedInstance().getColor().matches((CardDataColor)dataColor)));
        return this;
    }

    public TargetFilter withClass(CardConst.CardSIGNIClass cardSIGNIClass) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getSIGNIClass().matches(cardSIGNIClass));
        return this;
    }

    public TargetFilter withClass(CardConst.CardSIGNIClass ... cardSIGNIClasses) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getSIGNIClass().matches(cardSIGNIClasses));
        return this;
    }

    public TargetFilter withClass(CardConst.CardSIGNIClass cardSIGNIClass, CardConst.CardSIGNIClassGeneration generation) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getSIGNIClass().matchesExact(generation, cardSIGNIClass));
        return this;
    }

    public TargetFilter withClass(Set<CardDataSIGNIClass.CardSIGNIClassValue> cardSIGNIClasses) {
        this.listValidatorsCard.add(card3D -> cardSIGNIClasses.stream().anyMatch(cardSIGNIClass -> card3D.getCardIndex().getIndexedInstance().getSIGNIClass().getValue().contains(cardSIGNIClass)));
        return this;
    }

    public TargetFilter withClass(CardDataSIGNIClass dataSIGNIClass) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getSIGNIClass().matches(dataSIGNIClass));
        return this;
    }

    public TargetFilter withLRIGType(CardConst.CardLRIGType cardLRIGType) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getLRIGType().matches(cardLRIGType));
        return this;
    }

    public TargetFilter withLRIGType(CardConst.CardLRIGType ... cardLRIGTypes) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getLRIGType().matches(cardLRIGTypes));
        return this;
    }

    public TargetFilter withLRIGType(CardDataLRIGType dataLRIGType) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getLRIGType().matches(dataLRIGType));
        return this;
    }

    public TargetFilter withLRIGTeam(CardConst.CardLRIGTeam cardLRIGTeam) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getCardReference().getLRIGTeam() == cardLRIGTeam);
        return this;
    }

    public TargetFilter withLRIGTeam() {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getCardReference().getLRIGTeam() != null);
        return this;
    }

    public TargetFilter withName(String ... listNames) {
        this.listValidatorsCard.add(card3D -> Arrays.stream(listNames).anyMatch(name -> card3D.getCardIndex().getCardReference().getOriginalName().contains((CharSequence)name)));
        return this;
    }

    public TargetFilter withDescription(String ... listDescriptions) {
        this.listValidatorsCard.add(card3D -> {
            if (listDescriptions.length > 0) {
                return Arrays.stream(listDescriptions).anyMatch(description -> card3D.getCardIndex().getCardReference().getDescription().contains((CharSequence)description));
            }
            return !card3D.getCardIndex().getCardReference().getDescription().isEmpty();
        });
        return this;
    }

    public TargetFilter startsWithDescription(String ... listDescriptions) {
        this.listValidatorsCard.add(card3D -> Arrays.stream(listDescriptions).anyMatch(description -> card3D.getCardIndex().getCardReference().getDescription().startsWith((String)description)));
        return this;
    }

    public TargetFilter withCost(int cost) {
        this.listValidatorsCard.add(card3D -> Cost.getOriginalCostAsNumber(card3D.getCardIndex().getCardReference()) == cost);
        return this;
    }

    public TargetFilter withCost(int rangeMin, int rangeMax) {
        this.listValidatorsCard.add(card3D -> !(rangeMin != 0 && Cost.getOriginalCostAsNumber(card3D.getCardIndex().getCardReference()) < rangeMin || rangeMax != 0 && Cost.getOriginalCostAsNumber(card3D.getCardIndex().getCardReference()) > rangeMax));
        return this;
    }

    public TargetFilter withState(int flagCardState) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().isState(flagCardState));
        return this;
    }

    public TargetFilter withCost() {
        this.listValidatorsCard.add(card3D -> Cost.getOriginalCostAsNumber(card3D.getCardIndex().getCardReference()) > 0);
        return this;
    }

    public TargetFilter withUseCondition(GameConst.UseCondition useCondition) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getUseCondition() == useCondition && !card3D.getCardIndex().getIndexedInstance().hasNoAbilities());
        return this;
    }

    public TargetFilter withUseTiming(int flagsUseTiming) {
        this.listValidatorsCard.add(card3D -> (card3D.getCardIndex().getIndexedInstance().getUseTimingFlags().getValue() & flagsUseTiming) != 0);
        return this;
    }

    @SafeVarargs
    public final TargetFilter withStockAbility(Class<? extends StockAbility> ... stockAbilityClasses) {
        this.listValidatorsCard.add(card3D -> card3D.getCardIndex().getIndexedInstance().getAbilityList().stream().anyMatch(ability -> ability.getSourceStockAbility() != null && !ability.isDisabled() && Arrays.asList(stockAbilityClasses).contains(ability.getSourceStockAbility().getClass())));
        return this;
    }

    public TargetFilter not(TargetFilter filter) {
        filter.setAsTargeted(this.isTargeted);
        filter.setHintFilterFlags(this.hintFlagsFilter);
        filter.setSourceAbility(this.sourceAbility);
        filter.setSourceCardIndex(this.sourceCardIndex);
        filter.setTargetContext(this.targetContext);
        filter.setTargetHint(this.hintTargetType);
        filter.setTargetRole(this.sourceTargetRole);
        this.listValidatorsCard.add(card3D -> !filter.isPickValid((Card3D)card3D));
        this.listValidatorsZone.add(fieldZone -> !filter.isPickValid((FieldZone)fieldZone));
        return this;
    }

    public TargetFilter or(TargetFilter ... filters) {
        for (TargetFilter filter : filters) {
            filter.setAsTargeted(this.isTargeted);
            filter.setSourceAbility(this.sourceAbility);
            filter.setSourceCardIndex(this.sourceCardIndex);
            filter.setTargetContext(this.targetContext);
            filter.setTargetHint(this.hintTargetType);
            filter.setTargetRole(this.sourceTargetRole);
            this.hintListLocations.addAll(filter.getHintLocationsData());
            this.hintFlagsFilter |= filter.getHintFilterFlags();
        }
        this.listValidatorsCard.add(card3D -> Arrays.stream(filters).anyMatch(filter -> filter.isPickValid((Card3D)card3D)));
        this.listValidatorsZone.add(fieldZone -> Arrays.stream(filters).anyMatch(filter -> filter.isPickValid((FieldZone)fieldZone)));
        return this;
    }

    public TargetFilter and(TargetFilter ... filters) {
        if (this.requiredFilters == null) {
            this.requiredFilters = new ArrayList<TargetFilter>();
        }
        this.requiredFilters.addAll(Arrays.asList(filters));
        return this.or(filters);
    }

    public TargetFilter custom(CardFunctionalConditionalHandler handler) {
        this.listValidatorsCard.add(card3D -> handler.handle(card3D.getCardIndex()));
        return this;
    }

    public int getHintOwnerFlags() {
        return this.hintFlagsOwner;
    }

    public Set<GameConst.CardLocation> getHintLocationsData() {
        return this.hintListLocations;
    }

    public TargetHint getHintTargetType() {
        return this.hintTargetType;
    }

    public int getHintFilterFlags() {
        return this.hintFlagsFilter;
    }

    public void setHintFilterFlags(int hintFlagsFilter) {
        this.hintFlagsFilter = hintFlagsFilter;
    }

    public TargetContext getTargetContext() {
        return this.targetContext;
    }

    public TargetScope getTargetScope() {
        return this.targetScope;
    }

    private boolean isCardInstanceSafe() {
        return (this.hintFlagsFilter & 2) != 0;
    }

    public boolean hasRequiredFilters() {
        return this.requiredFilters != null && !this.requiredFilters.isEmpty();
    }

    public boolean matchRequiredFilters(List<? extends Targetable> picks) {
        if (picks == null || picks.isEmpty() || this.requiredFilters == null) {
            return false;
        }
        for (TargetFilter filter : this.requiredFilters) {
            if (!filter.dataExported.stream().noneMatch(picks::contains)) continue;
            return false;
        }
        return true;
    }

    public <T extends Targetable> DataTable<T> getExportedData() {
        return this.getExportedData(false);
    }

    public <T extends Targetable> DataTable<T> getExportedData(boolean isSilent) {
        this.getValidTargetsCount(isSilent);
        return this.dataExported;
    }

    public int getValidTargetsCount() {
        return this.getValidTargetsCount(false);
    }

    public int getValidTargetsCount(boolean isSilent) {
        this.dataExported.clear();
        int count = 0;
        if ((this.hintFlagsOwner & 1) != 0) {
            count += this.getValidTargetsCount(this.getSourceTargetRole());
        }
        if ((this.hintFlagsOwner & 2) != 0) {
            count += this.getValidTargetsCount(Game.GamePlayerRole.getOpponentRole(this.getSourceTargetRole()));
        }
        if (this.requiredFilters != null) {
            HashSet<Targetable> matches = new HashSet<Targetable>();
            for (TargetFilter filter : this.requiredFilters) {
                if (filter.hintListLocations.isEmpty()) {
                    filter.hintListLocations.addAll(this.hintListLocations);
                }
                filter.hintFlagsOwner = this.hintFlagsOwner;
                if (filter.getValidTargetsCount(true) != 0 && matches.addAll(filter.dataExported.stream().toList())) continue;
                count = 0;
                break;
            }
        }
        if (!isSilent) {
            Log.printMessage(">>> VALID TARGETS: " + count);
        }
        return count;
    }

    private int getValidTargetsCount(Game.GamePlayerRole rolePlayer) {
        int count = 0;
        for (GameConst.CardLocation location : this.hintListLocations) {
            Object fieldZone;
            Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
            if (zone == null || !zone.getNode().isVisible() || this.targetContext == TargetContext.CARD && zone.getZoneCardList().isEmpty()) continue;
            if (GameConst.CardLocation.isSIGNI(location) && this.targetScope == TargetScope.CARD) {
                fieldZone = (FieldZone)zone;
                if (this.targetContext == TargetContext.CARD && (!FieldZone.isOccupied((FieldZone)fieldZone) || !this.isPickValid(((Zone)fieldZone).getTopCard())) || this.targetContext == TargetContext.ZONE && !this.isPickValid((FieldZone)fieldZone)) continue;
                this.dataExported.add((Targetable)(this.targetContext == TargetContext.CARD ? ((Zone)fieldZone).getTopCard().getCardIndex() : fieldZone));
                ++count;
                continue;
            }
            if (!GameConst.CardLocation.isPlayerPrivate(location) || rolePlayer == Game.getCurrentGame().getPlayerRole() && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
                if (this.targetContext == TargetContext.CARD) {
                    fieldZone = zone.getZoneCardList().iterator();
                    while (fieldZone.hasNext()) {
                        Card3D card3D = (Card3D)fieldZone.next();
                        if (card3D.getCardIndex().getIndexedInstance() == null && !this.isCardInstanceSafe() || !this.isPickValid(card3D)) continue;
                        this.dataExported.add(card3D.getCardIndex());
                        ++count;
                    }
                    continue;
                }
                if (this.targetContext != TargetContext.ZONE || !(zone instanceof FieldZone) || !this.isPickValid((FieldZone)(fieldZone = (FieldZone)zone))) continue;
                this.dataExported.add((Targetable)fieldZone);
                ++count;
                continue;
            }
            count += zone.getTotalCards();
        }
        return count;
    }

    public int getTotalTargetsCount() {
        int count = 0;
        for (GameConst.CardLocation location : this.hintListLocations) {
            if ((this.hintFlagsOwner & 1) != 0) {
                count += FieldData.getZoneByLocation(this.getSourceTargetRole(), location).getTotalCards();
            }
            if ((this.hintFlagsOwner & 2) == 0) continue;
            count += FieldData.getZoneByLocation(Game.GamePlayerRole.getOpponentRole(this.getSourceTargetRole()), location).getTotalCards();
        }
        System.out.println(">>> TOTAL TARGETS: " + count);
        return count;
    }

    public static enum TargetHint implements AbilityConst.ActionDescription
    {
        GENERIC("generic", ""),
        ACTIVATE("activate", "ABILITY_TARGET_HINT_ACTIVATE"),
        ENER("charge", "ABILITY_TARGET_HINT_ENER"),
        MOVE("swap", "ABILITY_TARGET_HINT_MOVE"),
        LOOK("look", "ABILITY_TARGET_HINT_LOOK"),
        REVEAL("reveal", "ABILITY_TARGET_HINT_REVEAL"),
        DELETE("delete", "ABILITY_TARGET_HINT_DELETE"),
        PLUS("plus", "ABILITY_TARGET_HINT_PLUS"),
        MINUS("minus", "ABILITY_TARGET_HINT_MINUS"),
        BANISH("banish", "ABILITY_TARGET_HINT_BANISH"),
        TRASH("trash", "ABILITY_TARGET_HINT_TRASH"),
        BURN("burn", "ABILITY_TARGET_HINT_BURN"),
        UP("up", "ABILITY_TARGET_HINT_UP"),
        DOWN("down", "ABILITY_TARGET_HINT_DOWN"),
        FLIP("flip", "ABILITY_TARGET_HINT_FLIP"),
        FREEZE("freeze", "ABILITY_TARGET_HINT_FREEZE"),
        EXCLUDE("exclude", "ABILITY_TARGET_HINT_EXCLUDE"),
        ATTACH("attach", "ABILITY_TARGET_HINT_ATTACH"),
        UNDER("under", "ABILITY_TARGET_HINT_UNDER"),
        ZONE("zone", "ABILITY_TARGET_HINT_ZONE"),
        HAND("hand", "ABILITY_TARGET_HINT_HAND"),
        DISCARD("discard", "ABILITY_TARGET_HINT_DISCARD"),
        GUARD("guard", "ABILITY_TARGET_HINT_GUARD"),
        FIELD("field", "ABILITY_TARGET_HINT_FIELD"),
        SHUFFLE("shuffle", "ABILITY_TARGET_HINT_SHUFFLE"),
        TOP("top", "ABILITY_TARGET_HINT_TOP"),
        BOTTOM("bottom", "ABILITY_TARGET_HINT_BOTTOM"),
        HEAL("heal", "ABILITY_TARGET_HINT_HEAL"),
        ABILITY("ability", "ABILITY_TARGET_HINT_ABILITY"),
        MUTE("mute", "ABILITY_TARGET_HINT_MUTE"),
        CANCEL("cancel", "ABILITY_TARGET_HINT_CANCEL"),
        COPY("copy", "ABILITY_TARGET_HINT_COPY"),
        TRANSFORM("transform", "ABILITY_TARGET_HINT_TRANSFORM"),
        RISE("rise", "ABILITY_TARGET_HINT_RISE"),
        RIDE("ride", "ABILITY_TARGET_HINT_RIDE"),
        RESONA("resona", "ABILITY_TARGET_HINT_RESONA");

        private final String icon;
        private final String descAction;

        private TargetHint(String icon, String descAction) {
            this.icon = icon;
            this.descAction = LanguageParser.getString(descAction);
        }

        public String getBorderIcon() {
            return this.icon;
        }

        @Override
        public String getActionDescription() {
            return this.descAction;
        }
    }

    public static enum TargetContext {
        CARD,
        ZONE;

    }

    public static enum TargetScope {
        CARD,
        ZONE;

    }

    public static class FilterFlag {
        public static final int IS_PLAYABLE = 1;
        public static final int IS_CARD_INSTANCE_SAFE = 2;
        public static final int IS_CROSS_LEFT = 4;
        public static final int IS_CROSS_RIGHT = 8;
    }

    public static interface Targetable {
    }
}

