/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.rulechecks;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.RuleCheckData;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityANDCost;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.AbilityORCost;

public class CostRuleCheck
extends RuleCheck<AbilityCost, RuleCheckData>
implements CardRuleCheckRegistry.CardRuleCheck<AbilityCost>,
PlayerRuleCheckRegistry.PlayerRuleCheck<AbilityCost> {
    public CostRuleCheck() {
        this((AbilityCost)null);
    }

    public CostRuleCheck(AbilityCost cost) {
        super((V data) -> cost);
    }

    @Override
    public AbilityCost check(CardRuleCheckData data) {
        return this.check(data, CostRuleCheck.getCardIndex(data));
    }

    @Override
    public AbilityCost check(PlayerRuleCheckData data) {
        return this.check(data, CostRuleCheck.getCardIndex(data));
    }

    private AbilityCost check(RuleCheckData data, CardIndex cardIndex) {
        ArrayList<AbilityCostList> dataCostLists = new ArrayList<AbilityCostList>();
        if (this.getDefault().getResult(data) == null && this.getRuleChecksNum() == 1) {
            return new AbilityCostListWrapper(dataCostLists);
        }
        int countCostListsAddedByORCosts = 0;
        for (int i = 0; i < this.getRuleChecksNum(); ++i) {
            AbilityORCost costOR;
            Ability sourceAbilityRC = this.getRuleCheckSourceAbility(i);
            data.setSourceAbilityRC(sourceAbilityRC);
            AbilityCost cost = (AbilityCost)this.getRuleCheck(i).getResult(data);
            if (cost == null) continue;
            if (cost instanceof AbilityORCost) {
                costOR = (AbilityORCost)cost;
            } else {
                cost.setSourceAbility(sourceAbilityRC);
                if (dataCostLists.isEmpty()) {
                    dataCostLists.add(new AbilityCostList(cost));
                    continue;
                }
                for (AbilityCostList costList : dataCostLists) {
                    costList.getDataArray().add(cost);
                }
                continue;
            }
            AbilityCost[] listCosts = costOR.getCostsList();
            if (dataCostLists.isEmpty()) {
                dataCostLists.add(new AbilityCostList(new AbilityCost[0]));
            }
            int initialSize = dataCostLists.size() - countCostListsAddedByORCosts;
            for (int ii = 0; ii < initialSize; ++ii) {
                AbilityCostList currentCostList = (AbilityCostList)dataCostLists.get(ii);
                for (int iii = 0; iii < listCosts.length; ++iii) {
                    int arrayId;
                    AbilityCost costFromList = listCosts[iii];
                    if (iii == 0) {
                        if (costFromList == AbilityORCost.REPLACE_DEFAULT) continue;
                        costFromList.setSourceAbility(sourceAbilityRC);
                        currentCostList.getDataArray().add(costFromList);
                        continue;
                    }
                    AbilityCostList newList = new AbilityCostList(currentCostList.getDataArray());
                    int n = arrayId = listCosts[0] != AbilityORCost.REPLACE_DEFAULT ? newList.getDataArray().size() - 1 : 0;
                    if (!(costFromList instanceof AbilityANDCost)) {
                        costFromList.setSourceAbility(sourceAbilityRC);
                        newList.getDataArray().set(arrayId, costFromList);
                    } else {
                        AbilityANDCost costAND = (AbilityANDCost)costFromList;
                        for (int iiii = 0; iiii < costAND.getCostsList().length; ++iiii) {
                            AbilityCost costFromANDList = costAND.getCostsList()[iiii];
                            costFromANDList.setSourceAbility(sourceAbilityRC);
                            if (iiii > 0) {
                                newList.getDataArray().add(costFromANDList);
                                continue;
                            }
                            newList.getDataArray().set(arrayId, costFromANDList);
                        }
                    }
                    dataCostLists.add(newList);
                    ++countCostListsAddedByORCosts;
                }
            }
        }
        for (AbilityCostList costList : dataCostLists) {
            costList.setSourceDataCostLists(dataCostLists);
            costList.setSourceCardIndex(cardIndex);
        }
        return !dataCostLists.isEmpty() && !((AbilityCostList)dataCostLists.getFirst()).getDataArray().isEmpty() ? ((AbilityCostList)dataCostLists.getFirst()).getDataArray().getFirst() : new AbilityCostListWrapper(dataCostLists);
    }

    public static CardIndex getCardIndex(CardRuleCheckData data) {
        return data.getCardIndex();
    }

    public static CardIndex getCardIndex(PlayerRuleCheckData data) {
        return (CardIndex)data.getGenericData(0);
    }

    private static class AbilityCostListWrapper
    extends AbilityCost {
        public AbilityCostListWrapper(List<AbilityCostList> dataCostLists) {
            super(1, 1, null, null);
            AbilityCostList costList = new AbilityCostList(new AbilityCost[0]);
            costList.setSourceDataCostLists(dataCostLists);
            this.setSourceCostList(costList);
        }

        @Override
        public boolean canBePaid() {
            return false;
        }

        @Override
        protected void pay() {
        }
    }
}

