/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.rulechecks;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.rulechecks.RuleCheckData;
import open.batoru.data.ability.Ability;

public abstract class RuleCheck<T, V extends RuleCheckData>
implements Disposable {
    private final List<RuleCheckHandler<T, V>> listRuleChecks = new ArrayList<RuleCheckHandler<T, V>>();
    private final List<Ability> listRuleChecksSourceAbilities = new ArrayList<Ability>();

    public RuleCheck(RuleCheckHandler<T, V> defaultRuleCheck) {
        this.listRuleChecks.add(defaultRuleCheck);
        this.listRuleChecksSourceAbilities.add(null);
    }

    public final void addRuleCheck(RuleCheckHandler<T, V> ruleCheck, Ability sourceAbility) {
        if (ruleCheck == null) {
            return;
        }
        this.listRuleChecks.add(ruleCheck);
        this.listRuleChecksSourceAbilities.add(sourceAbility);
    }

    public final void removeRuleCheck(RuleCheckHandler<T, V> ruleCheck) {
        if (ruleCheck == null) {
            return;
        }
        int arrayId = this.listRuleChecks.indexOf(ruleCheck);
        if (arrayId != -1) {
            this.listRuleChecks.remove(arrayId);
            this.listRuleChecksSourceAbilities.remove(arrayId);
        }
    }

    public final RuleCheckHandler<T, V> getDefault() {
        return this.listRuleChecks.getFirst();
    }

    public final RuleCheckHandler<T, V> getRuleCheck(int arrayId) {
        return this.listRuleChecks.get(arrayId);
    }

    public final Ability getRuleCheckSourceAbility(int arrayId) {
        return this.listRuleChecksSourceAbilities.get(arrayId);
    }

    public final int getRuleChecksNum() {
        return this.listRuleChecks.size();
    }

    @Override
    public void dispose() {
        this.listRuleChecks.clear();
        this.listRuleChecksSourceAbilities.clear();
    }

    @FunctionalInterface
    public static interface RuleCheckHandler<T, V extends RuleCheckData> {
        public T getResult(V var1);
    }

    public static enum RuleCheckState {
        OK,
        BLOCK,
        IGNORE;


        public static RuleCheckState getInverted(RuleCheckState state) {
            if (state == OK) {
                return BLOCK;
            }
            if (state == BLOCK) {
                return OK;
            }
            return IGNORE;
        }
    }
}

