/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.rulechecks;

import java.util.EnumMap;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.RuleCheckData;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;

public abstract class SIGNIZoneRuleCheck<T extends SIGNIZonePositionGroup>
extends RuleCheck<T, RuleCheckData>
implements CardRuleCheckRegistry.CardRuleCheck<T>,
PlayerRuleCheckRegistry.PlayerRuleCheck<T> {
    public SIGNIZoneRuleCheck(RuleCheck.RuleCheckHandler<T, RuleCheckData> defaultRuleCheck) {
        super(defaultRuleCheck);
    }

    @Override
    public T check(CardRuleCheckData data) {
        return this.checkGeneric(data);
    }

    @Override
    public T check(PlayerRuleCheckData data) {
        return this.checkGeneric(data);
    }

    private T checkGeneric(RuleCheckData data) {
        SIGNIZonePositionGroup result = (SIGNIZonePositionGroup)this.getDefault().getResult(data);
        if (this.getRuleChecksNum() == 1) {
            return (T)result;
        }
        for (int i = this.getRuleChecksNum() - 1; i >= 1; --i) {
            SIGNIZonePositionGroup group = (SIGNIZonePositionGroup)this.getRuleCheck(i).getResult(data);
            for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                SIGNIZonePositionGroup.SIGNIZonePositionState state = group.getState(zonePosition);
                if (state == SIGNIZonePositionGroup.SIGNIZonePositionState.IGNORE) continue;
                this.mergeState(result, group, zonePosition, state);
            }
        }
        return (T)result;
    }

    protected void mergeState(T result, T group, GameConst.SIGNIZonePosition zonePosition, SIGNIZonePositionGroup.SIGNIZonePositionState state) {
        ((SIGNIZonePositionGroup)result).setState(zonePosition, state);
    }

    public static GameConst.SIGNIZonePosition getDataZoneSIGNIPosition(RuleCheckData data) {
        return (GameConst.SIGNIZonePosition)((Object)data.getGenericData(0));
    }

    public static class SIGNIZonePositionGroup {
        private final EnumMap<GameConst.SIGNIZonePosition, SIGNIZonePositionState> map = new EnumMap(GameConst.SIGNIZonePosition.class);

        public SIGNIZonePositionGroup(SIGNIZonePositionState defaultState) {
            for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                this.map.put(zonePosition, defaultState);
            }
        }

        public void setState(GameConst.SIGNIZonePosition zonePosition, SIGNIZonePositionState state) {
            if (zonePosition == null) {
                return;
            }
            this.map.put(zonePosition, state);
        }

        public SIGNIZonePositionState getState(GameConst.SIGNIZonePosition zonePosition) {
            return this.map.get((Object)zonePosition);
        }

        public static enum SIGNIZonePositionState {
            ALLOW,
            DENY,
            IGNORE;

        }
    }
}

