/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.rulechecks.card;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.RuleCheckData;
import open.batoru.core.gameplay.rulechecks.StateRuleCheck;
import open.batoru.data.CardConst;

public final class RuleCheckCanAttack
extends StateRuleCheck {
    private static final RuleCheck.RuleCheckHandler<RuleCheck.RuleCheckState, RuleCheckData> DEFAULT_HANDLER = data -> {
        CardIndex cardIndex = ((CardRuleCheckData)data).getCardIndex();
        if (cardIndex.getIndexedInstance().isState(16384) || cardIndex.getIndexedInstance().hasAttackModifier(1)) {
            return RuleCheck.RuleCheckState.BLOCK;
        }
        if (CardConst.CardType.isLRIG(cardIndex.getCardReference().getType())) {
            if (cardIndex.getIndexedInstance().isState(0x200000)) {
                return RuleCheck.RuleCheckState.BLOCK;
            }
            if (cardIndex.getLocation() != GameConst.CardLocation.LRIG && !cardIndex.getIndexedInstance().hasAttackModifier(32)) {
                return RuleCheck.RuleCheckState.BLOCK;
            }
        }
        return RuleCheck.RuleCheckState.OK;
    };

    public RuleCheckCanAttack() {
        super(DEFAULT_HANDLER);
    }
}

