/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.rulechecks.player;

import java.util.EnumMap;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.ActionOverrideRuleCheck;
import open.batoru.core.gameplay.rulechecks.CostRuleCheck;
import open.batoru.core.gameplay.rulechecks.DataTableRuleCheck;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.StateRuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.RuleCheckCanNewlyPutSIGNIOnField;
import open.batoru.core.gameplay.rulechecks.player.RuleCheckCanPayEner;
import open.batoru.core.gameplay.rulechecks.player.RuleCheckCanPlaceSIGNIOnZone;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.cost.DiscardCost;

public class PlayerRuleCheckRegistry
implements Disposable {
    private final EnumMap<PlayerRuleCheckType, PlayerRuleCheck<?>> ruleChecks = new EnumMap(PlayerRuleCheckType.class);
    private final EnumMap<PlayerRuleValueType, ModifiableInteger> ruleValues = new EnumMap(PlayerRuleValueType.class);

    public PlayerRuleCheckRegistry() {
        this.ruleChecks.put(PlayerRuleCheckType.CAN_ATTACK, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_NEWLY_PUT_SIGNI_ON_FIELD, new RuleCheckCanNewlyPutSIGNIOnField());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_PLACE_SIGNI_ON_ZONE, new RuleCheckCanPlaceSIGNIOnZone());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_BE_ATTACKED, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_BE_DAMAGED, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_GUARD, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_DRAW, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_USE_SPELL, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_USE_ARTS, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_USE_ABILITY, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_PAY_ENER, new RuleCheckCanPayEner());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_LOSE_GAME, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_GAIN_COINS, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.CAN_SPEND_COINS, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.MUST_SKIP_PHASE, new StateRuleCheck(data -> RuleCheck.RuleCheckState.BLOCK));
        this.ruleChecks.put(PlayerRuleCheckType.MUST_PASS_TURN_PLAYER, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.MUST_TRASH_LC_ON_REFRESH, new StateRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.COST_TO_GUARD, new CostRuleCheck(new DiscardCost(0, 1, new TargetFilter(TargetFilter.TargetHint.GUARD).SIGNI().guard().custom(cardIndex -> cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_GUARD).check(cardIndex) == RuleCheck.RuleCheckState.OK)).forceAutoConfirm(true)));
        this.ruleChecks.put(PlayerRuleCheckType.COST_TO_PLACE_SIGNI_ON_ZONE, new CostRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.COST_TO_DISABLE_LB, new CostRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.COST_TO_UP, new CostRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.DATA_CARDS_ENER_SUBSTITUTE, new DataTableRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.DATA_COSTS_ENER_ALT_PAY, new DataTableRuleCheck());
        this.ruleChecks.put(PlayerRuleCheckType.ACTION_OVERRIDE, new ActionOverrideRuleCheck());
        this.ruleValues.put(PlayerRuleValueType.DRAW_PHASE_MAX, new ModifiableInteger(0));
        this.ruleValues.put(PlayerRuleValueType.DRAW_PHASE_MULTIPLIER, new ModifiableInteger(1));
        this.ruleValues.put(PlayerRuleValueType.MAX_HAND_SIZE, new ModifiableInteger(6));
        this.ruleValues.put(PlayerRuleValueType.MAX_ALLOWED_SIGNI, new ModifiableInteger(4));
        this.ruleValues.put(PlayerRuleValueType.MAX_ALLOWED_KEYS, new ModifiableInteger(1));
    }

    public <T extends PlayerRuleCheck<?>> T getRuleCheck(PlayerRuleCheckType ruleCheckType) {
        return (T)this.ruleChecks.get((Object)ruleCheckType);
    }

    public ModifiableInteger getRuleValue(PlayerRuleValueType ruleValueType) {
        return this.ruleValues.get((Object)ruleValueType);
    }

    @Override
    public void dispose() {
        this.ruleChecks.values().forEach(Disposable::dispose);
        this.ruleChecks.clear();
        this.ruleValues.clear();
    }

    public static enum PlayerRuleCheckType {
        CAN_ATTACK,
        CAN_NEWLY_PUT_SIGNI_ON_FIELD,
        CAN_PLACE_SIGNI_ON_ZONE,
        CAN_BE_ATTACKED,
        CAN_BE_DAMAGED,
        CAN_GUARD,
        CAN_DRAW,
        CAN_USE_SPELL,
        CAN_USE_ARTS,
        CAN_USE_ABILITY,
        CAN_PAY_ENER,
        CAN_LOSE_GAME,
        CAN_GAIN_COINS,
        CAN_SPEND_COINS,
        MUST_SKIP_PHASE,
        MUST_PASS_TURN_PLAYER,
        MUST_TRASH_LC_ON_REFRESH,
        COST_TO_GUARD,
        COST_TO_PLACE_SIGNI_ON_ZONE,
        COST_TO_DISABLE_LB,
        COST_TO_UP,
        DATA_CARDS_ENER_SUBSTITUTE,
        DATA_COSTS_ENER_ALT_PAY,
        ACTION_OVERRIDE;

    }

    public static enum PlayerRuleValueType {
        DRAW_PHASE_MAX,
        DRAW_PHASE_MULTIPLIER,
        MAX_HAND_SIZE,
        MAX_ALLOWED_SIGNI,
        MAX_ALLOWED_KEYS;

    }

    public static interface PlayerRuleCheck<T>
    extends Disposable {
        public T check(PlayerRuleCheckData var1);

        default public T check(Game.GamePlayerRole rolePlayer) {
            return this.check(new PlayerRuleCheckData(rolePlayer, null, null, new Object[0]));
        }

        default public T check(Game.GamePlayerRole rolePlayer, CardIndex source, Ability ability, Object ... data) {
            return this.check(new PlayerRuleCheckData(rolePlayer, source, ability, data));
        }

        default public T check(Game.GamePlayerRole rolePlayer, CardIndex source, Object ... data) {
            return this.check(new PlayerRuleCheckData(rolePlayer, source, null, data));
        }

        default public T check(Game.GamePlayerRole rolePlayer, GameAction<?> action, Object ... data) {
            return this.check(new PlayerRuleCheckData(rolePlayer, action.getSourceCardIndex(), action.getSourceAbility(), data));
        }
    }
}

