/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.rooms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.SimpleIntegerProperty;
import open.batoru.core.Game;
import open.batoru.core.rooms.RoomPlayerData;
import open.batoru.data.CardConst;
import open.batoru.parsers.LanguageParser;

public class Room {
    private final int roomId;
    private int gameId;
    private final int roomFlags;
    private final CardConst.PlayFormat playFormat;
    private final StartingPlayer startingPlayer;
    private final SimpleIntegerProperty countTurn = new SimpleIntegerProperty();
    private final SimpleIntegerProperty roleIdTurnPlayer = new SimpleIntegerProperty(-1);
    private final SimpleIntegerProperty countSpec = new SimpleIntegerProperty();
    private final List<RoomPlayerData> playerData = new ArrayList<RoomPlayerData>();

    public Room(int roomId, int roomFlags, CardConst.PlayFormat playFormat, StartingPlayer startingPlayer, String hostUsername) {
        this.roomId = roomId;
        this.roomFlags = roomFlags;
        this.playFormat = playFormat;
        this.startingPlayer = startingPlayer;
        this.playerData.add(new RoomPlayerData());
        this.playerData.getFirst().setPlayerName(hostUsername);
        this.playerData.add(new RoomPlayerData());
    }

    public int getRoomId() {
        return this.roomId;
    }

    public void setGameId(int gameId) {
        this.gameId = gameId;
    }

    public int getGameId() {
        return this.gameId;
    }

    public int getRoomFlags() {
        return this.roomFlags;
    }

    public CardConst.PlayFormat getPlayFormat() {
        return this.playFormat;
    }

    public StartingPlayer getStartingPlayer() {
        return this.startingPlayer;
    }

    public boolean areSpectatorsAllowed() {
        return (this.roomFlags & 1) != 0;
    }

    public boolean areUnreleasedCardsAllowed() {
        return (this.roomFlags & 2) != 0;
    }

    public boolean areRestrictedCardsAllowed() {
        return (this.roomFlags & 4) != 0;
    }

    public SimpleIntegerProperty getTurnCountProperty() {
        return this.countTurn;
    }

    public SimpleIntegerProperty getTurnPlayerRoleIdProperty() {
        return this.roleIdTurnPlayer;
    }

    public SimpleIntegerProperty getSpectatorCountProperty() {
        return this.countSpec;
    }

    public RoomPlayerData getPlayerData(Game.GamePlayerRole rolePlayer) {
        return this.playerData.get(rolePlayer.getId());
    }

    public static enum StartingPlayer {
        RANDOM(0, "UI_ROOM_START_PLAYER_RANDOM"),
        HOST(1, "UI_ROOM_START_PLAYER_HOST"),
        GUEST(2, "UI_ROOM_START_PLAYER_GUEST");

        private final int id;
        private final String label;
        private static final StartingPlayer[] ids;

        private StartingPlayer(int id, String label) {
            this.id = id;
            this.label = LanguageParser.getString(label);
        }

        public int getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public static StartingPlayer getStartingPlayerById(int id) {
            return ids[id];
        }

        static {
            ids = (StartingPlayer[])Arrays.stream(StartingPlayer.values()).toArray(StartingPlayer[]::new);
        }
    }

    public static class RoomFlag {
        public static final int ALLOW_SPECTATORS = 1;
        public static final int ALLOW_CARDS_UNRELEASED = 2;
        public static final int ALLOW_CARDS_RESTRICTED = 4;
    }
}

