/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.scene.paint.Color;
import open.batoru.parsers.LanguageParser;

public final class CardConst {
    private CardConst() {
    }

    public static enum PlayFormat {
        ALLSTAR(0, "FORMAT_ALLSTAR", "allstar"),
        KEY(1, "FORMAT_KEY", "key"),
        KEY_CLASSIC(5, "FORMAT_KEY_CLASSIC", "key_classic"),
        DIVA(2, "FORMAT_DIVA", "diva"),
        ENGLISH(3, "FORMAT_ENGLISH", "english"),
        CHINESE(4, "FORMAT_CHINESE", "chinese");

        private final int id;
        private final String label;
        private final String shortLabel;
        private static final Map<String, PlayFormat> mapLabels;

        private PlayFormat(int id, String label, String shortLabel) {
            this.id = id;
            this.label = LanguageParser.getString(label);
            this.shortLabel = shortLabel;
        }

        public int getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getShortLabel() {
            return this.shortLabel;
        }

        public static PlayFormat getPlayFormatByLabel(String label) {
            return mapLabels.get(label);
        }

        public static PlayFormat getPlayFormatById(int id) {
            return Arrays.stream(PlayFormat.values()).filter(playFormat -> playFormat.getId() == id).findFirst().orElseThrow(IllegalArgumentException::new);
        }

        static {
            mapLabels = Arrays.stream(PlayFormat.values()).collect(Collectors.toMap(PlayFormat::getLabel, Function.identity()));
        }
    }

    public static class UseTiming {
        public static final int NONE = 0;
        public static final int MAIN = 1;
        public static final int ATTACK = 2;
        public static final int SPELLCUTIN = 4;
    }

    public static class CardFlag {
        public static final int NONE = 0;
        public static final int LIFEBURST = 1;
        public static final int GUARD = 2;
        public static final int TRAP = 4;
        public static final int CRAFT = 8;
        public static final int RELAY = 16;
        public static final int DISSONA = 32;
    }

    public static enum CardFace {
        FRONT,
        BACK;

    }

    public static enum CardSIGNIClassGeneration {
        SPIRIT("CARD_SIGNI_CLASS_GENERATION_SPIRIT"),
        PERFORMER("CARD_SIGNI_CLASS_GENERATION_PERFORMER");

        private final String label;

        private CardSIGNIClassGeneration(String label) {
            this.label = LanguageParser.getString(label);
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum CardSIGNIClassFamily {
        IMAGE("CARD_SIGNI_CLASS_FAMILY_IMAGE"),
        LIVING("CARD_SIGNI_CLASS_FAMILY_LIVING"),
        MACHINE("CARD_SIGNI_CLASS_FAMILY_MACHINE"),
        NATURE("CARD_SIGNI_CLASS_FAMILY_NATURE"),
        WAR("CARD_SIGNI_CLASS_FAMILY_WAR"),
        ORIGIN("CARD_SIGNI_CLASS_FAMILY_ORIGIN"),
        FACTION("CARD_SIGNI_CLASS_FAMILY_FACTION");

        private final String label;

        private CardSIGNIClassFamily(String label) {
            this.label = LanguageParser.getString(label);
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum CardSIGNIClass {
        ANCIENT_WEAPON("CARD_SIGNI_CLASS_ANCIENT_WEAPON", CardSIGNIClassFamily.MACHINE),
        ANGEL("CARD_SIGNI_CLASS_ANGEL", CardSIGNIClassFamily.IMAGE),
        APPARITION("CARD_SIGNI_CLASS_APPARITION", CardSIGNIClassFamily.LIVING),
        ARM("CARD_SIGNI_CLASS_ARM", CardSIGNIClassFamily.WAR),
        ATOM("CARD_SIGNI_CLASS_ATOM", CardSIGNIClassFamily.NATURE),
        BACTERIA("CARD_SIGNI_CLASS_BACTERIA", CardSIGNIClassFamily.NATURE),
        BEAUTY("CARD_SIGNI_CLASS_BEAUTY", CardSIGNIClassFamily.IMAGE),
        BLUE_ARCHIVE("CARD_SIGNI_CLASS_BLUE_ARCHIVE", CardSIGNIClassFamily.WAR),
        COOKING("CARD_SIGNI_CLASS_COOKING", CardSIGNIClassFamily.MACHINE),
        DENONBU("CARD_SIGNI_CLASS_DENONBU", CardSIGNIClassFamily.IMAGE),
        DEVIL("CARD_SIGNI_CLASS_DEVIL", CardSIGNIClassFamily.IMAGE),
        DRAGON_BEAST("CARD_SIGNI_CLASS_DRAGON_BEAST", CardSIGNIClassFamily.LIVING),
        EARTH_BEAST("CARD_SIGNI_CLASS_EARTH_BEAST", CardSIGNIClassFamily.LIVING),
        ELECTRIC_MACHINE("CARD_SIGNI_CLASS_ELECTRIC_MACHINE", CardSIGNIClassFamily.MACHINE),
        GEM("CARD_SIGNI_CLASS_GEM", CardSIGNIClassFamily.NATURE),
        LABYRINTH("CARD_SIGNI_CLASS_LABYRINTH", CardSIGNIClassFamily.MACHINE),
        INSECT("CARD_SIGNI_CLASS_INSECT", CardSIGNIClassFamily.LIVING),
        ORE("CARD_SIGNI_CLASS_ORE", CardSIGNIClassFamily.NATURE),
        ORIGIN("CARD_SIGNI_CLASS_ORIGIN", CardSIGNIClassFamily.ORIGIN),
        PLANT("CARD_SIGNI_CLASS_PLANT", CardSIGNIClassFamily.NATURE),
        PLAYGROUND("CARD_SIGNI_CLASS_PLAYGROUND", CardSIGNIClassFamily.WAR),
        PRIPARA("CARD_SIGNI_CLASS_PRIPARA", CardSIGNIClassFamily.IMAGE),
        RIDING_MACHINE("CARD_SIGNI_CLASS_RIDING_MACHINE", CardSIGNIClassFamily.MACHINE),
        SELENE_GIRLS_ACADEMY("CARD_SIGNI_CLASS_SELENE_GIRLS_ACADEMY", CardSIGNIClassFamily.MACHINE),
        SKY_BEAST("CARD_SIGNI_CLASS_SKY_BEAST", CardSIGNIClassFamily.LIVING),
        SPACE("CARD_SIGNI_CLASS_SPACE", CardSIGNIClassFamily.NATURE),
        TRICK("CARD_SIGNI_CLASS_TRICK", CardSIGNIClassFamily.WAR),
        VALOR("CARD_SIGNI_CLASS_VALOR", CardSIGNIClassFamily.IMAGE),
        VENOM_FANG("CARD_SIGNI_CLASS_VENOM_FANG", CardSIGNIClassFamily.WAR),
        VERMILION("CARD_SIGNI_CLASS_VERMILION", CardSIGNIClassFamily.MACHINE),
        VIRTUAL("CARD_SIGNI_CLASS_VIRTUAL", CardSIGNIClassFamily.MACHINE),
        WATER_BEAST("CARD_SIGNI_CLASS_WATER_BEAST", CardSIGNIClassFamily.LIVING),
        WEAPON("CARD_SIGNI_CLASS_WEAPON", CardSIGNIClassFamily.WAR),
        WISDOM("CARD_SIGNI_CLASS_WISDOM", CardSIGNIClassFamily.IMAGE),
        DEFENSE_FACTION("CARD_SIGNI_CLASS_DEFENSE_FACTION", CardSIGNIClassFamily.FACTION),
        STRUGGLE_FACTION("CARD_SIGNI_CLASS_STRUGGLE_FACTION", CardSIGNIClassFamily.FACTION),
        LIBERATION_FACTION("CARD_SIGNI_CLASS_LIBERATION_FACTION", CardSIGNIClassFamily.FACTION);

        private final String label;
        private final CardSIGNIClassFamily family;
        private static final Map<String, CardSIGNIClass> mapLabels;

        private CardSIGNIClass(String label, CardSIGNIClassFamily family) {
            this.label = LanguageParser.getString(label);
            this.family = family;
        }

        public String getLabel() {
            return this.label;
        }

        public CardSIGNIClassFamily getClassFamily() {
            return this.family;
        }

        public static CardSIGNIClass getSIGNIClassByLabel(String label) {
            return mapLabels.get(label);
        }

        static {
            mapLabels = Arrays.stream(CardSIGNIClass.values()).collect(Collectors.toMap(CardSIGNIClass::getLabel, Function.identity()));
        }
    }

    public static enum CardLRIGTeam {
        DREAM_TEAM,
        ANCIENT_SURPRISE,
        SANBAKA,
        NO_LIMIT,
        CARD_JOCKEY,
        UNIVERSE_BEGINNING,
        DIAGRAM,
        DEUS_EX_MACHINA,
        KYURUKYURUN,
        MUGEN_SHOUJO;

    }

    public static enum CardLRIGType {
        NO_LRIG_LIMIT("CARD_LRIG_TYPE_NO_LIMIT"),
        AIYAI("CARD_LRIG_TYPE_AIYAI"),
        AKINO("CARD_LRIG_TYPE_AKINO"),
        AKIRA("CARD_LRIG_TYPE_AKIRA"),
        ALFOU("CARD_LRIG_TYPE_ALFOU"),
        ANGE("CARD_LRIG_TYPE_ANGE"),
        ANN("CARD_LRIG_TYPE_ANN"),
        AT("CARD_LRIG_TYPE_AT"),
        AYA("CARD_LRIG_TYPE_AYA"),
        AZAELA("CARD_LRIG_TYPE_AZAELA"),
        AZUSA("CARD_LRIG_TYPE_AZUSA"),
        BANG("CARD_LRIG_TYPE_BANG"),
        CARNIVAL("CARD_LRIG_TYPE_CARNIVAL"),
        CC("CARD_LRIG_TYPE_CC"),
        CHIYORI("CARD_LRIG_TYPE_CHIYORI"),
        DEUS("CARD_LRIG_TYPE_DEUS"),
        DONA("CARD_LRIG_TYPE_DONA"),
        ELDORA("CARD_LRIG_TYPE_ELDORA"),
        EMMA("CARD_LRIG_TYPE_EMMA"),
        FORECLOSURE_TASK_FORCE("CARD_LRIG_TYPE_FORECLOSURE_TASK_FORCE"),
        EX("CARD_LRIG_TYPE_EX"),
        FUTASE("CARD_LRIG_TYPE_FUTASE"),
        GABRIELA("CARD_LRIG_TYPE_GABRIELA"),
        GUZUKO("CARD_LRIG_TYPE_GUZUKO"),
        HAITY("CARD_LRIG_TYPE_HAITY"),
        HANARE("CARD_LRIG_TYPE_HANARE"),
        HANAYO("CARD_LRIG_TYPE_HANAYO"),
        HINA("CARD_LRIG_TYPE_HINA"),
        HIRANA("CARD_LRIG_TYPE_HIRANA"),
        HITOE("CARD_LRIG_TYPE_HITOE"),
        HOSHINO("CARD_LRIG_TYPE_HOSHINO"),
        IONA("CARD_LRIG_TYPE_IONA"),
        LALARU("CARD_LRIG_TYPE_LALARU"),
        LAYLA("CARD_LRIG_TYPE_LAYLA"),
        LION("CARD_LRIG_TYPE_LION"),
        LIZE("CARD_LRIG_TYPE_LIZE"),
        LOV("CARD_LRIG_TYPE_LOV"),
        LOVIT("CARD_LRIG_TYPE_LOVIT"),
        MACHINA("CARD_LRIG_TYPE_MACHINA"),
        MADOKA("CARD_LRIG_TYPE_MADOKA"),
        MAHOMAHO("CARD_LRIG_TYPE_MAHOMAHO"),
        MAKEUP_WORK_CLUB("CARD_LRIG_TYPE_MAKEUP_WORK_CLUB"),
        MAMA("CARD_LRIG_TYPE_MAMA"),
        MEL("CARD_LRIG_TYPE_MEL"),
        MICHAELA("CARD_LRIG_TYPE_MICHAELA"),
        MIDORIKO("CARD_LRIG_TYPE_MIDORIKO"),
        MIKOMIKO("CARD_LRIG_TYPE_MIKOMIKO"),
        MILULUN("CARD_LRIG_TYPE_MILULUN"),
        MITO("CARD_LRIG_TYPE_MITO"),
        MIYAKO("CARD_LRIG_TYPE_MIYAKO"),
        MUGEN("CARD_LRIG_TYPE_MUGEN"),
        MUZICA("CARD_LRIG_TYPE_MUZICA"),
        MYU("CARD_LRIG_TYPE_MYU"),
        NANASHI("CARD_LRIG_TYPE_NANASHI"),
        NERU("CARD_LRIG_TYPE_NERU"),
        NIJISANJI("CARD_LRIG_TYPE_NIJISANJI"),
        NOVA("CARD_LRIG_TYPE_NOVA"),
        PIRULUK("CARD_LRIG_TYPE_PIRULUK"),
        PREFECT_TEAM("CARD_LRIG_TYPE_PREFECT_TEAM"),
        REI("CARD_LRIG_TYPE_REI"),
        REMEMBER("CARD_LRIG_TYPE_REMEMBER"),
        RIL("CARD_LRIG_TYPE_RIL"),
        RUUKO("CARD_LRIG_TYPE_RUUKO"),
        SANGA("CARD_LRIG_TYPE_SANGA"),
        SAORI("CARD_LRIG_TYPE_SAORI"),
        SASHE("CARD_LRIG_TYPE_SASHE"),
        SHIROKO("CARD_LRIG_TYPE_SHIROKO"),
        SHUN("CARD_LRIG_TYPE_SHUN"),
        SOUI("CARD_LRIG_TYPE_SOUI"),
        TAMA("CARD_LRIG_TYPE_TAMA"),
        TAMAGO("CARD_LRIG_TYPE_TAMAGO"),
        TAWIL("CARD_LRIG_TYPE_TAWIL"),
        TOKO("CARD_LRIG_TYPE_TOKO"),
        UMR("CARD_LRIG_TYPE_UMR"),
        URITH("CARD_LRIG_TYPE_URITH"),
        WOLF("CARD_LRIG_TYPE_WOLF"),
        YAMINO("CARD_LRIG_TYPE_YAMINO"),
        YUKARI("CARD_LRIG_TYPE_YUKARI"),
        YUKAYUKA("CARD_LRIG_TYPE_YUKAYUKA"),
        YUKIME("CARD_LRIG_TYPE_YUKIME"),
        YUZUKI("CARD_LRIG_TYPE_YUZUKI"),
        WHITE_ROOM("CARD_LRIG_TYPE_WHITE_ROOM");

        private final String label;
        private static final Map<String, CardLRIGType> mapLabels;

        private CardLRIGType(String label) {
            this.label = LanguageParser.getString(label);
        }

        public String getLabel() {
            return this.label;
        }

        public static CardLRIGType getLRIGTypeByLabel(String label) {
            return mapLabels.get(label);
        }

        static {
            mapLabels = Arrays.stream(CardLRIGType.values()).collect(Collectors.toMap(CardLRIGType::getLabel, Function.identity()));
        }
    }

    public static enum CardColor {
        WHITE("CARD_COLOR_WHITE", 'W'),
        RED("CARD_COLOR_RED", 'R'),
        BLUE("CARD_COLOR_BLUE", 'B'),
        GREEN("CARD_COLOR_GREEN", 'G'),
        BLACK("CARD_COLOR_BLACK", 'K'),
        COLORLESS("CARD_COLOR_NONE", 'X');

        public static final CardColor[] UTIL_COLORS;
        private final String label;
        private final char shortLabel;
        private final String displayShortLabel;
        private static final Map<Character, CardColor> mapLabelsShort;
        private static final Map<String, CardColor> mapLabels;

        private CardColor(String label, char shortLabel) {
            this.label = LanguageParser.getString(label);
            this.shortLabel = shortLabel;
            this.displayShortLabel = LanguageParser.isStringUndefined(label + "_SHORT") ? String.valueOf(shortLabel) : LanguageParser.getString(label + "_SHORT");
        }

        public String getLabel() {
            return this.label;
        }

        public char getShortLabel() {
            return this.shortLabel;
        }

        public String getDisplayShortLabel() {
            return this.displayShortLabel;
        }

        public static CardColor getColorByLabel(String label) {
            return mapLabels.get(label);
        }

        public static CardColor getColorByShortLabel(char shortLabel) {
            return mapLabelsShort.get(Character.valueOf(shortLabel));
        }

        public static Color utilCardColorToJavaFXColor(CardColor color, double saturation, double brightness) {
            return switch (color.ordinal()) {
                case 0 -> Color.hsb((double)45.0, (double)(saturation * 0.2), (double)brightness);
                case 1 -> Color.hsb((double)0.0, (double)saturation, (double)brightness);
                case 2 -> Color.hsb((double)240.0, (double)saturation, (double)brightness);
                case 3 -> Color.hsb((double)120.0, (double)saturation, (double)brightness);
                case 4 -> Color.hsb((double)300.0, (double)saturation, (double)brightness);
                default -> Color.hsb((double)0.0, (double)0.0, (double)(brightness / 2.0));
            };
        }

        static {
            UTIL_COLORS = new CardColor[]{WHITE, RED, BLUE, GREEN, BLACK};
            mapLabelsShort = Arrays.stream(CardColor.values()).collect(Collectors.toMap(CardColor::getShortLabel, Function.identity()));
            mapLabels = Arrays.stream(CardColor.values()).collect(Collectors.toMap(CardColor::getLabel, Function.identity()));
        }
    }

    public static enum CardType {
        LRIG("CARD_TYPE_LRIG"),
        LRIG_ASSIST("CARD_TYPE_ASSIST_LRIG"),
        SIGNI("CARD_TYPE_SIGNI"),
        RESONA("CARD_TYPE_RESONA"),
        SPELL("CARD_TYPE_SPELL"),
        ARTS("CARD_TYPE_ARTS"),
        KEY("CARD_TYPE_KEY"),
        PIECE("CARD_TYPE_PIECE"),
        TOKEN("CATALOG_FILTER_RESTRICT_TOKEN");

        private final String label;
        private static final Map<String, CardType> mapLabels;

        private CardType(String label) {
            this.label = LanguageParser.getString(label);
        }

        public String getLabel() {
            return this.label;
        }

        public static CardType getTypeByLabel(String label) {
            return mapLabels.get(label);
        }

        public static boolean isSIGNI(CardType cardType) {
            return cardType == SIGNI || cardType == RESONA;
        }

        public static boolean isLRIG(CardType cardType) {
            return cardType == LRIG || cardType == LRIG_ASSIST;
        }

        public static boolean isCardInHorizontalOrientation(CardType cardType) {
            return cardType == PIECE || cardType == KEY;
        }

        static {
            mapLabels = Arrays.stream(CardType.values()).collect(Collectors.toMap(CardType::getLabel, Function.identity()));
        }
    }
}

