/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.CardConst;
import open.batoru.data.CardData;
import open.batoru.data.DataTable;
import open.batoru.data.ModifiableList;
import open.batoru.parsers.LanguageParser;

public class CardDataSIGNIClass
extends ModifiableList<CardSIGNIClassValue>
implements CardData<CardSIGNIClassValue> {
    public CardDataSIGNIClass() {
        super(List.of());
    }

    public CardDataSIGNIClass(CardDataSIGNIClass dataSIGNIClass) {
        super(dataSIGNIClass.getValue());
    }

    public CardDataSIGNIClass(List<CardSIGNIClassValue> listSIGNIClasses) {
        super(listSIGNIClasses);
    }

    public void set(CardConst.CardSIGNIClassGeneration generation, CardConst.CardSIGNIClass ... cardSIGNIClasses) {
        ArrayList<CardSIGNIClassValue> list = new ArrayList<CardSIGNIClassValue>();
        for (CardConst.CardSIGNIClass cardSIGNIClass : cardSIGNIClasses) {
            list.add(new CardSIGNIClassValue(generation, cardSIGNIClass));
        }
        this.setBaseValue(list);
    }

    public boolean matches(CardConst.CardSIGNIClass cardSIGNIClass) {
        return this.getValue().stream().anyMatch(v -> v.cardSIGNIClass() == cardSIGNIClass);
    }

    public boolean matches(CardConst.CardSIGNIClass ... cardSIGNIClasses) {
        return this.getValue().stream().map(CardSIGNIClassValue::cardSIGNIClass).anyMatch(List.of(cardSIGNIClasses)::contains);
    }

    public boolean matchesExact(CardConst.CardSIGNIClassGeneration generation, CardConst.CardSIGNIClass ... cardSIGNIClasses) {
        return this.getValue().stream().filter(v -> v.generation() == generation).map(CardSIGNIClassValue::cardSIGNIClass).anyMatch(List.of(cardSIGNIClasses)::contains);
    }

    public boolean matches(CardDataSIGNIClass dataSIGNIClass) {
        return this.getValue().stream().anyMatch(((List)dataSIGNIClass.getValue())::contains);
    }

    @Override
    public CardSIGNIClassValue getPrimaryValue() {
        return !this.getBaseValue().isEmpty() ? (CardSIGNIClassValue)this.getBaseValue().getFirst() : null;
    }

    public static boolean containsTwoWithoutCommonClass(DataTable<CardIndex> data) {
        if (data == null || data.size() < 2) {
            return false;
        }
        for (int i = 0; i < data.size() - 1; ++i) {
            CardDataSIGNIClass dataSIGNIClass1 = data.get(i).getIndexedInstance().getSIGNIClass();
            for (int ii = i + 1; ii < data.size(); ++ii) {
                CardDataSIGNIClass dataSIGNIClass2 = data.get(ii).getIndexedInstance().getSIGNIClass();
                if (dataSIGNIClass1.matches(dataSIGNIClass2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shareCommonClass(DataTable<CardIndex> data) {
        if (data == null || data.size() < 2) {
            return false;
        }
        for (int i = 0; i < data.size() - 1; ++i) {
            HashSet dataSIGNIClass1 = new HashSet(data.get(i).getIndexedInstance().getSIGNIClass().getValue());
            for (int ii = i + 1; ii < data.size(); ++ii) {
                HashSet dataSIGNIClass2 = new HashSet(data.get(ii).getIndexedInstance().getSIGNIClass().getValue());
                for (CardSIGNIClassValue cardSIGNIClassValue : dataSIGNIClass1) {
                    if (!dataSIGNIClass2.contains(cardSIGNIClassValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getClassesCount(DataTable<CardIndex> data) {
        if (data == null || data.isEmpty() || data.get() == null) {
            return 0;
        }
        HashSet unique = new HashSet();
        for (int i = 0; i < data.size(); ++i) {
            CardIndex cardIndex = data.get(i);
            unique.addAll(cardIndex.getIndexedInstance().getSIGNIClass().getValue());
        }
        return unique.size();
    }

    public record CardSIGNIClassValue(CardConst.CardSIGNIClassGeneration generation, CardConst.CardSIGNIClass cardSIGNIClass) implements Comparable<CardSIGNIClassValue>
    {
        @Override
        public int compareTo(CardSIGNIClassValue other) {
            return Comparator.comparing(value -> ((CardSIGNIClassValue)value).cardSIGNIClass.getLabel(), LanguageParser.getCollator()).thenComparing(value -> ((CardSIGNIClassValue)value).generation).compare(this, other);
        }
    }
}

