/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import open.batoru.data.Card;
import open.batoru.data.CardConst;

public class Cost {
    public static final String COIN = "C";
    public static final String ANY_COLORED = "A";
    public static final String KEY = "Y";

    public static String color(CardConst.CardColor color, int amount) {
        return amount >= 1 ? String.valueOf(color.getShortLabel()).repeat(amount) : "";
    }

    public static String colorless(int amount) {
        return amount >= 1 ? String.valueOf(CardConst.CardColor.COLORLESS.getShortLabel()).repeat(amount) : "";
    }

    public static String coin(int amount) {
        return amount >= 1 ? COIN.repeat(amount) : "";
    }

    public static String anyColored(int amount) {
        return amount >= 1 ? ANY_COLORED.repeat(amount) : "";
    }

    public static String key() {
        return KEY;
    }

    public static int getOriginalCostAsNumber(Card cardObject) {
        return !cardObject.getCost().getDataArray().isEmpty() ? cardObject.getCost().getDataArray().getFirst().length() : 0;
    }

    public static String getUniqueCostString(String costString) {
        StringBuilder costStringUnique = new StringBuilder();
        HashSet<Character> cacheAddedStrings = new HashSet<Character>();
        for (char c : costString.toCharArray()) {
            if (!cacheAddedStrings.add(Character.valueOf(c))) continue;
            costStringUnique.append(c);
        }
        return costStringUnique.toString();
    }

    public static Map<CardConst.CardColor, Integer> getMappedColorsCount(String costString) {
        EnumMap<CardConst.CardColor, Integer> map = new EnumMap<CardConst.CardColor, Integer>(CardConst.CardColor.class);
        for (char c : costString.toCharArray()) {
            map.merge(CardConst.CardColor.getColorByShortLabel(c), 1, Integer::sum);
        }
        for (CardConst.CardColor color : CardConst.CardColor.values()) {
            map.putIfAbsent(color, 0);
        }
        return map;
    }

    private Cost() {
    }
}

