/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionExclude;
import open.batoru.core.gameplay.actions.ActionReturnToDeck;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.cost.AbilityCost;

public class ARTSAbility
extends CheckZoneAbility {
    private final List<AbilityCostList> listCostsEncore = new ArrayList<AbilityCostList>();
    private boolean hasUsedEncore;

    public ARTSAbility(AbilityEffectNoSource effect) {
        super(effect);
        this.setActiveEvent(GameConst.GameEventId.USE_ARTS);
    }

    @Override
    public void onAbilityEnd(boolean wasResolved) {
        if (this.getSourceCardIndex().getLocation() == GameConst.CardLocation.CHECK_ZONE) {
            if (!this.getSourceCardIndex().getIndexedInstance().isState(8)) {
                Game.getCurrentGame().getActionQueue().addAction(!this.hasUsedEncore ? new ActionTrash(this.getSourceCardIndex()) : new ActionReturnToDeck(this.getSourceCardIndex(), Deck.DeckPosition.TOP));
            } else {
                Game.getCurrentGame().getActionQueue().addAction(new ActionExclude(this.getSourceCardIndex()));
            }
        }
        super.onAbilityEnd(wasResolved);
        this.hasUsedEncore = false;
    }

    public void setEncoreCost(AbilityCost cost) {
        AbilityCostList costList = new AbilityCostList(cost);
        costList.setSourceAbility(this);
        this.listCostsEncore.add(costList);
    }

    public final List<AbilityCostList> getEncoreCostLists() {
        return this.listCostsEncore;
    }

    public void setHasUsedEncore() {
        this.hasUsedEncore = true;
    }

    public boolean hasUsedEncore() {
        return this.hasUsedEncore;
    }

    @Override
    public void onAbilityInit() {
        this.setActiveUseTiming(this.getSourceCardIndex().getIndexedInstance().getUseTimingFlags().getValue());
        super.onAbilityInit();
    }

    @Override
    public void dispose() {
        this.listCostsEncore.forEach(AbilityCostList::dispose);
        this.listCostsEncore.clear();
        super.dispose();
    }

    public static Optional<ARTSAbility> findARTSAbility(CardIndex cardIndex) {
        return cardIndex.getIndexedInstance().getAbilityList().stream().filter(ARTSAbility.class::isInstance).findFirst().map(ARTSAbility.class::cast);
    }
}

