/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.DataTableRuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.DataTable;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.cost.TrashCost;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class AbilityCostList
implements Disposable {
    private final List<AbilityCost> dataCosts = new ArrayList<AbilityCost>();
    private final DataTable<AbilityCost.Payable> listPaidCostData = new DataTable();
    private int numReservedEner;
    private boolean lastCanBePaidPrivately;
    private int totalPaidCosts;
    private OnCostHandledHandler handler;
    private List<AbilityCostList> sourceDataCostLists;

    public AbilityCostList(AbilityCost ... costs) {
        List<AbilityCost> listCosts = Arrays.asList(costs);
        if (listCosts.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.dataCosts.addAll(listCosts);
    }

    public AbilityCostList(List<AbilityCost> listCosts) {
        if (listCosts.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.dataCosts.addAll(listCosts);
    }

    public void setSourceAbility(Ability ability) {
        for (AbilityCost cost : this.dataCosts) {
            cost.setSourceAbility(ability);
            cost.setSourceCardIndex(ability.getSourceCardIndex());
            cost.setSourceCostList(this);
        }
    }

    public void setSourceCardIndex(CardIndex cardIndex) {
        for (AbilityCost cost : this.dataCosts) {
            cost.setSourceCardIndex(cardIndex);
            cost.setSourceCostList(this);
        }
    }

    public void treatAsEffect() {
        for (AbilityCost cost : this.dataCosts) {
            cost.treatAsEffect();
        }
    }

    public void setForcedMandatoryState(Boolean state) {
        for (AbilityCost cost : this.dataCosts) {
            cost.setForcedMandatoryState(state);
        }
    }

    public void setPayerRole(Game.GamePlayerRole rolePlayer) {
        for (AbilityCost cost : this.dataCosts) {
            cost.setPayerRole(rolePlayer);
        }
    }

    public void resetPaidCostData() {
        this.listPaidCostData.clear();
        for (AbilityCost cost : this.dataCosts) {
            cost.getPaidCostData().clear();
        }
    }

    public DataTable<AbilityCost.Payable> getPaidCostData() {
        return this.listPaidCostData;
    }

    public boolean canBePaidPrivately() {
        return this.lastCanBePaidPrivately;
    }

    public boolean canBePaid() {
        HashMap<Class, ArrayList> map = new HashMap<Class, ArrayList>();
        for (AbilityCost cost2 : this.dataCosts) {
            map.computeIfAbsent(cost2.getClass(), k -> new ArrayList()).add(cost2);
        }
        this.numReservedEner = 0;
        if (map.containsKey(EnerCost.class) && map.containsKey(TrashCost.class)) {
            List<TrashCost> trashFromEnerCosts = ((ArrayList)map.get(TrashCost.class)).stream().filter(cost -> cost.getFilter() != null && cost.getFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.ENER)).map(TrashCost.class::cast).toList();
            if (!trashFromEnerCosts.isEmpty()) {
                TrashCost first = trashFromEnerCosts.getFirst();
                Game.GamePlayerRole rolePayer = first.getPayerRole();
                DataTableRuleCheck ruleCheckDataEnerSubstitute = (DataTableRuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.DATA_CARDS_ENER_SUBSTITUTE);
                DataTable dataCardsEnerSubstitute = (DataTable)ruleCheckDataEnerSubstitute.check(rolePayer, first.getSourceCardIndex(), first.getSourceAbility(), new Object[0]);
                int numPayableCardsFromEner = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePayer).getEnerZone().getTotalCards() + dataCardsEnerSubstitute.size();
                for (TrashCost trashCost : trashFromEnerCosts) {
                    if (!trashCost.hasDynamicCost()) {
                        this.numReservedEner += trashCost.getChoiceLogic() == AbilityConst.ChoiceLogic.DEFAULT ? trashCost.getCostMinCount() : trashCost.getCostMaxCount();
                    } else {
                        List enerCosts = (List)map.get(EnerCost.class);
                        for (AbilityCost cost3 : enerCosts) {
                            this.numReservedEner += ((EnerCost)cost3).getCostString().getValue().length();
                        }
                    }
                    if (this.numReservedEner < numPayableCardsFromEner) continue;
                    return false;
                }
            }
        }
        for (List list : map.values()) {
            if (list.size() <= 1 || ((AbilityCost)list.getFirst()).getFilter() != null && ((AbilityCost)list.getLast()).getFilter() != null && !((AbilityCost)list.getFirst()).getFilter().getHintLocationsData().equals(((AbilityCost)list.getLast()).getFilter().getHintLocationsData())) continue;
            AbilityCost costFirst = (AbilityCost)list.getFirst();
            if (!(costFirst instanceof EnerCost)) {
                int totalMinCount = costFirst.getChoiceLogic() == AbilityConst.ChoiceLogic.DEFAULT ? 0 : costFirst.getCostMaxCount();
                int totalMaxCount = 0;
                for (int i = 1; i < list.size(); ++i) {
                    AbilityCost cost4 = (AbilityCost)list.get(i);
                    totalMinCount += cost4.getChoiceLogic() == AbilityConst.ChoiceLogic.DEFAULT ? cost4.getCostMinCount() : cost4.getCostMaxCount();
                    totalMaxCount += cost4.getCostMaxCount();
                }
                ModifiableVariable.ModifiableValueReference<Integer> valueRefMinCount = costFirst.getModifiableCostMinCount().addValue(totalMinCount);
                ModifiableVariable.ModifiableValueReference<Integer> valueRefMaxCount = costFirst.getModifiableCostMaxCount().addValue(totalMaxCount);
                boolean canBePaid = costFirst.canBePaid();
                costFirst.getModifiableCostMinCount().removeValue(valueRefMinCount);
                costFirst.getModifiableCostMaxCount().removeValue(valueRefMaxCount);
                if (canBePaid) continue;
                return false;
            }
            EnerCost enerCost = (EnerCost)costFirst;
            StringBuilder costString = new StringBuilder();
            for (int i = 1; i < list.size(); ++i) {
                costString.append(((EnerCost)list.get(i)).getCostString().getValue());
            }
            if (costString.isEmpty()) continue;
            ModifiableVariable.ModifiableValueReference<String> valueRef = enerCost.getCostString().addValue(costString.toString());
            boolean canBePaid = costFirst.canBePaid();
            enerCost.getCostString().removeValue(valueRef);
            if (canBePaid) continue;
            return false;
        }
        this.lastCanBePaidPrivately = true;
        for (AbilityCost cost2 : this.dataCosts) {
            cost2.setCanBePaidPrivately(null);
            if (!cost2.canBePaid()) {
                return false;
            }
            if (cost2.getCanBePaidPrivately() == null || cost2.getCanBePaidPrivately().booleanValue()) continue;
            this.lastCanBePaidPrivately = false;
        }
        return true;
    }

    public void payAll() {
        this.totalPaidCosts = 0;
        this.resetPaidCostData();
        if (!this.dataCosts.isEmpty()) {
            this.dataCosts.getFirst().internalPay();
        } else {
            this.markCostAsCompleted(null);
        }
    }

    public void markCostAsCompleted(AbilityCost cost) {
        if (cost != null && cost.isPaid() && ++this.totalPaidCosts < this.dataCosts.size()) {
            this.dataCosts.get(this.totalPaidCosts).internalPay();
            return;
        }
        if (this.handler != null) {
            if (!this.isPaid()) {
                this.resetPaidCostData();
            }
            FX.run(() -> {
                this.handler.handle();
                this.handler = null;
            });
        }
    }

    public boolean isPaid() {
        return this.totalPaidCosts >= this.dataCosts.size() || this.dataCosts.isEmpty();
    }

    public boolean isVisuallySignificant() {
        return this.dataCosts.stream().anyMatch(AbilityCost::isVisuallySignificant);
    }

    public int getReservedEnerCount() {
        return this.numReservedEner;
    }

    public List<AbilityCost> getDataArray() {
        return this.dataCosts;
    }

    public final void setOnCostHandledAll(OnCostHandledHandler handler) {
        this.handler = handler;
    }

    public void setSourceDataCostLists(List<AbilityCostList> dataCostLists) {
        this.sourceDataCostLists = dataCostLists;
    }

    public List<AbilityCostList> getSourceDataCostLists() {
        return this.sourceDataCostLists;
    }

    @Override
    public void dispose() {
        this.dataCosts.forEach(AbilityCost::dispose);
        this.dataCosts.clear();
        this.listPaidCostData.clear();
        this.handler = null;
        this.sourceDataCostLists = null;
    }

    public static boolean canPayDataCostLists(List<AbilityCostList> dataCostLists) {
        return dataCostLists.isEmpty() || dataCostLists.stream().anyMatch(AbilityCostList::canBePaid);
    }

    public static boolean canPayDataCostListsPrivately(List<AbilityCostList> dataCostLists) {
        return dataCostLists.isEmpty() || dataCostLists.stream().anyMatch(costList -> costList.canBePaid() && costList.canBePaidPrivately());
    }

    @FunctionalInterface
    public static interface OnCostHandledHandler {
        public void handle();
    }
}

