/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.AbilityEffectWithSource;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.data.ability.events.GameEventAccumulator;

public class AutoAbility
extends Ability {
    private boolean areUnifiedMoveEventsEnabled;
    private GameEventAccumulator accumulator;

    public AutoAbility(GameConst.GameEventId event, AbilityEffectWithSource effect) {
        if (event == null || effect == null) {
            throw new IllegalArgumentException();
        }
        this.setEffect(effect);
        this.setActiveEvent(event);
    }

    public AutoAbility(GameConst.GameEventId event, AbilityEffectNoSource effect) {
        if (event == null || effect == null) {
            throw new IllegalArgumentException();
        }
        this.setEffect(effect);
        this.setActiveEvent(event);
    }

    AutoAbility() {
    }

    public void enableUnifiedMoveEvents() {
        this.areUnifiedMoveEventsEnabled = true;
    }

    public void enableEventSourceSelection() {
        this.accumulator = new GameEventAccumulator();
    }

    public GameEventAccumulator getEventAccumulator() {
        return this.accumulator;
    }

    @Override
    public boolean isActiveDuringEvent(GameEvent event) {
        if (!this.areUnifiedMoveEventsEnabled) {
            return super.isActiveDuringEvent(event);
        }
        return !(this.getActiveEvent() != GameConst.GameEventId.MOVE && this.getActiveEvent() != GameConst.GameEventId.MOVE_UNDER || event.getId() != GameConst.GameEventId.MOVE && event.getId() != GameConst.GameEventId.MOVE_UNDER);
    }

    @Override
    public void dispose() {
        if (this.accumulator != null) {
            this.accumulator.dispose();
            this.accumulator = null;
        }
        super.dispose();
    }
}

