/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import javafx.application.Platform;
import open.batoru.Log;
import open.batoru.catalog.SearchFilter;
import open.batoru.catalog.UtilCardDataFormatter;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Deck;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.PlayerGameData;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.GameLog;
import open.batoru.core.gameplay.actions.ActionAddToHand;
import open.batoru.core.gameplay.actions.ActionAddToLifeCloth;
import open.batoru.core.gameplay.actions.ActionAttach;
import open.batoru.core.gameplay.actions.ActionBanish;
import open.batoru.core.gameplay.actions.ActionCallDelayedEffect;
import open.batoru.core.gameplay.actions.ActionCancel;
import open.batoru.core.gameplay.actions.ActionCraft;
import open.batoru.core.gameplay.actions.ActionCrush;
import open.batoru.core.gameplay.actions.ActionDamage;
import open.batoru.core.gameplay.actions.ActionDisableAllAbilities;
import open.batoru.core.gameplay.actions.ActionDiscard;
import open.batoru.core.gameplay.actions.ActionDown;
import open.batoru.core.gameplay.actions.ActionDraw;
import open.batoru.core.gameplay.actions.ActionEffectActivateResolve;
import open.batoru.core.gameplay.actions.ActionEmpty;
import open.batoru.core.gameplay.actions.ActionEnerCharge;
import open.batoru.core.gameplay.actions.ActionExchange;
import open.batoru.core.gameplay.actions.ActionExclude;
import open.batoru.core.gameplay.actions.ActionFlip;
import open.batoru.core.gameplay.actions.ActionForceTurnEnd;
import open.batoru.core.gameplay.actions.ActionFreeze;
import open.batoru.core.gameplay.actions.ActionGainBond;
import open.batoru.core.gameplay.actions.ActionGainCoins;
import open.batoru.core.gameplay.actions.ActionGainPower;
import open.batoru.core.gameplay.actions.ActionGainValue;
import open.batoru.core.gameplay.actions.ActionGameEnd;
import open.batoru.core.gameplay.actions.ActionGrow;
import open.batoru.core.gameplay.actions.ActionInviteCollaboLivers;
import open.batoru.core.gameplay.actions.ActionLook;
import open.batoru.core.gameplay.actions.ActionManualChoice;
import open.batoru.core.gameplay.actions.ActionManualChoiceAbility;
import open.batoru.core.gameplay.actions.ActionManualChoiceByRef;
import open.batoru.core.gameplay.actions.ActionManualChoiceCatalog;
import open.batoru.core.gameplay.actions.ActionManualChoiceCatalogBond;
import open.batoru.core.gameplay.actions.ActionManualChoiceCost;
import open.batoru.core.gameplay.actions.ActionManualChoiceDistribute;
import open.batoru.core.gameplay.actions.ActionManualChoiceHand;
import open.batoru.core.gameplay.actions.ActionManualChoiceMode;
import open.batoru.core.gameplay.actions.ActionManualDiscard;
import open.batoru.core.gameplay.actions.ActionManualGrow;
import open.batoru.core.gameplay.actions.ActionManualSearchDeck;
import open.batoru.core.gameplay.actions.ActionManualTargetCard;
import open.batoru.core.gameplay.actions.ActionManualTargetZone;
import open.batoru.core.gameplay.actions.ActionMillDeck;
import open.batoru.core.gameplay.actions.ActionMoveToSIGNIZone;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceString;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceZone;
import open.batoru.core.gameplay.actions.ActionPutInCheckZone;
import open.batoru.core.gameplay.actions.ActionPutInEner;
import open.batoru.core.gameplay.actions.ActionPutOnFieldKeyPre;
import open.batoru.core.gameplay.actions.ActionPutOnFieldSIGNI;
import open.batoru.core.gameplay.actions.ActionPutOnFieldSpell;
import open.batoru.core.gameplay.actions.ActionPutOnZone;
import open.batoru.core.gameplay.actions.ActionRequestInfoDeck;
import open.batoru.core.gameplay.actions.ActionRequestInfoPrivateCard;
import open.batoru.core.gameplay.actions.ActionReturnToDeck;
import open.batoru.core.gameplay.actions.ActionReveal;
import open.batoru.core.gameplay.actions.ActionRide;
import open.batoru.core.gameplay.actions.ActionSetBasePower;
import open.batoru.core.gameplay.actions.ActionSetBaseValue;
import open.batoru.core.gameplay.actions.ActionShuffleDeck;
import open.batoru.core.gameplay.actions.ActionTransform;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.core.gameplay.actions.ActionUp;
import open.batoru.core.gameplay.actions.ActionZoneAttachObject;
import open.batoru.core.gameplay.actions.ActionZoneDelete;
import open.batoru.core.gameplay.actions.ActionZoneRemoveObject;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.control.UtilCardPlayableControl;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.RuleCheckCanPlaceSIGNIOnZone;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataColor;
import open.batoru.data.CardDataSIGNIClass;
import open.batoru.data.CardDataType;
import open.batoru.data.CardLoader;
import open.batoru.data.DataTable;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ValueByReference;
import open.batoru.data.ValueByReferenceOptions;
import open.batoru.data.ability.ARTSAbility;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityConditionNoSource;
import open.batoru.data.ability.AbilityConditionWithSource;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.AbilityEffectWithSource;
import open.batoru.data.ability.AbilityFunctionalConditionalHandler;
import open.batoru.data.ability.AbilityFunctionalHandler;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.CardFunctionalConditionalHandler;
import open.batoru.data.ability.CardFunctionalHandler;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.ConstantAbilityShared;
import open.batoru.data.ability.DamageBlockParams;
import open.batoru.data.ability.EnterAbility;
import open.batoru.data.ability.FieldZoneFunctionalHandler;
import open.batoru.data.ability.LifeBurstAbility;
import open.batoru.data.ability.PieceAbility;
import open.batoru.data.ability.SpellAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.events.EventAbilityGain;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.EventPlace;
import open.batoru.data.ability.events.EventReveal;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.data.ability.events.GameEventTrigger;
import open.batoru.data.ability.modifiers.AbilityGainModifier;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.data.ability.modifiers.CostModifier;
import open.batoru.data.ability.modifiers.PlayerAbilityGainModifier;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.data.ability.stock.StockPlayerAbilityHastalyk;
import open.batoru.data.ability.stock.StockPlayerAbilityToken;
import open.batoru.game.FieldData;
import open.batoru.game.FieldStackZone;
import open.batoru.game.FieldZone;
import open.batoru.game.GameField;
import open.batoru.game.PlayerField;
import open.batoru.game.Zone;
import open.batoru.game.ZoneLRIGAssist;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationMagicBox;
import open.batoru.game.gfx.GFX;
import open.batoru.game.gfx.GFXCardTextureLayer;
import open.batoru.game.overlay.log.events.LogEventAbilityGained;
import open.batoru.game.overlay.log.events.LogEventAbilityLost;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public abstract class CardAbilities
implements Disposable {
    private final int cardId;
    private CardIndex cardIndex;
    private final List<Ability> listAbilities = new ArrayList<Ability>();
    private final List<Ability> cacheRemovedAbilities = new ArrayList<Ability>();
    private List<Ability> listAbilitiesToRemove;
    private String extraDescription;
    private final List<String> listAbilityDescriptions = new ArrayList<String>();
    private int totalAbilities;
    private int totalBaseAbilities;
    private final CardRuleCheckRegistry ruleCheckRegistry = new CardRuleCheckRegistry();
    private GameConst.UseCondition useCond;
    private int useCondNumPicks;
    private TargetFilter useCondFilter;
    private static ActionEffectActivateResolve callbackAction;

    public CardAbilities(int cardId) {
        this.cardId = cardId;
    }

    public final int getCardId() {
        return this.cardId;
    }

    public final CardIndex getCardIndex() {
        if (this.cardIndex == null) {
            this.updateCardIndex();
        }
        return this.cardIndex;
    }

    public final void updateCardIndex() {
        this.cardIndex = Game.getCurrentGame().getIndexRegistry().getIndex(this.cardId);
    }

    public final CardRuleCheckRegistry getRCRegistry() {
        return this.ruleCheckRegistry;
    }

    public final void setUseCondition(GameConst.UseCondition useCondition, TargetFilter filter) {
        this.setUseCondition(useCondition, 1, filter);
    }

    public final void setUseCondition(GameConst.UseCondition useCondition, int numPicks, TargetFilter filter) {
        this.useCond = useCondition;
        this.useCondNumPicks = numPicks;
        if (useCondition != null && filter != null) {
            switch (useCondition) {
                case RISE: {
                    filter.setTargetHint(TargetFilter.TargetHint.RISE);
                    filter = filter.own().SIGNI().not(new TargetFilter().withState(1024)).except(this.cardId);
                    if (numPicks != 1) break;
                    filter = filter.custom(cardIndex -> {
                        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getCardIndex().getIndexedInstance().getCurrentOwner());
                        double sumFieldSIGNILimit = field.getSIGNILimitSum();
                        double maxLimit = field.getLRIGZone().getTopCard().getCardIndex().getIndexedInstance().getLimit().getValue();
                        return sumFieldSIGNILimit - cardIndex.getSIGNILimitConsumption() + this.getCardIndex().getSIGNILimitConsumption() <= maxLimit;
                    });
                    break;
                }
                case RESONA: {
                    filter.setTargetHint(TargetFilter.TargetHint.RESONA);
                    filter = filter.own().SIGNI();
                    break;
                }
                case GROW: {
                    filter = filter.own();
                }
            }
        }
        this.useCondFilter = filter;
    }

    public final GameConst.UseCondition getUseCondition() {
        return this.useCond;
    }

    public final int getUseConditionNumPicks() {
        return this.useCondNumPicks;
    }

    public final TargetFilter getUseConditionTargetFilter() {
        return this.useCondFilter;
    }

    public final ConstantAbility registerConstantAbility(ConstantModifier ... listModifiers) {
        ConstantAbility ability = new ConstantAbility(listModifiers);
        this.addAbility(ability);
        return ability;
    }

    public final ConstantAbility registerConstantAbility(AbilityConditionWithSource condition, ConstantModifier ... listModifiers) {
        ConstantAbility ability = new ConstantAbility(listModifiers);
        ability.setCondition(condition);
        this.addAbility(ability);
        return ability;
    }

    public final ConstantAbility registerConstantAbility(AbilityConditionNoSource condition, ConstantModifier ... listModifiers) {
        ConstantAbility ability = new ConstantAbility(listModifiers);
        ability.setCondition(condition);
        this.addAbility(ability);
        return ability;
    }

    public final ConstantAbility registerConstantAbility(TargetFilter filter, ConstantModifier ... listModifiers) {
        ConstantAbilityShared ability = new ConstantAbilityShared(filter, listModifiers);
        filter.setSourceAbility(ability);
        this.addAbility(ability);
        return ability;
    }

    public final ConstantAbility registerConstantAbility(AbilityConditionWithSource condition, TargetFilter filter, ConstantModifier ... listModifiers) {
        ConstantAbilityShared ability = new ConstantAbilityShared(filter, listModifiers);
        ability.setCondition(condition);
        filter.setSourceAbility(ability);
        this.addAbility(ability);
        return ability;
    }

    public final ConstantAbility registerConstantAbility(AbilityConditionNoSource condition, TargetFilter filter, ConstantModifier ... listModifiers) {
        ConstantAbilityShared ability = new ConstantAbilityShared(filter, listModifiers);
        ability.setCondition(condition);
        filter.setSourceAbility(ability);
        this.addAbility(ability);
        return ability;
    }

    public final EnterAbility registerEnterAbility(AbilityEffectNoSource effect) {
        EnterAbility ability = new EnterAbility(effect);
        this.addAbility(ability);
        return ability;
    }

    public final EnterAbility registerEnterAbility(AbilityCost cost, AbilityEffectNoSource effect) {
        EnterAbility ability = new EnterAbility(cost, effect);
        this.addAbility(ability);
        return ability;
    }

    public final EnterAbility registerEnterAbility(AbilityCostList costList, AbilityEffectNoSource effect) {
        EnterAbility ability = new EnterAbility(costList, effect);
        this.addAbility(ability);
        return ability;
    }

    public final AutoAbility registerAutoAbility(GameConst.GameEventId event, AbilityEffectWithSource effect) {
        AutoAbility ability = new AutoAbility(event, effect);
        this.addAbility(ability);
        return ability;
    }

    public final AutoAbility registerAutoAbility(GameConst.GameEventId event, AbilityEffectNoSource effect) {
        AutoAbility ability = new AutoAbility(event, effect);
        this.addAbility(ability);
        return ability;
    }

    public final ActionAbility registerActionAbility(AbilityCost cost, AbilityEffectNoSource effect) {
        ActionAbility ability = new ActionAbility(cost, effect);
        this.addAbility(ability);
        return ability;
    }

    public final ActionAbility registerActionAbility(AbilityCostList costList, AbilityEffectNoSource effect) {
        ActionAbility ability = new ActionAbility(costList, effect);
        this.addAbility(ability);
        return ability;
    }

    protected final SpellAbility registerSpellAbility(AbilityEffectNoSource effect) {
        return this.registerSpellAbility(null, effect);
    }

    protected final SpellAbility registerSpellAbility(CheckZoneAbility.CheckZoneFunctionalHandler handlerPreTarget, AbilityEffectNoSource effect) {
        SpellAbility ability = new SpellAbility(handlerPreTarget, effect);
        this.addAbility(ability);
        return ability;
    }

    protected final ARTSAbility registerARTSAbility(AbilityEffectNoSource effect) {
        ARTSAbility ability = new ARTSAbility(effect);
        this.addAbility(ability);
        return ability;
    }

    protected final PieceAbility registerPieceAbility(AbilityEffectNoSource effect) {
        return this.registerPieceAbility(null, effect);
    }

    protected final PieceAbility registerPieceAbility(CheckZoneAbility.CheckZoneFunctionalHandler handlerPreTarget, AbilityEffectNoSource effect) {
        PieceAbility ability = new PieceAbility(handlerPreTarget, effect);
        this.addAbility(ability);
        return ability;
    }

    public final LifeBurstAbility registerLifeBurstAbility(AbilityEffectNoSource effect) {
        LifeBurstAbility ability = new LifeBurstAbility(effect);
        this.addAbility(ability);
        return ability;
    }

    public final Ability registerStockAbility(StockAbility stockAbility) {
        Ability ability = stockAbility.getAbility();
        this.addAbility(ability);
        return ability;
    }

    public final boolean attachAbility(CardIndex target, Ability ability, ChronoDuration chronoDuration) {
        return this.attachAbility(target, CardAbilities.getAbility(), ability, new ChronoRecordScheduler.ChronoRecord(target, chronoDuration));
    }

    public final boolean attachAbility(CardIndex target, Ability sourceAttachAbility, Ability ability, ChronoDuration chronoDuration) {
        return this.attachAbility(target, sourceAttachAbility, ability, new ChronoRecordScheduler.ChronoRecord(target, chronoDuration));
    }

    public final boolean attachAbility(CardIndex target, Ability ability, ChronoRecordScheduler.ChronoRecord record) {
        return this.attachAbility(target, CardAbilities.getAbility(), ability, record);
    }

    public final boolean attachAbility(CardIndex target, Ability sourceAttachAbility, Ability ability, ChronoRecordScheduler.ChronoRecord record) {
        if (target == null || ability == null || target.getIndexedInstance().getAbilityList().contains(ability)) {
            return false;
        }
        ability.setSourceCardId(target.getId());
        ability.setSourceAttachAbility(sourceAttachAbility);
        ability.onAbilityInit();
        if (target.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ABILITY_BE_ATTACHED).check(target, ability, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || target.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(target, ability, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            return false;
        }
        target.getIndexedInstance().addAbility(ability);
        if (ability instanceof ConstantAbility) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilitiesUnsafe();
        }
        EventAbilityGain event = new EventAbilityGain(target, ability, sourceAttachAbility);
        if (record != null) {
            record.setOnChronoRecordExpired(() -> {
                target.getIndexedInstance().removeAbility(ability);
                LogEventAbilityLost logEventAbilityLost = new LogEventAbilityLost(event);
                FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEventAbilityLost));
            });
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        }
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(event);
        LogEventAbilityGained logEventAbilityGained = new LogEventAbilityGained(event);
        Platform.runLater(() -> {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(target);
            UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEventAbilityGained);
        });
        return true;
    }

    public final boolean attachAbility(CardIndex target, StockAbility stockAbility, ChronoDuration chronoDuration) {
        if (target == null || stockAbility == null || target.getIndexedInstance().getAbilityList().contains(stockAbility.getAbility())) {
            return false;
        }
        Ability ability = stockAbility.getAbility();
        ability.setSourceCardId(target.getId());
        ability.setSourceAttachAbility(CardAbilities.getAbility());
        ability.onAbilityInit();
        if (target.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ABILITY_BE_ATTACHED).check(target, ability, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || target.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(target, ability, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            return false;
        }
        target.getIndexedInstance().registerStockAbility(stockAbility);
        if (ability instanceof ConstantAbility) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilitiesUnsafe();
        } else {
            ability.callOnAbilityEnabledHandler(target);
        }
        EventAbilityGain event = new EventAbilityGain(target, ability, ability.getSourceAttachAbility());
        ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(target, chronoDuration);
        record.setOnChronoRecordExpired(() -> {
            target.getIndexedInstance().removeAbility(ability);
            LogEventAbilityLost logEventAbilityLost = new LogEventAbilityLost(event);
            FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEventAbilityLost));
        });
        Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(event);
        LogEventAbilityGained logEventAbilityGained = new LogEventAbilityGained(event);
        Platform.runLater(() -> {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(target);
            UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEventAbilityGained);
        });
        return true;
    }

    @Deprecated
    public final boolean copyAbility(CardIndex target, DataTable<Integer> dataAbility, ChronoDuration chronoDuration) {
        if (dataAbility.size() != 2) {
            return false;
        }
        return this.copyAbility(target, dataAbility.get(0), dataAbility.get(1), chronoDuration);
    }

    @Deprecated
    public final boolean copyAbility(CardIndex target, int sourceCardId, int sourceAbilityId, ChronoDuration chronoDuration) {
        if (target == null) {
            return false;
        }
        CardIndex source = Game.getCurrentGame().getIndexRegistry().getIndex(sourceCardId);
        CardIndex cardIndexCopy = null;
        Ability abilityCopy = cardIndexCopy.getIndexedInstance().getAbilityList().get(sourceAbilityId);
        if (this.attachAbility(target, abilityCopy, chronoDuration)) {
            abilityCopy.setSourceCardId(cardIndexCopy.getId());
            abilityCopy.setSourceAttachAbility(abilityCopy);
            abilityCopy.setAbilityId(sourceAbilityId);
            return true;
        }
        return false;
    }

    public final Ability copyAbility(Ability ability) {
        if (ability == null || ability.getSourceAttachAbility() != null || ability.getSourceStockAbility() != null) {
            return null;
        }
        CardIndex cardIndexCopy = Game.getCurrentGame().getIndexRegistry().createFreeIndex(this.getOwner(), GameConst.CardLocation.REVEALED);
        cardIndexCopy.setImageSet(cardIndexCopy.getId(), ability.getSourceCardIndex().getImageSet());
        cardIndexCopy.setSourceCard3D(this.getCardIndex().getSourceCard3D());
        Ability abilityCopy = cardIndexCopy.getIndexedInstance().getAbilityList().get(ability.getAbilityId());
        abilityCopy.setSourceAttachAbility(ability);
        abilityCopy.getFlags().addValue(131072);
        return this.attachAbility(this.getCardIndex(), ability, abilityCopy, ChronoDuration.permanent()) ? abilityCopy : null;
    }

    public final void attachPlayerAbility(Game.GamePlayerRole rolePlayer, StockAbility ability, ChronoDuration chronoDuration) {
        this.attachPlayerAbility(rolePlayer, ability.getAbility(), new ChronoRecordScheduler.ChronoRecord(chronoDuration));
    }

    public final void attachPlayerAbility(Game.GamePlayerRole rolePlayer, Ability ability, ChronoDuration chronoDuration) {
        this.attachPlayerAbility(rolePlayer, ability, new ChronoRecordScheduler.ChronoRecord(chronoDuration));
    }

    public final void attachPlayerAbility(Game.GamePlayerRole rolePlayer, StockAbility ability, ChronoRecordScheduler.ChronoRecord record) {
        this.attachPlayerAbility(rolePlayer, ability.getAbility(), record);
    }

    public final void attachPlayerAbility(Game.GamePlayerRole rolePlayer, Ability ability, ChronoRecordScheduler.ChronoRecord record) {
        this.attachPlayerAbility(rolePlayer, CardAbilities.getAbility(), ability, record);
    }

    @Deprecated
    public final void attachPlayerAbility(Game.GamePlayerRole rolePlayer, Ability sourceAttachAbility, Ability ability, ChronoDuration chronoDuration) {
        this.attachPlayerAbility(rolePlayer, sourceAttachAbility, ability, new ChronoRecordScheduler.ChronoRecord(chronoDuration));
    }

    public final void attachPlayerAbility(Game.GamePlayerRole rolePlayer, Ability sourceAttachAbility, Ability ability, ChronoRecordScheduler.ChronoRecord record) {
        ConstantAbilityShared cont;
        StockAbility stockAbility = ability.getSourceStockAbility();
        if (!(stockAbility instanceof StockPlayerAbilityToken)) {
            ability.setSourceCardId(sourceAttachAbility.getSourceCardId());
        } else {
            StockPlayerAbilityToken stockPlayerAbilityToken = (StockPlayerAbilityToken)stockAbility;
            CardIndex cardIndexToken = Game.getCurrentGame().getIndexRegistry().createFreeIndex(stockPlayerAbilityToken.getHintFlagsOwner() == 1 ? this.getOwner() : this.getOpponent(), GameConst.CardLocation.EXCLUDED);
            cardIndexToken.setTokenImageSet(cardIndexToken.getId(), stockPlayerAbilityToken.getTokenImageSet());
            ability.setSourceCardId(cardIndexToken.getId());
        }
        ability.setSourceAttachAbility(sourceAttachAbility);
        ability.setSourceAttachPlayerRole(rolePlayer);
        ability.getFlags().addValue(12);
        if (ability instanceof ActionAbility) {
            ability.getFlags().removeValue(1);
        }
        ability.onAbilityInit();
        Game.getCurrentGame().getPlayerGameData(rolePlayer).addPlayerAbility(ability);
        if (ability.getSourceAttachAbility().getTotalNestedAbilityDescriptions() > 0 && (ability.getSourceAttachPlayerRole() == null || ability instanceof ActionAbility || ability instanceof AutoAbility || ability instanceof ConstantAbilityShared && !((cont = (ConstantAbilityShared)ability).getListModifiers()[0] instanceof AbilityGainModifier)) && !ability.getSourceAttachAbility().getNestedAbilityDescription(0).contains("~#") || ability.getSourceStockAbility() != null && !ability.getSourceStockAbility().getAbilityDescription().isEmpty()) {
            UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getLRIGZone().getZoneAttachedAbilitiesIndicator().addAbility(ability);
            if (record.getChronoDuration() != ChronoDuration.permanent()) {
                record.setOnChronoRecordExpired(() -> FX.run(() -> UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getLRIGZone().getZoneAttachedAbilitiesIndicator().removeAbility(ability)));
            } else if (!(ability instanceof ConstantAbilityShared)) {
                ability.setOnAbilityEnabled(cardIndex -> UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getLRIGZone().getZoneAttachedAbilitiesIndicator().addAbility(ability));
                ability.setOnAbilityDisabled(cardIndex -> UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getLRIGZone().getZoneAttachedAbilitiesIndicator().removeAbility(ability));
            }
        }
        if (ability instanceof ConstantAbility) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilitiesUnsafe();
        } else {
            ability.callOnAbilityEnabledHandler(UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getLRIGZone().getTopCard().getCardIndex());
        }
        if (record.getChronoDuration() != ChronoDuration.permanent()) {
            record.setOnChronoRecordExpired(() -> CardAbilities.removePlayerAbility(ability));
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        }
    }

    public static void removePlayerAbility(Ability ability) {
        if (ability.getSourceAttachPlayerRole() == null) {
            return;
        }
        Game.getCurrentGame().getPlayerGameData(ability.getSourceAttachPlayerRole()).removePlayerAbility(ability);
    }

    public static List<Ability> getPlayerAbilities(Game.GamePlayerRole rolePlayer) {
        return Game.getCurrentGame().getPlayerGameData(rolePlayer).getPlayerAbilities();
    }

    protected void addAbility(Ability ability) {
        if (ability == null) {
            return;
        }
        ability.setSourceCardId(this.cardId);
        ability.setAbilityId(this.totalAbilities++);
        this.listAbilities.add(ability);
    }

    public void removeAbility(Ability ability) {
        if (this.isAbilityNotRemovable(ability)) {
            return;
        }
        ability.disable();
        this.listAbilities.remove(ability);
        this.cacheRemovedAbilities.add(ability);
        --this.totalAbilities;
    }

    public void removeAbilitySafe(Ability ability) {
        if (this.isAbilityNotRemovable(ability)) {
            return;
        }
        ability.disable();
        if (this.listAbilitiesToRemove == null) {
            this.listAbilitiesToRemove = new ArrayList<Ability>();
        }
        this.listAbilitiesToRemove.add(ability);
    }

    private boolean isAbilityNotRemovable(Ability ability) {
        return ability == null || ability.getSourceAttachAbility() == null || ability.getSourceStockAbility() != null && !this.listAbilities.contains(ability.getSourceStockAbility().getAbility()) || !this.listAbilities.contains(ability);
    }

    public void clearAbilitySafe(Ability ability) {
        if (this.listAbilitiesToRemove == null || !this.listAbilitiesToRemove.contains(ability)) {
            return;
        }
        this.listAbilities.remove(ability);
        this.cacheRemovedAbilities.add(ability);
        --this.totalAbilities;
        this.listAbilitiesToRemove.remove(ability);
    }

    public void clearAllAbilitiesSafe() {
        if (this.listAbilitiesToRemove == null || this.listAbilitiesToRemove.isEmpty()) {
            return;
        }
        this.listAbilities.removeAll(this.listAbilitiesToRemove);
        this.cacheRemovedAbilities.addAll(this.listAbilitiesToRemove);
        this.totalAbilities -= this.listAbilitiesToRemove.size();
        this.listAbilitiesToRemove.clear();
    }

    public final List<Ability> getAbilityList() {
        return this.listAbilities;
    }

    public final int getTotalBaseAbilities() {
        return this.totalBaseAbilities;
    }

    @Deprecated
    public final List<String> getAbilityDescriptionsList() {
        return this.listAbilityDescriptions;
    }

    public final void setStartingExtraDescription(String description) {
        this.extraDescription = description;
    }

    public final String getStartingExtraDescription() {
        return this.extraDescription;
    }

    public final void initCardAbilities() {
        if (this.useCondFilter != null) {
            this.useCondFilter.setSourceCardIndex(this.getCardIndex());
        }
        for (AbilityCostList costList : this.getCardIndex().getIndexedInstance().getCost()) {
            costList.setSourceCardIndex(this.getCardIndex());
        }
        DescriptionParser.assignCardAbilityDescriptions(this.getCardIndex());
        this.totalBaseAbilities = this.listAbilities.size();
        for (Ability ability : this.listAbilities) {
            ability.onAbilityInit();
        }
    }

    @Override
    public void dispose() {
        this.cardIndex = null;
        this.listAbilities.forEach(Ability::dispose);
        this.listAbilities.clear();
        if (this.listAbilitiesToRemove != null) {
            this.listAbilitiesToRemove.forEach(Ability::dispose);
            this.listAbilitiesToRemove = null;
        }
        this.cacheRemovedAbilities.forEach(Ability::dispose);
        this.cacheRemovedAbilities.clear();
        this.listAbilityDescriptions.clear();
        this.ruleCheckRegistry.dispose();
        this.useCond = null;
        this.useCondFilter = null;
    }

    public static void setEffectCallbackAction(ActionEffectActivateResolve action) {
        callbackAction = action;
        Log.printMessage(">>>CB: SET!!! " + String.valueOf(callbackAction));
    }

    public static ActionEffectActivateResolve getEffectCallbackAction() {
        return callbackAction;
    }

    private <T> void addAction(GameAction<T> action) {
        action.setSourceAbility(CardAbilities.getAbility());
        action.setCallbackAction(callbackAction);
        Game.getCurrentGame().getActionQueue().addAction(action);
        if (action.isBlocked() && action.getSourceOverrideResult() != null) {
            action.getSourceOverrideResult().execThreadedActionOverride(callbackAction);
        }
        GameField.highlightPlayerField(null);
    }

    private boolean addSingleCardAction(CardIndex cardIndex, Function<CardIndex, GameAction<?>> handlerAction) {
        if (cardIndex == null || handlerAction == null) {
            return false;
        }
        GameAction<?> action = handlerAction.apply(cardIndex);
        this.addAction(action);
        return action.isSuccessful();
    }

    private <T> int addMultiCardAction(DataTable<T> data, Function<T, GameAction<T>> handlerAction) {
        if (data == null || data.isEmpty() || data.get() == null || handlerAction == null) {
            return 0;
        }
        GameAction<T> prevAction = null;
        for (int i = 0; i < data.size(); ++i) {
            GameAction<T> action = handlerAction.apply(data.get(i));
            action.setAtOnce(prevAction, i, data.size());
            prevAction = action;
            this.addAction(action);
        }
        return prevAction != null ? prevAction.getNumAtOnce() : 0;
    }

    public final boolean playerChoiceActivate() {
        return this.playerChoiceActivate(this.getOwner());
    }

    public final boolean playerChoiceActivate(Game.GamePlayerRole rolePlayer) {
        return this.playerChoiceActivate(rolePlayer, CardAbilities.getAbility());
    }

    public final boolean playerChoiceActivate(Game.GamePlayerRole rolePlayer, Ability ability) {
        GameField.highlightPlayerField(rolePlayer);
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualChoice(ability) : new ActionPlayerChoiceInteger();
        this.addAction(action);
        return (Integer)action.getDataTable().get() == 1;
    }

    public final int playerChoiceAction(AbilityConst.ActionHint ... hintActions) {
        return this.playerChoiceAction(this.getOwner(), hintActions);
    }

    public final int playerChoiceAction(Game.GamePlayerRole rolePlayer, AbilityConst.ActionHint ... hintActions) {
        return this.playerChoiceOption(rolePlayer, (String[])Arrays.stream(hintActions).map(AbilityConst.ActionHint::getActionDescription).toArray(String[]::new));
    }

    public final CardConst.CardColor playerChoiceColor(CardConst.CardColor ... colors) {
        return this.playerChoiceColor(this.getOwner(), colors);
    }

    public final CardConst.CardColor playerChoiceColor() {
        return this.playerChoiceColor(this.getOwner(), CardConst.CardColor.UTIL_COLORS);
    }

    public final CardConst.CardColor playerChoiceColor(Game.GamePlayerRole rolePlayer, CardConst.CardColor ... colors) {
        return colors[this.playerChoiceOption(rolePlayer, (String[])Arrays.stream(colors).map(CardConst.CardColor::getLabel).toArray(String[]::new)) - 1];
    }

    public final CardConst.CardSIGNIClass playerChoiceSIGNIClass() {
        return this.playerChoiceSIGNIClass(CardConst.CardSIGNIClass.values());
    }

    public final CardConst.CardSIGNIClass playerChoiceSIGNIClass(CardConst.CardSIGNIClass ... cardSIGNIClasses) {
        return cardSIGNIClasses[this.playerChoiceOption(this.getOwner(), (String[])Arrays.stream(cardSIGNIClasses).map(UtilCardDataFormatter::formatSIGNIClassMaskedSingle).toArray(String[]::new)) - 1];
    }

    public final int playerChoiceNumber(int ... numbers) {
        return this.playerChoiceNumber(this.getOwner(), numbers);
    }

    public final int playerChoiceNumber(Game.GamePlayerRole rolePlayer, int ... numbers) {
        return this.playerChoiceOption(rolePlayer, (String[])Arrays.stream(numbers).mapToObj(Integer::toString).toArray(String[]::new));
    }

    private int playerChoiceOption(Game.GamePlayerRole rolePlayer, String ... options) {
        GameField.highlightPlayerField(rolePlayer);
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualChoice(CardAbilities.getAbility(), options) : new ActionPlayerChoiceInteger();
        this.addAction(action);
        Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenOption(CardAbilities.getAbility(), options[(Integer)action.getDataTable().get() - 1]));
        return (Integer)action.getDataTable().get();
    }

    private <T, V, M extends ModifiableVariable<T, V, M>> int playerChoiceOptionByRef(String titleRefType, ModifiableVariable<T, V, M> sourceMod, Ability[] listSourceAbilityRef, String ... options) {
        GameField.highlightPlayerField(this.getOwner());
        GameAction action = PlayerControl.isChoosingPlayer(this.getOwner()) ? new ActionManualChoiceByRef(titleRefType, sourceMod.getSourceCardIndex() == null ? this.getCardIndex() : sourceMod.getSourceCardIndex(), CardAbilities.getAbility(), listSourceAbilityRef, options) : new ActionPlayerChoiceInteger();
        this.addAction(action);
        Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenOption(CardAbilities.getAbility(), options[(Integer)action.getDataTable().get() - 1]));
        return (Integer)action.getDataTable().get();
    }

    public void playerChoiceFessoneMagic() {
        DataTable<String> data = this.playerChoiceCatalog(2, filter -> filter.filterSets("WXDi-P14-TK"));
        for (int i = 0; i < data.size(); ++i) {
            this.returnToDeck(this.craft(data.get(i)), Deck.DeckPosition.TOP);
        }
    }

    public void playerChoiceBond() {
        GameAction action = PlayerControl.isChoosingPlayer(this.getOwner()) ? new ActionManualChoiceCatalogBond() : new ActionPlayerChoiceString();
        this.addAction(action);
        this.gainBond((String)action.getDataTable().get());
    }

    public Card playerChoiceCatalog(SearchFilter.LockedFiltersAction handlerFilters) {
        String imageSet = this.playerChoiceCatalog(1, handlerFilters).get();
        return CardLoader.getCardByImageSet(imageSet);
    }

    public DataTable<String> playerChoiceCatalog(int minPicks, SearchFilter.LockedFiltersAction handlerFilters) {
        GameAction action = PlayerControl.isChoosingPlayer(this.getOwner()) ? new ActionManualChoiceCatalog(minPicks, handlerFilters) : new ActionPlayerChoiceString();
        this.addAction(action);
        if (action.isSuccessful()) {
            Platform.runLater(() -> {
                for (int i = 0; i < action.getDataTable().size(); ++i) {
                    Card cardObject = CardLoader.getCardByImageSet((String)action.getDataTable().get(i));
                    if (cardObject == null) continue;
                    UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenOption(CardAbilities.getAbility(), cardObject.getName());
                }
            });
        }
        return action.getDataTable();
    }

    public final int playerChoiceRemoveTokens(Class<? extends StockPlayerAbilityToken> classToken, Game.GamePlayerRole roleOwner) {
        PlayerGameData playerData = Game.getCurrentGame().getPlayerGameData(roleOwner);
        List<Ability> listTokenAbilities = playerData.getPlayerAbilities().stream().filter(ability -> {
            StockPlayerAbilityToken token;
            StockAbility patt0$temp = ability.getSourceStockAbility();
            return patt0$temp instanceof StockPlayerAbilityToken && (token = (StockPlayerAbilityToken)patt0$temp).getClass().equals(classToken);
        }).toList();
        if (listTokenAbilities.isEmpty()) {
            return 0;
        }
        int count = this.playerChoiceOption(this.getOwner(), (String[])IntStream.rangeClosed(0, listTokenAbilities.size()).mapToObj(String::valueOf).toArray(String[]::new)) - 1;
        for (int i = 0; i < count; ++i) {
            playerData.removePlayerAbility(listTokenAbilities.get(i));
        }
        return count;
    }

    public final int playerChoiceMode() {
        return this.playerChoiceMode(1, 1, CardAbilities.getAbility());
    }

    public final int playerChoiceMode(Game.GamePlayerRole rolePlayer) {
        return this.playerChoiceMode(rolePlayer, 1, 1, CardAbilities.getAbility());
    }

    public final int playerChoiceMode(Game.GamePlayerRole rolePlayer, int bitsDisabled) {
        return this.playerChoiceMode(rolePlayer, 1, 1, CardAbilities.getAbility(), bitsDisabled);
    }

    public final int playerChoiceMode(int maxPicks) {
        return this.playerChoiceMode(1, maxPicks, CardAbilities.getAbility());
    }

    public final int playerChoiceMode(int minPicks, int maxPicks) {
        return this.playerChoiceMode(minPicks, maxPicks, CardAbilities.getAbility());
    }

    public final int playerChoiceMode(Ability sourceAbility) {
        return this.playerChoiceMode(1, 1, sourceAbility);
    }

    public final int playerChoiceMode(int minPicks, int maxPicks, Ability sourceAbility) {
        return this.playerChoiceMode(this.getOwner(), minPicks, maxPicks, sourceAbility);
    }

    public final int playerChoiceMode(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, Ability sourceAbility) {
        return this.playerChoiceMode(rolePlayer, minPicks, maxPicks, sourceAbility, 0);
    }

    public final int playerChoiceMode(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, Ability sourceAbility, int bitsDisabled) {
        GameField.highlightPlayerField(rolePlayer);
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualChoiceMode(minPicks, maxPicks, sourceAbility, bitsDisabled, null) : new ActionPlayerChoiceInteger();
        this.addAction(action);
        Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenModes(sourceAbility, (Integer)action.getDataTable().get(), null));
        return (Integer)action.getDataTable().get();
    }

    @Deprecated
    public final DataTable<Integer> playerChoiceAbility(ArrayList<Ability> listAbilities) {
        GameField.highlightPlayerField(this.getOwner());
        listAbilities.removeIf(ability -> ability.getSourceAttachAbility() != null);
        GameAction action = PlayerControl.isChoosingPlayer(this.getOwner()) ? new ActionManualChoiceAbility(listAbilities, false) : new ActionPlayerChoiceInteger();
        this.addAction(action);
        return action.getDataTable();
    }

    public final DataTable<CardIndex> playerChoiceHand() {
        return this.playerChoiceHand(1);
    }

    public final DataTable<CardIndex> playerChoiceHand(int minPicks) {
        return this.playerChoiceHand(minPicks, minPicks);
    }

    public final DataTable<CardIndex> playerChoiceHand(int minPicks, int maxPicks) {
        return this.playerChoiceHand(this.getOwner(), minPicks, maxPicks);
    }

    public final DataTable<CardIndex> playerChoiceHand(Game.GamePlayerRole rolePlayer, int minPicks) {
        return this.playerChoiceHand(rolePlayer, minPicks, minPicks);
    }

    public final DataTable<CardIndex> playerChoiceHand(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks) {
        GameField.highlightPlayerField(rolePlayer);
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualChoiceHand(minPicks, maxPicks) : new ActionPlayerChoiceCard();
        this.addAction(action);
        return action.getDataTable();
    }

    public final void distributePower(DataTable<CardIndex> data, int total) {
        DataTable<Integer> chosenValues;
        if (data == null || data.isEmpty() || data.get() == null || total == 0) {
            return;
        }
        if (data.size() != 1) {
            GameAction action = PlayerControl.isChoosingPlayer(this.getOwner()) ? new ActionManualChoiceDistribute(data, total) : new ActionPlayerChoiceInteger();
            this.addAction(action);
            chosenValues = action.getDataTable();
        } else {
            chosenValues = new DataTable<Integer>(total);
        }
        for (int i = 0; i < data.size(); ++i) {
            CardIndex cardIndex = data.get(i);
            int power = chosenValues.get(i);
            Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenOption(CardAbilities.getAbility(), String.valueOf(power)));
            this.gainPower(cardIndex, (double)power, ChronoDuration.turnEnd());
        }
    }

    public final DataTable<CardIndex> playerTargetCard(TargetFilter filter) {
        return this.playerTargetCard(1, 1, AbilityConst.ChoiceLogic.DEFAULT, filter);
    }

    public final DataTable<CardIndex> playerTargetCard(TargetFilter filter, boolean isTargeted) {
        return this.playerTargetCard(this.getOwner(), 1, 1, AbilityConst.ChoiceLogic.DEFAULT, filter, null, isTargeted);
    }

    public final DataTable<CardIndex> playerTargetCard(int minPicks, TargetFilter filter) {
        return this.playerTargetCard(this.getOwner(), minPicks, minPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final DataTable<CardIndex> playerTargetCard(int minPicks, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        return this.playerTargetCard(minPicks, minPicks, filter, condition);
    }

    public final DataTable<CardIndex> playerTargetCard(int minPicks, int maxPicks, TargetFilter filter) {
        return this.playerTargetCard(this.getOwner(), minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final DataTable<CardIndex> playerTargetCard(int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter) {
        return this.playerTargetCard(this.getOwner(), minPicks, maxPicks, choiceLogic, filter, null);
    }

    public final DataTable<CardIndex> playerTargetCard(int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        return this.playerTargetCard(this.getOwner(), minPicks, maxPicks, choiceLogic, filter, condition);
    }

    public final DataTable<CardIndex> playerTargetCard(int minPicks, int maxPicks, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        return this.playerTargetCard(this.getOwner(), minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, condition);
    }

    public final DataTable<CardIndex> playerTargetCard(Game.GamePlayerRole rolePlayer, TargetFilter filter) {
        return this.playerTargetCard(rolePlayer, 1, 1, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final DataTable<CardIndex> playerTargetCard(Game.GamePlayerRole rolePlayer, int minPicks, TargetFilter filter) {
        return this.playerTargetCard(rolePlayer, minPicks, minPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final DataTable<CardIndex> playerTargetCard(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, TargetFilter filter) {
        return this.playerTargetCard(rolePlayer, minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final DataTable<CardIndex> playerTargetCard(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter) {
        return this.playerTargetCard(rolePlayer, minPicks, maxPicks, choiceLogic, filter, null);
    }

    public final DataTable<CardIndex> playerTargetCard(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        return this.playerTargetCard(rolePlayer, minPicks, maxPicks, choiceLogic, filter, condition, true);
    }

    public final DataTable<CardIndex> playerTargetCard(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter, ConditionHandler<CardIndex> condition, boolean isTargeted) {
        GameAction action;
        filter.setAsTargeted(isTargeted);
        filter.setSourceAbility(CardAbilities.getAbility());
        filter.setTargetRole(rolePlayer);
        GameField.highlightPlayerField(rolePlayer);
        if (PlayerControl.isChoosingPlayer(rolePlayer)) {
            if (!(filter.getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH) || filter.getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH_LRIG) || filter.getHintLocationsData().contains((Object)GameConst.CardLocation.DECK_LRIG))) {
                action = new ActionManualTargetCard(minPicks, maxPicks, filter, condition, choiceLogic);
            } else {
                GameConst.CardLocation location;
                if (filter.getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
                    location = GameConst.CardLocation.TRASH;
                } else if (filter.getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH_LRIG)) {
                    location = GameConst.CardLocation.TRASH_LRIG;
                } else if (filter.getHintLocationsData().contains((Object)GameConst.CardLocation.DECK_LRIG)) {
                    location = GameConst.CardLocation.DECK_LRIG;
                } else {
                    throw new IllegalArgumentException();
                }
                action = new ActionManualSearchDeck(minPicks, maxPicks, filter, condition, rolePlayer, location);
            }
        } else {
            action = new ActionPlayerChoiceCard(filter);
        }
        this.addAction(action);
        return action.getDataTable();
    }

    public final DataTable<FieldZone> playerTargetZone(TargetFilter filter) {
        return this.playerTargetZone(1, 1, filter, null);
    }

    public final DataTable<FieldZone> playerTargetZone(int minPicks, TargetFilter filter) {
        return this.playerTargetZone(minPicks, minPicks, filter, null);
    }

    public final DataTable<FieldZone> playerTargetZone(int minPicks, TargetFilter filter, ConditionHandler<FieldZone> condition) {
        return this.playerTargetZone(minPicks, minPicks, filter, condition);
    }

    public final DataTable<FieldZone> playerTargetZone(int minPicks, int maxPicks, TargetFilter filter) {
        return this.playerTargetZone(minPicks, maxPicks, filter, null);
    }

    public final DataTable<FieldZone> playerTargetZone(int minPicks, int maxPicks, TargetFilter filter, ConditionHandler<FieldZone> condition) {
        return this.playerTargetZone(this.getOwner(), minPicks, maxPicks, filter, condition);
    }

    public final DataTable<FieldZone> playerTargetZone(Game.GamePlayerRole rolePlayer, TargetFilter filter) {
        return this.playerTargetZone(rolePlayer, 1, 1, filter, null);
    }

    public final DataTable<FieldZone> playerTargetZone(Game.GamePlayerRole rolePlayer, int minPicks, TargetFilter filter) {
        return this.playerTargetZone(rolePlayer, minPicks, minPicks, filter, null);
    }

    public final DataTable<FieldZone> playerTargetZone(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, TargetFilter filter) {
        return this.playerTargetZone(rolePlayer, minPicks, maxPicks, filter, null);
    }

    public final DataTable<FieldZone> playerTargetZone(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, TargetFilter filter, ConditionHandler<FieldZone> condition) {
        if (filter.getHintTargetType() == TargetFilter.TargetHint.GENERIC) {
            filter.setTargetHint(TargetFilter.TargetHint.ZONE);
        }
        filter.setSourceAbility(CardAbilities.getAbility());
        filter.setTargetRole(rolePlayer);
        GameField.highlightPlayerField(rolePlayer);
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualTargetZone(minPicks, maxPicks, filter, condition) : new ActionPlayerChoiceZone(filter);
        this.addAction(action);
        return action.getDataTable();
    }

    public final boolean pay(AbilityCost ... costs) {
        return this.pay(this.getOwner(), costs);
    }

    public final boolean pay(Game.GamePlayerRole rolePlayer, AbilityCost ... costs) {
        return this.pay(rolePlayer, false, costs);
    }

    public final boolean payMandatory(Game.GamePlayerRole rolePlayer, AbilityCost ... costs) {
        return this.pay(rolePlayer, true, costs);
    }

    private boolean pay(Game.GamePlayerRole rolePlayer, boolean isMandatory, AbilityCost ... costs) {
        AbilityCostList[] costLists = new AbilityCostList[costs.length];
        for (int i = 0; i < costs.length; ++i) {
            costLists[i] = new AbilityCostList(costs[i]);
        }
        return this.pay(rolePlayer, isMandatory, costLists);
    }

    public final boolean pay(AbilityCostList ... costLists) {
        return this.pay(this.getOwner(), costLists);
    }

    public final boolean pay(Game.GamePlayerRole rolePlayer, AbilityCostList ... costLists) {
        return this.pay(rolePlayer, false, costLists);
    }

    public final boolean payMandatory(Game.GamePlayerRole rolePlayer, AbilityCostList ... costLists) {
        return this.pay(rolePlayer, true, costLists);
    }

    private boolean pay(Game.GamePlayerRole rolePlayer, boolean isMandatory, AbilityCostList ... costLists) {
        if (costLists.length == 0) {
            return false;
        }
        GameField.highlightPlayerField(rolePlayer);
        for (AbilityCostList costList : costLists) {
            costList.treatAsEffect();
            costList.setSourceAbility(CardAbilities.getAbility());
            costList.setPayerRole(rolePlayer);
        }
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualChoiceCost(Arrays.asList(costLists), isMandatory).forceDisableSkip(isMandatory) : new ActionPlayerChoiceInteger();
        this.addAction(action);
        GameField.highlightPlayerField(rolePlayer);
        if (ActionPayCost.isCostActionSuccessful(action)) {
            AbilityCostList costList = costLists[(Integer)action.getDataTable().get()];
            this.addAction(new ActionPayCost(costList));
            return costList.isPaid();
        }
        return false;
    }

    public final boolean payAll(AbilityCost ... costs) {
        return this.payAll(this.getOwner(), costs);
    }

    public final boolean payAll(Game.GamePlayerRole rolePlayer, AbilityCost ... costs) {
        GameField.highlightPlayerField(rolePlayer);
        AbilityCostList costList = new AbilityCostList(costs);
        costList.treatAsEffect();
        costList.setForcedMandatoryState(true);
        costList.setSourceAbility(CardAbilities.getAbility());
        costList.setPayerRole(rolePlayer);
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualChoiceCost(List.of(costList), true) : new ActionPlayerChoiceInteger();
        this.addAction(action);
        GameField.highlightPlayerField(rolePlayer);
        if (ActionPayCost.isCostActionSuccessful(action)) {
            this.addAction(new ActionPayCost(costList));
            return costList.isPaid();
        }
        return false;
    }

    public final boolean payEner(String costString) {
        return this.payEner(this.getOwner(), costString);
    }

    public final boolean payEner(Game.GamePlayerRole rolePlayer, String costString) {
        GameField.highlightPlayerField(rolePlayer);
        AbilityCostList costList = new AbilityCostList(new EnerCost(costString));
        costList.treatAsEffect();
        costList.setSourceAbility(CardAbilities.getAbility());
        costList.setPayerRole(rolePlayer);
        if (costList.canBePaid()) {
            this.addAction(new ActionPayCost(costList));
        }
        return !costList.getPaidCostData().isEmpty();
    }

    public final DataTable<CardIndex> discard(int minPicks) {
        return this.discard(this.getOwner(), minPicks, minPicks, AbilityConst.ChoiceLogic.DEFAULT, null, null);
    }

    public final DataTable<CardIndex> discard(int minPicks, int maxPicks) {
        return this.discard(this.getOwner(), minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT, null, null);
    }

    public final DataTable<CardIndex> discard(int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic) {
        return this.discard(this.getOwner(), minPicks, maxPicks, choiceLogic, null, null);
    }

    public final DataTable<CardIndex> discard(Game.GamePlayerRole rolePlayer, int minPicks) {
        return this.discard(rolePlayer, minPicks, minPicks, AbilityConst.ChoiceLogic.DEFAULT, null, null);
    }

    public final DataTable<CardIndex> discard(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks) {
        return this.discard(rolePlayer, minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT, null, null);
    }

    public final DataTable<CardIndex> discard(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic) {
        return this.discard(rolePlayer, minPicks, maxPicks, choiceLogic, null, null);
    }

    public final DataTable<CardIndex> discard(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, TargetFilter filter) {
        return this.discard(rolePlayer, minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final DataTable<CardIndex> discard(int minPicks, TargetFilter filter) {
        return this.discard(this.getOwner(), minPicks, minPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final DataTable<CardIndex> discard(int minPicks, int maxPicks, TargetFilter filter) {
        return this.discard(this.getOwner(), minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final DataTable<CardIndex> discard(int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter) {
        return this.discard(this.getOwner(), minPicks, maxPicks, choiceLogic, filter, null);
    }

    public final DataTable<CardIndex> discard(int minPicks, int maxPicks, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        return this.discard(this.getOwner(), minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, condition);
    }

    public final DataTable<CardIndex> discard(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        if (filter != null) {
            filter.setSourceAbility(CardAbilities.getAbility());
            filter = filter.fromHand();
            filter.setTargetHint(TargetFilter.TargetHint.DISCARD);
        }
        GameField.highlightPlayerField(rolePlayer);
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualDiscard(minPicks, maxPicks, choiceLogic, filter, condition) : new ActionDiscard();
        this.addAction(action);
        return action.getDataTable();
    }

    public final DataTable<CardIndex> discard(CardIndex cardIndex) {
        if (cardIndex == null) {
            return new DataTable<CardIndex>(null);
        }
        ActionDiscard action = new ActionDiscard(cardIndex);
        this.addAction(action);
        return action.getDataTable();
    }

    public final DataTable<CardIndex> discard(DataTable<CardIndex> data) {
        if (data == null || data.isEmpty() || data.get() == null) {
            return new DataTable<CardIndex>(null);
        }
        ActionDiscard action = new ActionDiscard(data);
        this.addAction(action);
        return action.getDataTable();
    }

    public final DataTable<CardIndex> draw(int count) {
        return this.draw(this.getOwner(), count);
    }

    public final DataTable<CardIndex> draw(Game.GamePlayerRole rolePlayer, int count) {
        if (count <= 0) {
            return new DataTable<CardIndex>(null);
        }
        ActionDraw action = new ActionDraw();
        this.addAction(action);
        return action.getDataTable();
    }

    public final boolean banish(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionBanish::new);
    }

    public final int banish(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionBanish::new);
    }

    public final boolean trash(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionTrash::new);
    }

    public final DataTable<CardIndex> trash(GameConst.CardLocation location) {
        return this.trash(this.getOwner(), location);
    }

    public final DataTable<CardIndex> trash(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location) {
        ActionTrash action = new ActionTrash();
        this.addAction(action);
        return action.getDataTable();
    }

    public final int trash(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionTrash::new);
    }

    public final DataTable<CardIndex> trash(GameConst.CardLocation location, int numToTrash) {
        if (numToTrash <= 0 || location == null) {
            return new DataTable<CardIndex>(null);
        }
        int numInZone = FieldData.getZoneByLocation(this.getOwner(), location).getTotalCards();
        if (numToTrash > numInZone) {
            numToTrash = numInZone;
        }
        DataTable<CardIndex> data = new DataTable<CardIndex>();
        ActionTrash prevAction = null;
        for (int i = 0; i < numToTrash; ++i) {
            ActionTrash action = new ActionTrash();
            action.setAtOnce(prevAction, i, numToTrash);
            prevAction = action;
            this.addAction(action);
            if (!action.isSuccessful()) continue;
            data.add((CardIndex)action.getDataTable().get());
        }
        if (data.isEmpty()) {
            data.add(null);
        }
        return data;
    }

    public final boolean exclude(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionExclude::new);
    }

    public final int exclude(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionExclude::new);
    }

    public final boolean attach(CardIndex target, CardIndex source, GameConst.CardUnderType underType) {
        return source != null && underType != null && this.addSingleCardAction(target, cardIndex -> new ActionAttach(target, source, underType));
    }

    public final boolean attach(CardIndex target, GameConst.CardLocation location, GameConst.CardUnderType underType) {
        return this.attach(target, location, underType, 1) != 0;
    }

    public final int attach(CardIndex target, GameConst.CardLocation location, GameConst.CardUnderType underType, int numToAttach) {
        if (target == null || location == null || numToAttach <= 0) {
            return 0;
        }
        int numInZone = FieldData.getZoneByLocation(this.getOwner(), location).getTotalCards();
        if (numToAttach > numInZone) {
            numToAttach = numInZone;
        }
        GameAction prevAction = null;
        for (int i = 0; i < numToAttach; ++i) {
            ActionAttach action = new ActionAttach(target, location, underType);
            action.setAtOnce(prevAction, i, numToAttach);
            prevAction = action;
            this.addAction(action);
        }
        return prevAction.getNumAtOnce();
    }

    public final int attach(CardIndex target, DataTable<CardIndex> dataSources, GameConst.CardUnderType underType) {
        if (target == null || dataSources == null || dataSources.isEmpty() || dataSources.get() == null) {
            return 0;
        }
        GameAction prevAction = null;
        for (int i = 0; i < dataSources.size(); ++i) {
            ActionAttach action = new ActionAttach(target, dataSources.get(i), underType);
            action.setAtOnce(prevAction, i, dataSources.size());
            prevAction = action;
            this.addAction(action);
        }
        return prevAction.getNumAtOnce();
    }

    public final int attach(DataTable<CardIndex> dataTargets, DataTable<CardIndex> dataSources, GameConst.CardUnderType underType) {
        if (dataTargets == null || dataSources == null || dataTargets.isEmpty() || dataSources.isEmpty() || dataTargets.get() == null || dataSources.get() == null) {
            return 0;
        }
        GameAction prevAction = null;
        for (int i = 0; i < dataSources.size(); ++i) {
            ActionAttach action = new ActionAttach(dataTargets.get(Math.min(i, dataTargets.size() - 1)), dataSources.get(i), underType);
            action.setAtOnce(prevAction, i, dataSources.size());
            prevAction = action;
            this.addAction(action);
        }
        return prevAction.getNumAtOnce();
    }

    public final boolean putOnZone(CardIndex cardIndex, GameConst.CardLocation targetLocation, GameConst.CardUnderType underType) {
        return targetLocation != null && underType != null && this.addSingleCardAction(cardIndex, c -> new ActionPutOnZone(cardIndex, targetLocation, underType));
    }

    public final int putOnZone(DataTable<CardIndex> data, GameConst.CardLocation targetLocation, GameConst.CardUnderType underType) {
        return this.addMultiCardAction(data, cardIndex -> new ActionPutOnZone((CardIndex)cardIndex, targetLocation, underType));
    }

    public final boolean attachZoneObject(FieldZone fieldZone, GameConst.CardUnderType underType) {
        FieldStackZone fieldStackZone;
        block5: {
            block4: {
                if (!(fieldZone instanceof FieldStackZone)) break block4;
                fieldStackZone = (FieldStackZone)fieldZone;
                if (underType != null && underType.getUnderCategory() == GameConst.CardUnderCategory.ZONE) break block5;
            }
            return false;
        }
        ActionZoneAttachObject action = new ActionZoneAttachObject(fieldStackZone, underType);
        this.addAction(action);
        if (action.isSuccessful() && underType == GameConst.CardUnderType.ZONE_HASTALYK) {
            Game.GamePlayerRole rolePlayerZone = this.getOpponent();
            PlayerAbilityGainModifier modifier = new PlayerAbilityGainModifier(this.getOwner(), fieldStackZone, () -> new StockPlayerAbilityHastalyk(rolePlayerZone, fieldZone).getAbility());
            ConstantAbility attachedConst = new ConstantAbility(modifier);
            attachedConst.setCondition(() -> {
                if (!fieldStackZone.hasZoneObject(GameConst.CardUnderType.ZONE_HASTALYK)) {
                    Game.getCurrentGame().getPlayerGameData(rolePlayerZone).removePlayerAbility(attachedConst);
                    return AbilityCondition.ConditionState.BAD;
                }
                return AbilityCondition.ConditionState.OK;
            });
            modifier.setSourceAbility(attachedConst);
            this.attachPlayerAbility(rolePlayerZone, (Ability)attachedConst, ChronoDuration.permanent());
        }
        return action.isSuccessful();
    }

    public final boolean removeZoneObject(FieldZone fieldZone, GameConst.CardUnderType underType) {
        if (!(fieldZone instanceof FieldStackZone) || underType == null || underType.getUnderCategory() != GameConst.CardUnderCategory.ZONE) {
            return false;
        }
        ActionZoneRemoveObject action = new ActionZoneRemoveObject((FieldStackZone)fieldZone, underType);
        this.addAction(action);
        return action.isSuccessful();
    }

    public final boolean hasZoneObject(GameConst.CardUnderType underType) {
        FieldStackZone fieldStackZone;
        Zone zone = this.getCardIndex().getZoneByLocation();
        return zone instanceof FieldStackZone && (fieldStackZone = (FieldStackZone)zone).hasZoneObject(underType);
    }

    public final void putAsMagicBox(CardIndex cardIndex) {
        CardIndex cardIndexZone;
        if (cardIndex == null) {
            return;
        }
        FieldZone fieldZone = this.playerTargetZone(new TargetFilter().own().SIGNI()).get();
        if (fieldZone == null) {
            return;
        }
        for (int i = 0; i < fieldZone.getTotalCards() && (cardIndexZone = fieldZone.getZoneCardList().get(i).getCardIndex()).getUnderType().getUnderCategory() == GameConst.CardUnderCategory.ZONE; ++i) {
            if (cardIndexZone.getUnderType() != GameConst.CardUnderType.ZONE_MAGIC_BOX) continue;
            ActionTrash action = new ActionTrash(cardIndexZone);
            action.setCallbackAction(callbackAction);
            Game.getCurrentGame().getActionQueue().addAction(action);
            break;
        }
        ActionPutOnZone action = new ActionPutOnZone(cardIndex, fieldZone.getZoneLocation(), GameConst.CardUnderType.ZONE_MAGIC_BOX);
        action.setOnActionDispatched(() -> AnimationMagicBox.playAnimations(cardIndex, fieldZone, true));
        this.addAction(action);
    }

    public final CardIndex look() {
        return this.look(GameConst.CardLocation.DECK_MAIN);
    }

    public final CardIndex look(GameConst.CardLocation location) {
        return this.look(location, Zone.ZonePosition.TOP);
    }

    public final CardIndex look(GameConst.CardLocation location, Zone.ZonePosition zonePosition) {
        return this.look(this.getOwner(), location, zonePosition);
    }

    public final CardIndex look(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location) {
        return this.look(rolePlayer, location, Zone.ZonePosition.TOP);
    }

    public final CardIndex look(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, Zone.ZonePosition zonePosition) {
        ActionLook action = new ActionLook(zonePosition);
        this.addAction(action);
        return (CardIndex)action.getDataTable().get();
    }

    public final boolean look(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionLook::new);
    }

    public final void look(int numToLook) {
        this.look(numToLook, GameConst.CardLocation.DECK_MAIN);
    }

    public final void look(int numToLook, GameConst.CardLocation location) {
        this.look(numToLook, this.getOwner(), location);
    }

    public final void look(int numToLook, Game.GamePlayerRole rolePlayer) {
        this.look(numToLook, rolePlayer, GameConst.CardLocation.DECK_MAIN);
    }

    public final void look(int numToLook, Game.GamePlayerRole rolePlayer, GameConst.CardLocation location) {
        if (location == null) {
            return;
        }
        int numInZone = FieldData.getZoneByLocation(rolePlayer, location).getTotalCards();
        if (numToLook > numInZone) {
            numToLook = numInZone;
        }
        ActionLook prevAction = null;
        for (int i = 0; i < numToLook; ++i) {
            ActionLook action = new ActionLook(Zone.ZonePosition.TOP);
            action.setAtOnce(prevAction, i, numToLook);
            prevAction = action;
            this.addAction(action);
        }
    }

    public final int look(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionLook::new);
    }

    public final CardIndex reveal() {
        return this.reveal(GameConst.CardLocation.DECK_MAIN);
    }

    public final CardIndex reveal(GameConst.CardLocation location) {
        return this.reveal(location, Zone.ZonePosition.TOP);
    }

    public final CardIndex reveal(GameConst.CardLocation location, Zone.ZonePosition zonePosition) {
        return this.reveal(this.getOwner(), location, zonePosition, false);
    }

    public final CardIndex reveal(Game.GamePlayerRole rolePlayer) {
        return this.reveal(rolePlayer, GameConst.CardLocation.DECK_MAIN);
    }

    public final CardIndex reveal(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location) {
        return this.reveal(rolePlayer, location, false);
    }

    public final CardIndex reveal(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, boolean isSilent) {
        return this.reveal(rolePlayer, location, Zone.ZonePosition.TOP, isSilent);
    }

    public final CardIndex reveal(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, Zone.ZonePosition zonePosition, boolean isSilent) {
        if (FieldData.getZoneByLocation(rolePlayer, location).getZoneCardList().isEmpty()) {
            return null;
        }
        ActionReveal action = new ActionReveal(zonePosition, isSilent);
        this.addAction(action);
        return (CardIndex)action.getDataTable().get();
    }

    public final boolean reveal(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, c -> new ActionReveal(cardIndex, false));
    }

    public final int reveal(int numToReveal) {
        return this.reveal(numToReveal, GameConst.CardLocation.DECK_MAIN);
    }

    public final int reveal(int numToReveal, GameConst.CardLocation location) {
        return this.reveal(numToReveal, this.getOwner(), location);
    }

    public final int reveal(int numToReveal, Game.GamePlayerRole rolePlayer, GameConst.CardLocation location) {
        return this.reveal(numToReveal, rolePlayer, location, false);
    }

    public final int reveal(int numToReveal, Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, boolean isSilent) {
        if (numToReveal <= 0 || location == null) {
            return 0;
        }
        int numInZone = FieldData.getZoneByLocation(rolePlayer, location).getTotalCards();
        if (numToReveal > numInZone) {
            numToReveal = numInZone;
        }
        GameAction prevAction = null;
        for (int i = 0; i < numToReveal; ++i) {
            ActionReveal action = new ActionReveal(Zone.ZonePosition.TOP, isSilent);
            action.setAtOnce(prevAction, i, numToReveal);
            prevAction = action;
            this.addAction(action);
        }
        return prevAction.getNumAtOnce();
    }

    public final int reveal(DataTable<CardIndex> data) {
        return this.reveal(data, false);
    }

    public final int reveal(DataTable<CardIndex> data, boolean isSilent) {
        return this.addMultiCardAction(data, cardIndex -> new ActionReveal((CardIndex)cardIndex, isSilent));
    }

    public final CardIndex revealUntil(Game.GamePlayerRole rolePlayer, CardFunctionalConditionalHandler handlerStopCondition) {
        CardIndex cardIndex;
        DataTable<CardIndex> data = new DataTable<CardIndex>();
        do {
            if ((cardIndex = this.reveal(rolePlayer, GameConst.CardLocation.DECK_MAIN, true)) == null) {
                return null;
            }
            data.add(cardIndex);
        } while (!handlerStopCondition.handle(cardIndex));
        for (int i = 0; i < data.size(); ++i) {
            EventReveal eventReveal = new EventReveal((CardIndex)data.get(i), CardAbilities.getAbility().getSourceCardIndex(), CardAbilities.getAbility());
            eventReveal.setAtOnce(i, data.size());
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventReveal);
        }
        Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        return cardIndex;
    }

    public final boolean addToHand(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionAddToHand::new);
    }

    public final int addToHand(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionAddToHand::new);
    }

    public final boolean addToHand(GameConst.CardLocation location) {
        return this.addToHand(this.getOwner(), location);
    }

    public final boolean addToHand(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location) {
        ActionAddToHand action = new ActionAddToHand();
        this.addAction(action);
        return action.isSuccessful();
    }

    public final boolean returnToDeck(CardIndex cardIndex, Deck.DeckPosition position) {
        return this.addSingleCardAction(cardIndex, c -> new ActionReturnToDeck(cardIndex, position));
    }

    public final int returnToDeck(DataTable<CardIndex> data, Deck.DeckPosition position) {
        return this.addMultiCardAction(data, cardIndex -> new ActionReturnToDeck((CardIndex)cardIndex, position));
    }

    public final void returnToDeckOrdered(GameConst.CardLocation location, Deck.DeckPosition position) {
        if (location != GameConst.CardLocation.LOOKED && location != GameConst.CardLocation.REVEALED) {
            return;
        }
        TargetFilter filter = new TargetFilter(position == Deck.DeckPosition.TOP ? TargetFilter.TargetHint.TOP : TargetFilter.TargetHint.BOTTOM).own();
        filter = location == GameConst.CardLocation.LOOKED ? filter.fromLooked() : filter.fromRevealed();
        Zone zone = FieldData.getZoneByLocation(this.getOwner(), location);
        if (zone == null) {
            return;
        }
        while (zone.getTotalCards() > 0) {
            CardIndex cardIndex = this.playerTargetCard(filter).get();
            this.returnToDeck(cardIndex, position);
        }
    }

    public final boolean putOnField(CardIndex cardIndex, GameConst.CardLocation location) {
        return this.putOnField(cardIndex, location, 0);
    }

    public final boolean putOnField(CardIndex cardIndex, GameConst.CardLocation location, int flagsEnter) {
        ActionPutOnFieldSIGNI action;
        if (cardIndex == null || location == null) {
            return false;
        }
        if (!GameConst.CardLocation.isPublic(cardIndex.getLocation())) {
            this.addAction(new ActionRequestInfoPrivateCard(cardIndex.getSourceCard3D()));
        }
        if (cardIndex.getIndexedInstance().getUseCondition() != GameConst.UseCondition.RISE || !cardIndex.getIndexedInstance().getUseConditionTargetFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
            action = new ActionPutOnFieldSIGNI(cardIndex, location, flagsEnter);
        } else {
            DataTable<CardIndex> dataPicks = this.playerTargetCard(cardIndex.getIndexedInstance().getUseConditionNumPicks(), cardIndex.getIndexedInstance().getUseConditionTargetFilter());
            action = new ActionPutOnFieldSIGNI(cardIndex, dataPicks, location, flagsEnter);
        }
        this.addAction(action);
        return action.isSuccessful();
    }

    public final int putOnField(DataTable<CardIndex> data, DataTable<FieldZone> dataZones) {
        return this.putOnField(data, dataZones, 0);
    }

    public final int putOnField(DataTable<CardIndex> data, DataTable<FieldZone> dataZones, int flagsEnter) {
        if (data == null || dataZones == null || data.isEmpty() || dataZones.isEmpty() || data.size() != dataZones.size() || data.get() == null || dataZones.get() == null) {
            return 0;
        }
        GameAction prevAction = null;
        for (int i = 0; i < data.size(); ++i) {
            ActionPutOnFieldSIGNI action;
            if (!GameConst.CardLocation.isPublic(data.get(i).getLocation())) {
                this.addAction(new ActionRequestInfoPrivateCard(data.get(i).getSourceCard3D()));
            }
            if (data.get(i).getIndexedInstance().getUseCondition() != GameConst.UseCondition.RISE || !data.get(i).getIndexedInstance().getUseConditionTargetFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
                action = new ActionPutOnFieldSIGNI(data.get(i), dataZones.get(i).getZoneLocation(), flagsEnter);
            } else {
                DataTable<CardIndex> dataPicks = this.playerTargetCard(data.get(i).getIndexedInstance().getUseConditionNumPicks(), data.get(i).getIndexedInstance().getUseConditionTargetFilter());
                action = new ActionPutOnFieldSIGNI(data.get(i), dataPicks, dataZones.get(i).getZoneLocation(), flagsEnter);
            }
            action.setAtOnce(prevAction, i, data.size());
            if (i != data.size() - 1) {
                action.treatAsMidEffAction();
            }
            prevAction = action;
            this.addAction(action);
        }
        return prevAction.getNumAtOnce();
    }

    public final boolean putOnField(CardIndex cardIndex) {
        return this.putOnField(cardIndex, 0);
    }

    public final boolean putOnField(CardIndex cardIndex, int flagsEnter) {
        ActionPutOnFieldSIGNI action;
        if (cardIndex == null) {
            return false;
        }
        if (!GameConst.CardLocation.isPublic(cardIndex.getLocation())) {
            this.addAction(new ActionRequestInfoPrivateCard(cardIndex.getSourceCard3D()));
        }
        if (cardIndex.getIndexedInstance().getUseCondition() != GameConst.UseCondition.RISE || cardIndex.getIndexedInstance().getUseConditionTargetFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
            GameConst.CardLocation location;
            FieldZone fieldZone = this.playerTargetZone(cardIndex.getCurrentOwnerSafe(), new TargetFilter(TargetFilter.TargetHint.FIELD).own().SIGNI().playable(cardIndex)).get();
            GameConst.CardLocation cardLocation = location = fieldZone != null ? fieldZone.getZoneLocation() : null;
            if (cardIndex.getIndexedInstance().getUseCondition() != GameConst.UseCondition.RISE) {
                action = new ActionPutOnFieldSIGNI(cardIndex, location, flagsEnter);
            } else {
                DataTable<CardIndex> dataPicks = this.playerTargetCard(cardIndex.getIndexedInstance().getUseConditionNumPicks(), cardIndex.getIndexedInstance().getUseConditionTargetFilter());
                action = new ActionPutOnFieldSIGNI(cardIndex, dataPicks, location, flagsEnter);
            }
        } else {
            DataTable<CardIndex> dataPicks = this.playerTargetCard(cardIndex.getIndexedInstance().getUseConditionNumPicks(), cardIndex.getIndexedInstance().getUseConditionTargetFilter());
            action = new ActionPutOnFieldSIGNI(cardIndex, dataPicks, flagsEnter);
        }
        this.addAction(action);
        return action.isSuccessful();
    }

    public final int putOnField(DataTable<CardIndex> data) {
        return this.putOnField(data, 0);
    }

    public final int putOnField(DataTable<CardIndex> data, int flagsEnter) {
        if (data == null || data.isEmpty() || data.get() == null) {
            return 0;
        }
        GameAction prevAction = null;
        for (int i = 0; i < data.size(); ++i) {
            ActionPutOnFieldSIGNI action;
            if (!GameConst.CardLocation.isPublic(data.get(i).getLocation())) {
                this.addAction(new ActionRequestInfoPrivateCard(data.get(i).getSourceCard3D()));
            }
            if (data.get(i).getIndexedInstance().getUseCondition() != GameConst.UseCondition.RISE || data.get(i).getIndexedInstance().getUseConditionTargetFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
                GameConst.CardLocation location;
                FieldZone fieldZone = this.playerTargetZone(data.get(i).getCurrentOwnerSafe(), new TargetFilter(TargetFilter.TargetHint.FIELD).own().SIGNI().playable(data.get(i))).get();
                GameConst.CardLocation cardLocation = location = fieldZone != null ? fieldZone.getZoneLocation() : null;
                if (this.getCardIndex().getIndexedInstance().getUseCondition() != GameConst.UseCondition.RISE) {
                    action = new ActionPutOnFieldSIGNI(data.get(i), location, flagsEnter);
                } else {
                    DataTable<CardIndex> dataPicks = this.playerTargetCard(data.get(i).getIndexedInstance().getUseConditionNumPicks(), data.get(i).getIndexedInstance().getUseConditionTargetFilter());
                    action = new ActionPutOnFieldSIGNI(data.get(i), dataPicks, location, flagsEnter);
                }
            } else {
                DataTable<CardIndex> dataPicks = this.playerTargetCard(data.get(i).getIndexedInstance().getUseConditionNumPicks(), data.get(i).getIndexedInstance().getUseConditionTargetFilter());
                action = new ActionPutOnFieldSIGNI(data.get(i), dataPicks, flagsEnter);
            }
            action.setAtOnce(prevAction, i, data.size());
            if (i != data.size() - 1) {
                action.treatAsMidEffAction();
            }
            prevAction = action;
            this.addAction(action);
        }
        return prevAction != null ? prevAction.getNumAtOnce() : 0;
    }

    public final boolean moveToZone(CardIndex cardIndex, GameConst.CardLocation location) {
        return this.moveToZone(cardIndex, location, false);
    }

    private boolean moveToZone(CardIndex cardIndex, GameConst.CardLocation location, boolean isSilent) {
        return cardIndex.getLocation() != location && this.addSingleCardAction(cardIndex, c -> new ActionMoveToSIGNIZone(cardIndex, location, isSilent));
    }

    public final boolean exchange(CardIndex cardIndex1, CardIndex cardIndex2) {
        return this.exchange(cardIndex1, cardIndex2, false);
    }

    private boolean exchange(CardIndex cardIndex1, CardIndex cardIndex2, boolean isSilent) {
        return cardIndex1 != null && cardIndex2 != null && cardIndex1 != cardIndex2 && cardIndex1.getLocation() != cardIndex2.getLocation() && this.addSingleCardAction(cardIndex1, c -> new ActionExchange(cardIndex1, cardIndex2, isSilent));
    }

    public final void deleteZone(FieldZone fieldZone, ChronoDuration chronoDuration) {
        if (!(fieldZone instanceof ZoneSIGNI)) {
            return;
        }
        ActionZoneDelete action = new ActionZoneDelete(this.getOpponent(), fieldZone, chronoDuration);
        this.addAction(action);
    }

    public final void rearrangeAll(Game.GamePlayerRole rolePlayer) {
        CardIndex target;
        HashMap<CardIndex, GameConst.CardLocation> oldLocations = new HashMap<CardIndex, GameConst.CardLocation>();
        HashMap<CardIndex, GameConst.CardLocation> newLocations = new HashMap<CardIndex, GameConst.CardLocation>();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            if (!FieldZone.isOccupied(field.getSIGNIZone(zonePosition))) continue;
            CardIndex cardIndexSIGNI = field.getSIGNIZone(zonePosition).getTopCard().getCardIndex();
            oldLocations.put(cardIndexSIGNI, cardIndexSIGNI.getLocation());
        }
        while ((target = this.playerTargetCard(this.getOwner(), 0, 1, AbilityConst.ChoiceLogic.DEFAULT, new TargetFilter(TargetFilter.TargetHint.MOVE).ownedBy(rolePlayer).SIGNI(), null, false).get()) != null) {
            FieldZone fieldZone = this.playerTargetZone(0, 1, new TargetFilter(TargetFilter.TargetHint.MOVE).ownedBy(rolePlayer).SIGNI().except(target)).get();
            if (fieldZone == null) continue;
            if (FieldZone.isOccupied(fieldZone)) {
                CardIndex target2 = fieldZone.getTopCard().getCardIndex();
                if (!this.exchange(target, target2, true)) continue;
                this.updateRearrangedCardLocation(target, oldLocations, newLocations);
                this.updateRearrangedCardLocation(target2, oldLocations, newLocations);
                continue;
            }
            if (!this.moveToZone(target, fieldZone.getZoneLocation(), true)) continue;
            this.updateRearrangedCardLocation(target, oldLocations, newLocations);
        }
        ActionEmpty actionDataHolder = new ActionEmpty();
        for (CardIndex cardIndexSIGNI : newLocations.keySet()) {
            cardIndexSIGNI.setOldLocation((GameConst.CardLocation)((Object)oldLocations.get(cardIndexSIGNI)));
            actionDataHolder.getDataTable().add(cardIndexSIGNI);
        }
        for (int i = 0; i < actionDataHolder.getDataTable().size(); ++i) {
            EventMove eventMove = new EventMove((CardIndex)actionDataHolder.getDataTable().get(i), CardAbilities.getAbility().getSourceCardIndex(), CardAbilities.getAbility(), null, (GameConst.CardLocation)((Object)newLocations.get(actionDataHolder.getDataTable().get(i))));
            eventMove.setAtOnce(actionDataHolder, i, newLocations.size());
            EventPlace eventPlace = new EventPlace((CardIndex)actionDataHolder.getDataTable().get(i), CardAbilities.getAbility().getSourceCardIndex(), CardAbilities.getAbility());
            eventPlace.setAtOnce(actionDataHolder, i, newLocations.size());
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventMove, eventPlace);
        }
        if (actionDataHolder.isSuccessful()) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        }
    }

    private void updateRearrangedCardLocation(CardIndex cardIndex, Map<CardIndex, GameConst.CardLocation> oldLocations, Map<CardIndex, GameConst.CardLocation> newLocations) {
        if (cardIndex.getLocation() == oldLocations.get(cardIndex)) {
            newLocations.remove(cardIndex);
        } else {
            newLocations.put(cardIndex, cardIndex.getLocation());
        }
    }

    public final DataTable<CardIndex> enerCharge(int count) {
        return this.enerCharge(this.getOwner(), count);
    }

    public final DataTable<CardIndex> enerCharge(Game.GamePlayerRole rolePlayer, int count) {
        return this.enerCharge(rolePlayer, count, false);
    }

    private DataTable<CardIndex> enerCharge(Game.GamePlayerRole rolePlayer, int count, boolean isSilent) {
        DataTable<CardIndex> data = new DataTable<CardIndex>();
        for (int i = 0; i < count; ++i) {
            ActionEnerCharge action = new ActionEnerCharge(isSilent);
            this.addAction(action);
            data.addAll(action.getDataTable());
        }
        if (data.isEmpty()) {
            data.add(null);
        }
        return data;
    }

    public final DataTable<CardIndex> putInEner(int count) {
        return this.enerCharge(this.getOwner(), count, true);
    }

    public final boolean putInEner(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionPutInEner::new);
    }

    public final boolean putInEner(GameConst.CardLocation location) {
        return this.putInEner(this.getOwner(), location);
    }

    public final boolean putInEner(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location) {
        ActionPutInEner action = new ActionPutInEner();
        this.addAction(action);
        return action.isSuccessful();
    }

    public final int putInEner(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionPutInEner::new);
    }

    public final boolean putInCheckZone(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionPutInCheckZone::new);
    }

    public final int putInCheckZone(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionPutInCheckZone::new);
    }

    public final CardIndex putInCheckZone(GameConst.CardLocation location) {
        return this.putInCheckZone(this.getOwner(), location, Zone.ZonePosition.TOP);
    }

    public final CardIndex putInCheckZone(GameConst.CardLocation location, Zone.ZonePosition zonePosition) {
        return this.putInCheckZone(this.getOwner(), location, zonePosition);
    }

    public final CardIndex putInCheckZone(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, Zone.ZonePosition zonePosition) {
        ActionPutInCheckZone action = new ActionPutInCheckZone(zonePosition);
        this.addAction(action);
        return (CardIndex)action.getDataTable().get();
    }

    public final DataTable<CardIndex> addToLifeCloth(int count) {
        return this.addToLifeCloth(this.getOwner(), count);
    }

    public final DataTable<CardIndex> addToLifeCloth(Game.GamePlayerRole rolePlayer, int count) {
        ActionAddToLifeCloth action = new ActionAddToLifeCloth(rolePlayer, count);
        this.addAction(action);
        return action.getDataTable();
    }

    public final boolean addToLifeCloth(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionAddToLifeCloth::new);
    }

    public final int addToLifeCloth(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionAddToLifeCloth::new);
    }

    public final DataTable<CardIndex> millDeck(int numToMill) {
        return this.millDeck(this.getOwner(), numToMill, Deck.DeckPosition.TOP);
    }

    public final DataTable<CardIndex> millDeck(int numToMill, Deck.DeckPosition position) {
        return this.millDeck(this.getOwner(), numToMill, position);
    }

    public final DataTable<CardIndex> millDeck(Game.GamePlayerRole rolePlayer, int numToMill) {
        return this.millDeck(rolePlayer, numToMill, Deck.DeckPosition.TOP);
    }

    public final DataTable<CardIndex> millDeck(Game.GamePlayerRole rolePlayer, int numToMill, Deck.DeckPosition position) {
        if (numToMill <= 0 || CardAbilities.getDeckCount(rolePlayer) == 0) {
            return new DataTable<CardIndex>(null);
        }
        ActionRequestInfoDeck actionDeckInfo = new ActionRequestInfoDeck(rolePlayer, numToMill, position);
        this.addAction(actionDeckInfo);
        ActionMillDeck action = new ActionMillDeck(rolePlayer, actionDeckInfo.getDataTable(), position);
        this.addAction(action);
        return action.getDataTable();
    }

    public final DataTable<CardIndex> crush(Game.GamePlayerRole rolePlayer) {
        return this.crush(rolePlayer, AbilityConst.LifeBurst.ACTIVATE);
    }

    public final DataTable<CardIndex> crush(Game.GamePlayerRole rolePlayer, AbilityConst.LifeBurst lifeBurst) {
        ActionCrush action = new ActionCrush(rolePlayer, lifeBurst);
        this.addAction(action);
        return action.getDataTable();
    }

    public final boolean damage(Game.GamePlayerRole rolePlayer) {
        ActionDamage action = new ActionDamage(rolePlayer);
        this.addAction(action);
        return action.isSuccessful();
    }

    public final boolean up() {
        return this.up(CardAbilities.getAbility().getSourceCardIndex());
    }

    public final boolean up(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionUp::new);
    }

    public final int up(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionUp::new);
    }

    public final boolean down() {
        return this.down(CardAbilities.getAbility().getSourceCardIndex());
    }

    public final boolean down(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionDown::new);
    }

    public final int down(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionDown::new);
    }

    public final boolean freeze(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionFreeze::new);
    }

    public final int freeze(DataTable<CardIndex> data) {
        return this.addMultiCardAction(data, ActionFreeze::new);
    }

    public final boolean flip(CardIndex cardIndex, CardConst.CardFace cardFace) {
        return this.flip(cardIndex, cardFace, false);
    }

    public final boolean flip(CardIndex cardIndex, CardConst.CardFace cardFace, boolean allowOccupied) {
        return this.addSingleCardAction(cardIndex, c -> new ActionFlip(cardIndex, cardFace, allowOccupied));
    }

    public final int flip(DataTable<CardIndex> data, CardConst.CardFace cardFace) {
        return this.addMultiCardAction(data, cardIndex -> new ActionFlip((CardIndex)cardIndex, cardFace));
    }

    public final void gainPower(CardIndex cardIndex, double addValue, ChronoDuration chronoDuration) {
        this.addSingleCardAction(cardIndex, c -> new ActionGainPower(cardIndex, addValue, chronoDuration));
    }

    public final void gainPower(DataTable<CardIndex> data, double addValue, ChronoDuration chronoDuration) {
        this.addMultiCardAction(data, cardIndex -> new ActionGainPower((CardIndex)cardIndex, addValue, chronoDuration));
    }

    public final void setBasePower(CardIndex cardIndex, double newValue, ChronoDuration chronoDuration) {
        this.addSingleCardAction(cardIndex, c -> new ActionSetBasePower(cardIndex, newValue, chronoDuration));
    }

    public final void setBasePower(DataTable<CardIndex> data, double newValue, ChronoDuration chronoDuration) {
        this.addMultiCardAction(data, cardIndex -> new ActionSetBasePower((CardIndex)cardIndex, newValue, chronoDuration));
    }

    public final <T, V, M extends ModifiableVariable<T, V, M>> void gainValue(CardIndex cardIndex, ModifiableVariable<T, V, M> mod, T addValue, ChronoDuration chronoDuration) {
        this.gainValue(cardIndex, mod, addValue, new ChronoRecordScheduler.ChronoRecord(cardIndex, chronoDuration));
    }

    public final <T, V, M extends ModifiableVariable<T, V, M>> void gainValue(CardIndex cardIndex, ModifiableVariable<T, V, M> mod, T addValue, ChronoRecordScheduler.ChronoRecord record) {
        if (cardIndex == null || mod == null || addValue == null) {
            return;
        }
        ActionGainValue<T, V, M> action = new ActionGainValue<T, V, M>(cardIndex, mod, addValue, record);
        this.addAction(action);
    }

    public final <T, V, M extends ModifiableVariable<T, V, M>> void setBaseValue(CardIndex cardIndex, ModifiableVariable<T, V, M> mod, V newValue, ChronoDuration chronoDuration) {
        this.setBaseValue(cardIndex, mod, newValue, new ChronoRecordScheduler.ChronoRecord(cardIndex, chronoDuration));
    }

    public final <T, V, M extends ModifiableVariable<T, V, M>> void setBaseValue(CardIndex cardIndex, ModifiableVariable<T, V, M> mod, V newValue, ChronoRecordScheduler.ChronoRecord record) {
        if (cardIndex == null || mod == null || newValue == null) {
            return;
        }
        ActionSetBaseValue<T, V, M> action = new ActionSetBaseValue<T, V, M>(cardIndex, mod, newValue, record);
        this.addAction(action);
    }

    public final <T, V extends CardRuleCheckData> void addCardRuleCheck(CardRuleCheckRegistry.CardRuleCheckType ruleCheckType, CardIndex cardIndex, ChronoDuration chronoDuration, RuleCheck.RuleCheckHandler<T, V> handler) {
        this.addCardRuleCheck(ruleCheckType, cardIndex, new ChronoRecordScheduler.ChronoRecord(cardIndex, chronoDuration), handler);
    }

    public final <T, V extends CardRuleCheckData> void addCardRuleCheck(CardRuleCheckRegistry.CardRuleCheckType ruleCheckType, CardIndex cardIndex, ChronoRecordScheduler.ChronoRecord record, RuleCheck.RuleCheckHandler<T, V> handler) {
        RuleCheck ruleCheck = (RuleCheck)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(ruleCheckType);
        ruleCheck.addRuleCheck(handler, CardAbilities.getAbility());
        if (record != null) {
            record.setOnChronoRecordExpired(() -> {
                RuleCheck ruleCheckToRemove = (RuleCheck)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(ruleCheckType);
                ruleCheckToRemove.removeRuleCheck(handler);
            });
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        }
    }

    public final <T, V extends PlayerRuleCheckData> void addPlayerRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType ruleCheckType, Game.GamePlayerRole rolePlayer, ChronoDuration chronoDuration, RuleCheck.RuleCheckHandler<T, V> handler) {
        this.addPlayerRuleCheck(ruleCheckType, rolePlayer, new ChronoRecordScheduler.ChronoRecord(chronoDuration), handler);
    }

    public final <T, V extends PlayerRuleCheckData> void addPlayerRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType ruleCheckType, Game.GamePlayerRole rolePlayer, ChronoRecordScheduler.ChronoRecord record, RuleCheck.RuleCheckHandler<T, V> handler) {
        RuleCheck ruleCheck = (RuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleCheck(ruleCheckType);
        ruleCheck.addRuleCheck(handler, CardAbilities.getAbility());
        if (record != null) {
            record.setOnChronoRecordExpired(() -> {
                RuleCheck ruleCheckToRemove = (RuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleCheck(ruleCheckType);
                ruleCheckToRemove.removeRuleCheck(handler);
            });
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        }
    }

    public void setPlayerRuleValue(Game.GamePlayerRole rolePlayer, PlayerRuleCheckRegistry.PlayerRuleValueType ruleValueType, Integer newValue, ChronoDuration chronoDuration) {
        if (rolePlayer == null || ruleValueType == null) {
            return;
        }
        ModifiableInteger mod = Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleValue(ruleValueType);
        ModifiableVariable.ModifiableValueReference<Integer> valueReference = mod.setBaseValue(newValue);
        ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(chronoDuration);
        record.setOnChronoRecordExpired(() -> mod.removeBaseValue(valueReference));
        Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
    }

    public void addPlayerRuleValue(Game.GamePlayerRole rolePlayer, PlayerRuleCheckRegistry.PlayerRuleValueType ruleValueType, Integer newValue, ChronoDuration chronoDuration) {
        if (rolePlayer == null || ruleValueType == null) {
            return;
        }
        ModifiableInteger mod = Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleValue(ruleValueType);
        ModifiableVariable.ModifiableValueReference<Integer> valueReference = mod.addValue(newValue);
        ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(chronoDuration);
        record.setOnChronoRecordExpired(() -> mod.removeValue(valueReference));
        Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
    }

    public final DataTable<CardIndex> searchDeck(TargetFilter filter) {
        return this.searchDeck(this.getOwner(), 0, 1, filter, null, Deck.DeckType.MAIN);
    }

    public final DataTable<CardIndex> searchDeck(TargetFilter filter, Deck.DeckType deckType) {
        return this.searchDeck(this.getOwner(), 0, 1, filter, null, deckType);
    }

    public final DataTable<CardIndex> searchDeck(int minPicks, TargetFilter filter) {
        return this.searchDeck(this.getOwner(), minPicks, minPicks, filter, null, Deck.DeckType.MAIN);
    }

    public final DataTable<CardIndex> searchDeck(int minPicks, int maxPicks, TargetFilter filter) {
        return this.searchDeck(this.getOwner(), minPicks, maxPicks, filter, null, Deck.DeckType.MAIN);
    }

    public final DataTable<CardIndex> searchDeck(int minPicks, int maxPicks, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        return this.searchDeck(this.getOwner(), minPicks, maxPicks, filter, condition, Deck.DeckType.MAIN);
    }

    public final DataTable<CardIndex> searchDeck(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, TargetFilter filter, Deck.DeckType deckType) {
        return this.searchDeck(rolePlayer, minPicks, maxPicks, filter, null, deckType);
    }

    public final DataTable<CardIndex> searchDeck(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, TargetFilter filter, ConditionHandler<CardIndex> condition, Deck.DeckType deckType) {
        GameAction actionSearch;
        GameConst.CardLocation location;
        GameConst.CardLocation cardLocation = location = deckType == Deck.DeckType.LRIG ? GameConst.CardLocation.DECK_LRIG : GameConst.CardLocation.DECK_MAIN;
        if (filter != null) {
            filter = filter.own().fromLocation(location);
            filter.setSourceAbility(CardAbilities.getAbility());
        }
        GameField.highlightPlayerField(rolePlayer);
        if (PlayerControl.isChoosingPlayer(rolePlayer)) {
            ActionRequestInfoDeck actionDeckInfo = new ActionRequestInfoDeck();
            this.addAction(actionDeckInfo);
            actionSearch = new ActionManualSearchDeck(minPicks, maxPicks, filter, condition, this.getOwner(), location);
        } else {
            ActionEmpty actionDeckInfo = new ActionEmpty();
            this.addAction(actionDeckInfo);
            actionSearch = new ActionPlayerChoiceCard();
        }
        this.addAction(actionSearch);
        return actionSearch.getDataTable();
    }

    public final boolean shuffleDeck() {
        return this.shuffleDeck(-1, Deck.DeckPosition.TOP);
    }

    public final boolean shuffleDeck(Game.GamePlayerRole rolePlayer) {
        return this.shuffleDeck(rolePlayer, -1, Deck.DeckPosition.TOP);
    }

    public final boolean shuffleDeck(int offsetRange, Deck.DeckPosition position) {
        return this.shuffleDeck(this.getOwner(), offsetRange, position);
    }

    public final boolean shuffleDeck(Game.GamePlayerRole rolePlayer, int offsetRange, Deck.DeckPosition position) {
        ActionShuffleDeck action = new ActionShuffleDeck(rolePlayer, offsetRange, position);
        this.addAction(action);
        return action.isSuccessful();
    }

    public final void shuffleLifeCloth() {
        this.addAction(new ActionEmpty());
    }

    public final boolean cancel(CardIndex cardIndex) {
        return this.addSingleCardAction(cardIndex, ActionCancel::new);
    }

    public final Card.IndexedInstance transform(CardIndex target, String imageSetSource, ChronoDuration chronoDuration) {
        ActionTransform action = new ActionTransform(target, imageSetSource, chronoDuration);
        this.addAction(action);
        return (Card.IndexedInstance)action.getDataTable().get();
    }

    public final CardIndex craft(String imageSet) {
        ActionCraft action = new ActionCraft(this.getOwner(), imageSet);
        this.addAction(action);
        return (CardIndex)action.getDataTable().get();
    }

    public final void gainCoins(int count) {
        ActionGainCoins action = new ActionGainCoins(this.getOwner(), count);
        this.addAction(action);
    }

    public final void inviteCollaboLivers(int count) {
        ActionInviteCollaboLivers action = new ActionInviteCollaboLivers(this.getOwner(), count);
        this.addAction(action);
    }

    public final void ride(CardIndex cardIndex) {
        if (!GameConst.CardLocation.isLRIG(this.getCardIndex().getLocation())) {
            return;
        }
        DataTable cacheSIGNIInDrive = new TargetFilter().own().SIGNI().drive().except(cardIndex).getExportedData(true);
        for (int i = 0; i < cacheSIGNIInDrive.size(); ++i) {
            Game.getCurrentGame().getChronoScheduler().eraseChronoRecords((CardIndex)cacheSIGNIInDrive.get(i), "ride");
        }
        this.addSingleCardAction(cardIndex, c -> new ActionRide(cardIndex));
    }

    public final void ride(DataTable<CardIndex> data) {
        if (!GameConst.CardLocation.isLRIG(this.getCardIndex().getLocation())) {
            return;
        }
        this.addMultiCardAction(data, ActionRide::new);
    }

    public final void becomeCheer() {
    }

    public final boolean use(CardIndex cardIndex) {
        if (cardIndex == null) {
            return false;
        }
        return this.use(cardIndex.getCurrentOwnerSafe(), cardIndex);
    }

    public final boolean use(CardIndex cardIndex, CostModifier costModifier) {
        if (cardIndex == null) {
            return false;
        }
        return this.use(cardIndex.getCurrentOwnerSafe(), cardIndex, costModifier);
    }

    public final boolean use(Game.GamePlayerRole rolePlayerUser, CardIndex cardIndex) {
        return this.use(rolePlayerUser, cardIndex, null);
    }

    public final boolean use(Game.GamePlayerRole rolePlayerUser, CardIndex cardIndex, CostModifier costModifier) {
        return this.addSingleCardAction(cardIndex, c -> new ActionPutOnFieldSpell(cardIndex, rolePlayerUser, costModifier));
    }

    public final int use(DataTable<CardIndex> data, CostModifier costModifier) {
        if (data == null || data.isEmpty() || data.get() == null) {
            return 0;
        }
        GameAction prevAction = null;
        for (int i = data.size() - 1; i >= 0; --i) {
            ActionPutOnFieldSpell action = new ActionPutOnFieldSpell(data.get(i), data.get(i).getCurrentOwnerSafe(), costModifier);
            action.setAtOnce(prevAction, data.size() - 1 - i, data.size());
            prevAction = action;
            this.addAction(action);
        }
        return prevAction.getNumAtOnce();
    }

    public final boolean putKeyOnField(CardIndex cardIndex, CostModifier costModifier) {
        return this.addSingleCardAction(cardIndex, c -> new ActionPutOnFieldKeyPre(cardIndex, costModifier));
    }

    public final void callDelayedEffect(ChronoDuration chronoDuration, AbilityEffectNoSource effect) {
        this.callDelayedEffect(new ChronoRecordScheduler.ChronoRecord(chronoDuration), effect);
    }

    public final void callDelayedEffect(ChronoRecordScheduler.ChronoRecord record, AbilityEffectNoSource effect) {
        ActionCallDelayedEffect action = new ActionCallDelayedEffect(this.getCardIndex(), CardAbilities.getAbility(), record, effect);
        this.addAction(action);
    }

    public final void callDelayedEffect(GameEventTrigger eventTrigger, AbilityEffectNoSource effect) {
        ActionCallDelayedEffect action = new ActionCallDelayedEffect(this.getCardIndex(), CardAbilities.getAbility(), eventTrigger, effect);
        this.addAction(action);
    }

    public final boolean grow(CardIndex cardIndex) {
        ActionGrow action = new ActionGrow(cardIndex, null);
        this.addAction(action);
        return action.isSuccessful();
    }

    public final void grow() {
        if (PlayerControl.isChoosingPlayer(this.getOwner())) {
            CardIndex cardIndexNextLRIG = ActionManualGrow.getNextGrowCandidateLRIG();
            this.addAction(new ActionManualGrow(CardAbilities.getLRIG(this.getOwner()), cardIndexNextLRIG));
        } else {
            this.addAction(new ActionGrow());
        }
    }

    public final void forceTurnEnd() {
        ActionForceTurnEnd action = new ActionForceTurnEnd();
        this.addAction(action);
    }

    public final void forceGameLoss(Game.GamePlayerRole rolePlayer) {
        ActionGameEnd action = new ActionGameEnd(Game.GamePlayerRole.getOpponentRole(rolePlayer));
        this.addAction(action);
    }

    public final void gainBond(String imageSet) {
        Card cardObject = CardLoader.getCardByImageSet(imageSet);
        if (cardObject == null) {
            return;
        }
        ActionGainBond action = new ActionGainBond(this.getOwner(), cardObject);
        this.addAction(action);
    }

    public final boolean hasActiveBond() {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getOwner()).getData().hasStudentBond(this.getCardIndex().getCardReference().getImageSets().getPrimaryImageSet());
    }

    protected final DataTable<CardIndex> getCardsInEner(Game.GamePlayerRole rolePlayer) {
        return this.getCardsInLocation(rolePlayer, GameConst.CardLocation.ENER, false).andRemoveIf(cardIndex -> cardIndex.getLocation() != GameConst.CardLocation.ENER);
    }

    protected final DataTable<CardIndex> getCardsInTrash(Game.GamePlayerRole rolePlayer) {
        return this.getCardsInLocation(rolePlayer, GameConst.CardLocation.TRASH, false);
    }

    protected final DataTable<CardIndex> getCardsInRevealed(Game.GamePlayerRole rolePlayer) {
        return this.getCardsInLocation(rolePlayer, GameConst.CardLocation.REVEALED, true);
    }

    protected final DataTable<CardIndex> getCardsInLooked(Game.GamePlayerRole rolePlayer) {
        return this.getCardsInLocation(rolePlayer, GameConst.CardLocation.LOOKED, true);
    }

    protected final DataTable<CardIndex> getCardsInHand(Game.GamePlayerRole rolePlayer) {
        return this.getCardsInLocation(rolePlayer, GameConst.CardLocation.HAND, false);
    }

    protected final DataTable<CardIndex> getCardsInCheckZone(Game.GamePlayerRole rolePlayer) {
        return this.getCardsInLocation(rolePlayer, GameConst.CardLocation.CHECK_ZONE, false);
    }

    protected final DataTable<CardIndex> getCardsInLRIGDeck(Game.GamePlayerRole rolePlayer) {
        return this.getCardsInLocation(rolePlayer, GameConst.CardLocation.DECK_LRIG, false);
    }

    private DataTable<CardIndex> getCardsInLocation(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, boolean isForward) {
        DataTable<CardIndex> data = new DataTable<CardIndex>();
        List<Card3D> list = FieldData.getZoneByLocation(rolePlayer, location).getZoneCardList();
        if (isForward) {
            for (Card3D card3D : list) {
                data.add(card3D.getCardIndex());
            }
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                data.add(list.get(i).getCardIndex());
            }
        }
        return data;
    }

    protected final DataTable<CardIndex> getSIGNIOnField(Game.GamePlayerRole rolePlayer) {
        DataTable<CardIndex> data = new DataTable<CardIndex>();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            if (!FieldZone.isOccupied(field.getSIGNIZone(zonePosition))) continue;
            data.add(field.getSIGNIZone(zonePosition).getTopCard().getCardIndex());
        }
        return data;
    }

    protected final void forEachCardInLooked(CardFunctionalHandler handler) {
        this.forEachCardInLooked(this.getOwner(), handler);
    }

    protected final void forEachCardInLooked(Game.GamePlayerRole rolePlayer, CardFunctionalHandler handler) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (int i = field.getLookZone().getTotalCards() - 1; i >= 0; --i) {
            handler.handle(field.getLookZone().getZoneCardList().get(i).getCardIndex());
        }
    }

    protected final void forEachCardInRevealed(CardFunctionalHandler handler) {
        this.forEachCardInRevealed(this.getOwner(), handler);
    }

    protected final void forEachCardInRevealed(Game.GamePlayerRole rolePlayer, CardFunctionalHandler handler) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (int i = field.getRevealZone().getTotalCards() - 1; i >= 0; --i) {
            handler.handle(field.getRevealZone().getZoneCardList().get(i).getCardIndex());
        }
    }

    protected final void forEachSIGNIOnField(Game.GamePlayerRole rolePlayer, CardFunctionalHandler handler) {
        Card3D card3D;
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            Card3D card3D2;
            if (!FieldZone.isOccupied(field.getSIGNIZone(zonePosition)) || (card3D2 = field.getSIGNIZone(zonePosition).getTopCard()) == null) continue;
            handler.handle(card3D2.getCardIndex());
        }
        if (FieldZone.isOccupied(field.getCheerZone()) && (card3D = field.getCheerZone().getTopCard()) != null) {
            handler.handle(card3D.getCardIndex());
        }
    }

    protected final void forEachCardUnder(CardIndex cardIndex, CardFunctionalHandler handler) {
        if (cardIndex == null) {
            return;
        }
        this.forEachCardUnder(cardIndex.getCurrentOwnerSafe(), cardIndex.getLocation(), handler);
    }

    protected final void forEachCardUnder(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, CardFunctionalHandler handler) {
        Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (zone != null) {
            for (int i = zone.getTotalCards() - 2; i >= 0; --i) {
                handler.handle(zone.getZoneCardList().get(i).getCardIndex());
            }
        }
    }

    protected final void forEachCardInTrash(Game.GamePlayerRole rolePlayer, CardFunctionalHandler handler) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (int i = field.getTrashZone(Deck.DeckType.MAIN).getTotalCards() - 1; i >= 0; --i) {
            handler.handle(field.getTrashZone(Deck.DeckType.MAIN).getZoneCardList().get(i).getCardIndex());
        }
    }

    protected final void forEachCardInEnerZone(Game.GamePlayerRole rolePlayer, CardFunctionalHandler handler) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (int i = field.getEnerZone().getTotalCards() - 1; i >= 0; --i) {
            CardIndex cardIndex = field.getEnerZone().getZoneCardList().get(i).getCardIndex();
            if (cardIndex.getLocation() != GameConst.CardLocation.ENER) continue;
            handler.handle(cardIndex);
        }
    }

    protected final void forEachLRIGOnField(Game.GamePlayerRole rolePlayer, CardFunctionalHandler handler) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        handler.handle(field.getLRIGZone().getTopCard().getCardIndex());
        if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft())) {
            handler.handle(field.getLRIGAssistZoneLeft().getTopCard().getCardIndex());
        }
        if (FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
            handler.handle(field.getLRIGAssistZoneRight().getTopCard().getCardIndex());
        }
    }

    public void forEachAbility(CardIndex cardIndex, AbilityFunctionalHandler handler) {
        if (cardIndex == null || handler == null) {
            return;
        }
        for (int i = 0; i < cardIndex.getIndexedInstance().getAbilityList().size(); ++i) {
            handler.handle(cardIndex.getIndexedInstance().getAbilityList().get(i));
        }
    }

    public void forEachSIGNIZone(Game.GamePlayerRole rolePlayer, FieldZoneFunctionalHandler handler) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            handler.handle(field.getSIGNIZone(zonePosition));
        }
    }

    public final int getLevelByRef() {
        return this.getLevelByRef(this.getCardIndex().getIndexedInstance().getLevel());
    }

    public final int getLevelByRef(CardIndexSnapshot cardIndexSnapshot) {
        return this.getLevelByRef(cardIndexSnapshot.getLevel());
    }

    private int getLevelByRef(ModifiableInteger modLevel) {
        int level = modLevel.getValue();
        List listValuesByRef = modLevel.getDataByReferenceValues();
        if (listValuesByRef.isEmpty()) {
            return level;
        }
        ArrayList<Integer> cacheValues = new ArrayList<Integer>();
        Ability[] listSourceAbilityRef = new Ability[listValuesByRef.size()];
        for (int i = 0; i < listValuesByRef.size(); ++i) {
            ValueByReference valueByRef = listValuesByRef.get(i);
            if (!valueByRef.getCondition(this.getCardIndex(), CardAbilities.getAbility())) continue;
            if (valueByRef.getOptions().getOptionType() == ValueByReferenceOptions.OptionType.REPLACE_DEFAULT) {
                return (Integer)valueByRef.getOptions().getList().getFirst();
            }
            listSourceAbilityRef[i] = modLevel.getValueByReferenceSourceAbilityRef(i);
            Iterator iterator = valueByRef.getOptions().getList().iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                if (cacheValues.contains(value)) continue;
                cacheValues.add(value);
            }
        }
        if (cacheValues.isEmpty() || cacheValues.size() == 1 && (Integer)cacheValues.getFirst() == level) {
            return level;
        }
        String[] cacheStrings = new String[cacheValues.size() + 1];
        cacheStrings[0] = LanguageParser.getString("CARD_INFO_LEVEL") + " " + level;
        for (int i = 1; i < cacheStrings.length; ++i) {
            cacheStrings[i] = LanguageParser.getString("CARD_INFO_LEVEL") + " " + String.valueOf(cacheValues.get(i - 1));
        }
        int choice = this.playerChoiceOptionByRef(LanguageParser.getString("CARD_INFO_LEVEL"), modLevel, listSourceAbilityRef, cacheStrings);
        return choice > 1 ? (Integer)cacheValues.get(choice - 2) : level;
    }

    public final boolean matchesLevelByRef(Ability sourceAbility, int minValue, int maxValue) {
        int level = this.getCardIndex().getIndexedInstance().getLevel().getValue();
        if (sourceAbility != null) {
            for (ValueByReference valueByRef : this.getCardIndex().getIndexedInstance().getLevel().getDataByReferenceValues()) {
                if (!valueByRef.getCondition(this.getCardIndex(), sourceAbility)) continue;
                Iterator iterator = valueByRef.getOptions().getList().iterator();
                while (iterator.hasNext()) {
                    int value = (Integer)iterator.next();
                    if (!this.matchesLevelRange(value, minValue, maxValue)) continue;
                    return true;
                }
                if (valueByRef.getOptions().getOptionType() != ValueByReferenceOptions.OptionType.REPLACE_DEFAULT) continue;
                return false;
            }
        }
        return this.matchesLevelRange(level, minValue, maxValue);
    }

    private boolean matchesLevelRange(int level, int minValue, int maxValue) {
        return minValue != 0 || maxValue != 0 ? !(minValue != 0 && level < minValue || maxValue != 0 && level > maxValue) : level == 0;
    }

    public final CardConst.CardType getTypeByRef() {
        return this.getTypeByRef(this.getCardIndex().getIndexedInstance().getCardType());
    }

    public final CardConst.CardType getTypeByRef(CardIndexSnapshot cardIndexSnapshot) {
        return this.getTypeByRef(new CardDataType(cardIndexSnapshot.getCardReference().getType()));
    }

    private CardConst.CardType getTypeByRef(CardDataType dataCardType) {
        List listValuesByRef = dataCardType.getDataByReferenceValues();
        if (listValuesByRef.isEmpty()) {
            return dataCardType.getValue();
        }
        ArrayList<CardConst.CardType> cacheValues = new ArrayList<CardConst.CardType>();
        Ability[] listSourceAbilityRef = new Ability[listValuesByRef.size()];
        for (int i = 0; i < listValuesByRef.size(); ++i) {
            ValueByReference valueByRef = listValuesByRef.get(i);
            if (!valueByRef.getCondition(this.getCardIndex(), CardAbilities.getAbility())) continue;
            if (valueByRef.getOptions().getOptionType() == ValueByReferenceOptions.OptionType.REPLACE_DEFAULT) {
                return (CardConst.CardType)((Object)valueByRef.getOptions().getList().getFirst());
            }
            listSourceAbilityRef[i] = dataCardType.getValueByReferenceSourceAbilityRef(i);
            for (CardConst.CardType cardType : valueByRef.getOptions().getList()) {
                if (cacheValues.contains((Object)cardType)) continue;
                cacheValues.add(cardType);
            }
        }
        if (cacheValues.isEmpty()) {
            return dataCardType.getValue();
        }
        String[] cacheStrings = new String[cacheValues.size() + 1];
        cacheStrings[0] = dataCardType.getPrimaryValue().getLabel();
        for (int i = 1; i < cacheStrings.length; ++i) {
            cacheStrings[i] = String.valueOf(cacheValues.get(i - 1));
        }
        int choice = this.playerChoiceOptionByRef(LanguageParser.getString("CARD_INFO_TYPE"), dataCardType, listSourceAbilityRef, cacheStrings);
        if (choice <= 1) {
            return dataCardType.getValue();
        }
        return (CardConst.CardType)((Object)cacheValues.get(choice - 2));
    }

    public final boolean matchesTypeByRef(Ability sourceAbility, CardConst.CardType ... cardTypes) {
        CardDataType dataCardType = this.getCardIndex().getIndexedInstance().getCardType();
        if (sourceAbility != null) {
            for (ValueByReference valueByReference : dataCardType.getDataByReferenceValues()) {
                if (!valueByReference.getCondition(this.getCardIndex(), sourceAbility)) continue;
                if (Arrays.stream(cardTypes).anyMatch(valueByReference.getOptions().getList()::contains)) {
                    return true;
                }
                if (valueByReference.getOptions().getOptionType() != ValueByReferenceOptions.OptionType.REPLACE_DEFAULT) continue;
                return false;
            }
        }
        for (CardConst.CardType cardType : cardTypes) {
            if (dataCardType.getValue() != cardType) continue;
            return true;
        }
        return false;
    }

    public final boolean isPlayable() {
        return this.isPlayable(this.getOwner());
    }

    public final boolean isPlayable(Game.GamePlayerRole rolePlayerUser) {
        return UtilCardPlayableControl.isPlayable(rolePlayerUser, this.getCardIndex(), CardAbilities.getAbility()) == UtilCardPlayableControl.PlayableResult.OK;
    }

    public final boolean isPlayableAs(CardIndex cardIndexReplace, Ability sourceAbility) {
        if (cardIndexReplace == null || cardIndexReplace.getIndexedInstance() == null || this.getCardIndex().getCardReference().getType() != CardConst.CardType.SIGNI || this.getCardIndex().getIndexedInstance().getUseCondition() == GameConst.UseCondition.RISE && !this.getCardIndex().getIndexedInstance().getUseConditionTargetFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
            return false;
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getOwner());
        CardIndex cardIndexLRIG = field.getLRIGZone().getTopCard().getCardIndex();
        GameConst.SIGNIZonePosition zonePosition = GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(GameConst.CardLocation.isSIGNI(this.getCardIndex().getLocation()) ? this.getCardIndex().getLocation() : cardIndexReplace.getLocation());
        return !(this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_NEWLY_PUT_ON_FIELD).check(this.getCardIndex(), sourceAbility, new Object[0]) != RuleCheck.RuleCheckState.OK || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.getOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_NEWLY_PUT_SIGNI_ON_FIELD).check(this.getOwner(), cardIndexReplace, sourceAbility, new Object[]{zonePosition}) != RuleCheck.RuleCheckState.OK || !RuleCheckCanPlaceSIGNIOnZone.matchesResult((RuleCheckCanPlaceSIGNIOnZone)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.getOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_PLACE_SIGNI_ON_ZONE), this.getOwner(), zonePosition) || !AbilityCostList.canPayDataCostLists(((AbilityCost)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.getOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.COST_TO_PLACE_SIGNI_ON_ZONE).check(this.getOwner(), cardIndexReplace, sourceAbility, new Object[]{this.getCardIndex(), zonePosition})).getSourceCostList().getSourceDataCostLists()) || this.getCardIndex().getIndexedInstance().getLRIGType().getPrimaryValue() != CardConst.CardLRIGType.NO_LRIG_LIMIT && !this.getCardIndex().getIndexedInstance().getLRIGType().matches(cardIndexLRIG.getIndexedInstance().getLRIGType()) || this.getCardIndex().getIndexedInstance().getLevel().getValue() > cardIndexLRIG.getIndexedInstance().getLevel().getValue() || !((double)field.getSIGNILimitSum() - cardIndexReplace.getSIGNILimitConsumption() + this.getCardIndex().getSIGNILimitConsumption() <= cardIndexLRIG.getIndexedInstance().getLimit().getValue()) || this.getCardIndex().getIndexedInstance().getUseConditionTargetFilter() != null && this.getCardIndex().getIndexedInstance().getUseConditionTargetFilter().getExportedData().size() < this.getCardIndex().getIndexedInstance().getUseConditionNumPicks());
    }

    public final Optional<LifeBurstAbility> findLifeBurstAbility() {
        return this.getCardIndex().getIndexedInstance().getAbilityList().stream().filter(ability -> ability instanceof LifeBurstAbility).map(LifeBurstAbility.class::cast).findFirst();
    }

    public final boolean hasNoAbilities() {
        return this.getCardIndex().getIndexedInstance().getAbilityList().isEmpty() || this.getCardIndex().getIndexedInstance().getAbilityList().stream().allMatch(Ability::isDisabled);
    }

    public final void disableAllAbilities(CardIndex cardIndex, AbilityConst.AbilityGain abilityGain, ChronoDuration chronoDuration) {
        this.disableAllAbilities(cardIndex, null, abilityGain, chronoDuration);
    }

    public final void disableAllAbilities(CardIndex cardIndex, AbilityFunctionalConditionalHandler handlerAbility, ChronoDuration chronoDuration) {
        this.disableAllAbilities(cardIndex, handlerAbility, AbilityConst.AbilityGain.ALLOW, chronoDuration);
    }

    private void disableAllAbilities(CardIndex cardIndex, AbilityFunctionalConditionalHandler handlerAbility, AbilityConst.AbilityGain abilityGain, ChronoDuration chronoDuration) {
        this.addSingleCardAction(cardIndex, c -> new ActionDisableAllAbilities(cardIndex, handlerAbility, abilityGain, chronoDuration));
    }

    public final void disableAllAbilities(DataTable<CardIndex> data, AbilityConst.AbilityGain abilityGain, ChronoDuration chronoDuration) {
        this.disableAllAbilities(data, null, abilityGain, chronoDuration);
    }

    public final void disableAllAbilities(DataTable<CardIndex> data, AbilityFunctionalConditionalHandler handlerAbility, ChronoDuration chronoDuration) {
        this.disableAllAbilities(data, handlerAbility, AbilityConst.AbilityGain.ALLOW, chronoDuration);
    }

    private void disableAllAbilities(DataTable<CardIndex> data, AbilityFunctionalConditionalHandler handlerAbility, AbilityConst.AbilityGain abilityGain, ChronoDuration chronoDuration) {
        this.addMultiCardAction(data, cardIndex -> new ActionDisableAllAbilities((CardIndex)cardIndex, handlerAbility, abilityGain, chronoDuration));
    }

    public void blockNextDamage() {
        this.blockNextDamage(new DamageBlockParams().withGFX("generic", new int[]{50, 205, 50}));
    }

    public void blockNextDamage(DamageBlockParams params) {
        ChronoRecordScheduler.ChronoRecord record = params.getDuration();
        GFX gfx = params.getGFX(this.getOwner());
        if (gfx != null) {
            GFX.attachToChronoRecord(record, gfx);
        }
        this.addPlayerRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.ACTION_OVERRIDE, this.getOwner(), record, (V data) -> new OverrideAction(GameConst.GameEventId.DAMAGE, OverrideAction.OverrideScope.GLOBAL, 0, (cardIndex, event, sourceAbilityRC) -> params.shouldBlockDamage(event.getSource()), (list, sourceAbilityRC) -> {
            if (params.shouldExpire()) {
                record.forceExpire();
            }
            params.callOnDamageBlocked();
        }));
    }

    public void disableNextAttack(CardIndex cardIndex) {
        if (cardIndex == null || cardIndex.getIndexedInstance() == null) {
            return;
        }
        int instanceId = cardIndex.getIndexedInstance().getInstanceId();
        int nextAttack = CardAbilities.getAttacksCount(instanceId) + (cardIndex.getIndexedInstance().isState(32768) ? 0 : 1);
        ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(cardIndex, ChronoDuration.turnEnd());
        GFX.attachToChronoRecord(record, new GFXCardTextureLayer(cardIndex, UtilTextureLayer.TextureType.DISABLEATK));
        this.addCardRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_LAND_ATTACK, cardIndex, record, (V dataRC) -> {
            record.forceExpire();
            return CardAbilities.getAttacksCount(instanceId) == nextAttack ? RuleCheck.RuleCheckState.BLOCK : RuleCheck.RuleCheckState.IGNORE;
        });
    }

    private static int getAttacksCount(int instanceId) {
        return GameLog.getTurnRecordsCount(event -> event.getId() == GameConst.GameEventId.ATTACK && event.getCaller().getInstanceId() == instanceId);
    }

    public static int getColorsCount(DataTable<CardIndex> data) {
        HashSet cacheColors = new HashSet();
        if (data != null && !data.isEmpty() && data.get() != null) {
            for (int i = 0; i < data.size(); ++i) {
                CardDataColor dataColor = data.get(i).getIndexedInstance().getColor();
                if (dataColor.getPrimaryValue() == CardConst.CardColor.COLORLESS) continue;
                cacheColors.addAll(dataColor.getValue());
            }
        }
        return cacheColors.size();
    }

    @Deprecated
    public static List<CardDataSIGNIClass.CardSIGNIClassValue> getSIGNIClasses(DataTable<CardIndex> data) {
        return CardAbilities.internalGetSIGNIClasses(data, true);
    }

    @Deprecated
    public static List<CardDataSIGNIClass.CardSIGNIClassValue> getUniqueSIGNIClasses(DataTable<CardIndex> data) {
        return CardAbilities.internalGetSIGNIClasses(data, true);
    }

    @Deprecated
    private static List<CardDataSIGNIClass.CardSIGNIClassValue> internalGetSIGNIClasses(DataTable<CardIndex> data, boolean countUniqueOnly) {
        ArrayList<CardDataSIGNIClass.CardSIGNIClassValue> cacheClasses = new ArrayList<CardDataSIGNIClass.CardSIGNIClassValue>();
        if (data != null && !data.isEmpty() && data.get() != null) {
            for (int i = 0; i < data.size(); ++i) {
                Iterator iterator = data.get(i).getIndexedInstance().getSIGNIClass().getValue().iterator();
                while (iterator.hasNext()) {
                    CardDataSIGNIClass.CardSIGNIClassValue cardSIGNIClassValue = (CardDataSIGNIClass.CardSIGNIClassValue)iterator.next();
                    if (countUniqueOnly && cacheClasses.contains(cardSIGNIClassValue)) continue;
                    cacheClasses.add(cardSIGNIClassValue);
                }
            }
        }
        return cacheClasses;
    }

    public static DataTable<CardIndex> getLRIGs(Game.GamePlayerRole rolePlayer) {
        DataTable<CardIndex> data = new DataTable<CardIndex>(CardAbilities.getLRIG(rolePlayer));
        data.add(CardAbilities.getLRIGAssistLeft(rolePlayer));
        data.add(CardAbilities.getLRIGAssistRight(rolePlayer));
        return data;
    }

    public static CardIndex getLRIG(Game.GamePlayerRole rolePlayer) {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getLRIGZone().getTopCard().getCardIndex();
    }

    public static CardIndex getLRIGAssistLeft(Game.GamePlayerRole rolePlayer) {
        ZoneLRIGAssist zoneLRIG = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getLRIGAssistZoneLeft();
        return zoneLRIG.getTopCard() != null ? zoneLRIG.getTopCard().getCardIndex() : null;
    }

    public static CardIndex getLRIGAssistRight(Game.GamePlayerRole rolePlayer) {
        ZoneLRIGAssist zoneLRIG = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getLRIGAssistZoneRight();
        return zoneLRIG.getTopCard() != null ? zoneLRIG.getTopCard().getCardIndex() : null;
    }

    public static DataTable<CardIndex> getKeys(Game.GamePlayerRole rolePlayer) {
        DataTable<CardIndex> data = new DataTable<CardIndex>();
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getKeyZone().getZoneCardList().forEach(card3D -> data.add(card3D.getCardIndex()));
        return data;
    }

    protected final int getCoins(Game.GamePlayerRole rolePlayer) {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getData().getCoins();
    }

    protected final int getLookedCount() {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getOwner()).getLookZone().getTotalCards();
    }

    protected final int getRevealedCount() {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getOwner()).getRevealZone().getTotalCards();
    }

    public static int getHandCount(Game.GamePlayerRole rolePlayer) {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getHand().getTotalCards();
    }

    public static int getEnerCount(Game.GamePlayerRole rolePlayer) {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getEnerZone().getTotalCards();
    }

    public static int getTrashCount(Game.GamePlayerRole rolePlayer) {
        return CardAbilities.getTrashCount(rolePlayer, Deck.DeckType.MAIN);
    }

    public static int getTrashCount(Game.GamePlayerRole rolePlayer, Deck.DeckType deckType) {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getTrashZone(deckType).getTotalCards();
    }

    public static int getDeckCount(Game.GamePlayerRole rolePlayer) {
        return CardAbilities.getDeckCount(rolePlayer, Deck.DeckType.MAIN);
    }

    public static int getDeckCount(Game.GamePlayerRole rolePlayer, Deck.DeckType deckType) {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getDeckZone(deckType).getTotalCards();
    }

    public static int getSIGNICount(Game.GamePlayerRole rolePlayer) {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getSIGNICount(true);
    }

    public static int getLifeClothCount(Game.GamePlayerRole rolePlayer) {
        return new TargetFilter(TargetFilter.TargetHint.GENERIC, rolePlayer).own().fromSafeLocation(GameConst.CardLocation.LIFE_CLOTH, GameConst.CardLocation.LOOKED, GameConst.CardLocation.REVEALED).custom(cardIndex -> cardIndex.isEffectivelyAtLocation(GameConst.CardLocation.LIFE_CLOTH)).getValidTargetsCount(true);
    }

    public static int getCheckZoneCount(Game.GamePlayerRole rolePlayer) {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getCheckZone().getTotalCards();
    }

    public final boolean isLRIGTeam(CardConst.CardLRIGTeam cardLRIGTeam) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getOwner());
        return field.getLRIGZone().getTopCard().getCardIndex().getCardReference().getLRIGTeam() == cardLRIGTeam && FieldZone.isOccupied(field.getLRIGAssistZoneLeft()) && field.getLRIGAssistZoneLeft().getTopCard().getCardIndex().getCardReference().getLRIGTeam() == cardLRIGTeam && FieldZone.isOccupied(field.getLRIGAssistZoneRight()) && field.getLRIGAssistZoneRight().getTopCard().getCardIndex().getCardReference().getLRIGTeam() == cardLRIGTeam;
    }

    public final int getCardsUnderCount(GameConst.CardUnderType underType) {
        return this.internalGetCardsUnderCount(underType.getFlags(), true);
    }

    public final int getCardsUnderCount(GameConst.CardUnderCategory underCategory) {
        return this.internalGetCardsUnderCount(underCategory.getFlags(), false);
    }

    public final int getCardsUnderCount(int flagsUnderType) {
        return this.internalGetCardsUnderCount(flagsUnderType, false);
    }

    private int internalGetCardsUnderCount(int flagsUnderType, boolean exactMatch) {
        if (!GameConst.CardLocation.isSIGNI(this.getCardIndex().getLocation()) && !GameConst.CardLocation.isLRIG(this.getCardIndex().getLocation())) {
            return 0;
        }
        int count = 0;
        Zone zone = this.getCardIndex().getZoneByLocation();
        for (int i = zone.getTotalCards() - 2; i >= 0; --i) {
            int flagsUnder = zone.getZoneCardList().get(i).getCardIndex().getUnderType().getFlags();
            if (!(exactMatch ? flagsUnder == flagsUnderType : (flagsUnder & flagsUnderType) != 0)) continue;
            ++count;
        }
        return count;
    }

    public final boolean isOwnCard(CardIndex cardIndex) {
        return cardIndex != null && cardIndex.getCurrentOwnerSafe() == this.getOwner();
    }

    public final boolean isOwnCard(CardIndexSnapshot cardIndexSnapshot) {
        return cardIndexSnapshot != null && cardIndexSnapshot.getOwner() == this.getOwner();
    }

    public final boolean isOwnTurn() {
        return Game.getCurrentGame().getGameRules().getTurnPlayer() == this.getOwner();
    }

    public static boolean isGuardStep() {
        return Game.getCurrentGame().getGameRules().isGuardStep();
    }

    public static int getTurnCount() {
        return Game.getCurrentGame().getGameRules().getTurnCount();
    }

    protected final Game.GamePlayerRole getOwner() {
        Ability ability;
        if (CardAbilities.getAbility() != null && (ability = CardAbilities.getAbility().getSourceAttachAbility()) instanceof CheckZoneAbility) {
            CheckZoneAbility checkZoneAbility = (CheckZoneAbility)ability;
            CardIndex cardIndexSource = CardAbilities.getAbility().getSourceCardIndex();
            if (cardIndexSource.getIndexedInstance() != null && checkZoneAbility.wasTargetedWhileStolen(cardIndexSource.getIndexedInstance().getInstanceId())) {
                return cardIndexSource.getIndexedInstance().getCurrentOwner();
            }
        }
        return this.getCardIndex().getCurrentOwnerSafe();
    }

    public final Game.GamePlayerRole getOpponent() {
        return Game.GamePlayerRole.getOpponentRole(this.getOwner());
    }

    public static Game.GamePlayerRole getTurnPlayer() {
        return Game.getCurrentGame().getGameRules().getTurnPlayer();
    }

    public static boolean isSIGNINextToSIGNI(CardIndex cardIndex1, CardIndex cardIndex2) {
        return cardIndex1.getLocation() == GameConst.CardLocation.SIGNI_LEFT && cardIndex2.getLocation() == GameConst.CardLocation.SIGNI_CENTER || cardIndex1.getLocation() == GameConst.CardLocation.SIGNI_RIGHT && cardIndex2.getLocation() == GameConst.CardLocation.SIGNI_CENTER || cardIndex1.getLocation() == GameConst.CardLocation.SIGNI_CENTER && (cardIndex2.getLocation() == GameConst.CardLocation.SIGNI_LEFT || cardIndex2.getLocation() == GameConst.CardLocation.SIGNI_RIGHT);
    }

    public final CardIndex getOppositeSIGNI() {
        return this.getOppositeSIGNI(GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(this.getCardIndex().getLocation()));
    }

    public final CardIndex getOppositeSIGNI(GameConst.SIGNIZonePosition zonePosition) {
        if (zonePosition == null) {
            return null;
        }
        ZoneSIGNI zoneSIGNI = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getOpponent()).getSIGNIZone(GameConst.SIGNIZonePosition.getOppositeSIGNIPosition(zonePosition));
        return zoneSIGNI != null && ZoneSIGNI.isOccupied(zoneSIGNI) ? zoneSIGNI.getTopCard().getCardIndex() : null;
    }

    public final CardIndex getTopOverSIGNI() {
        return GameConst.CardLocation.isSIGNI(this.getCardIndex().getLocation()) ? this.getCardIndex().getZoneByLocation().getTopCard().getCardIndex() : null;
    }

    public static GameConst.GamePhase getCurrentPhase() {
        return Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().getId();
    }

    public static Ability getAbility() {
        return EffectBucket.getCurrentResolvingAbility() != null ? EffectBucket.getCurrentResolvingAbility() : EffectBucket.getLastAbility();
    }

    public static GameEvent getEvent() {
        return EffectBucket.getCurrentResolvingEvent() != null ? EffectBucket.getCurrentResolvingEvent() : EffectBucket.getLastEvent();
    }
}

