/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.DataTable;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.ModalAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.modifiers.CostModifier;

public class CheckZoneAbility
extends ModalAbility {
    private final List<AbilityCostList> listCostsAdditional = new ArrayList<AbilityCostList>();
    private final List<AbilityCostList> listCostsBet = new ArrayList<AbilityCostList>();
    private List<Integer> cacheTargetsWhileStolen;
    private CheckZoneFunctionalHandler handlerPreTarget;
    private final List<CardIndex> targets = new ArrayList<CardIndex>();
    private final List<GameConst.CardLocation> cacheTargetsLocations = new ArrayList<GameConst.CardLocation>();
    private CheckZoneCostModifierHandler handlerCostModifier;
    private CostModifier lastCostModifier;
    private boolean hasPaidAdditional;
    private boolean hasUsedBet;
    private CheckZoneFunctionalHandler handlerOnUsedBet;
    private CheckZoneOnAbilityEndHandler handlerOnAbilityEnd;
    private AbilityCostList reductionPayCostList;
    private String reductionEnerCostString;
    private CostModifier.ModifierMode reductionCostModifierMode;
    private CostModifier reductionCostModifier;
    private int reductionForcedPaymentMinCount;
    private boolean isBetReductionCost;

    public CheckZoneAbility(AbilityEffectNoSource effect) {
        this(null, effect);
    }

    public CheckZoneAbility(CheckZoneFunctionalHandler handlerPreTarget, AbilityEffectNoSource effect) {
        this.setEffect(effect);
        this.handlerPreTarget = handlerPreTarget;
    }

    public void onActivatedPreTarget() {
        if (this.handlerPreTarget == null) {
            return;
        }
        TargetFilter.setDefaultSources(this.getSourceCardIndex(), this);
        this.handlerPreTarget.handle();
    }

    public void setTargets(DataTable<CardIndex> data) {
        if (data != null && !data.isEmpty() && data.get() != null) {
            for (int i = 0; i < data.size(); ++i) {
                this.addTarget(data.get(i));
            }
        }
    }

    public void addTarget(CardIndex target) {
        this.targets.add(target);
        if (target != null) {
            this.cacheTargetsLocations.add(target.getLocation());
            if (this.getSourceCardIndex().getIndexedInstance().isState(512)) {
                if (this.cacheTargetsWhileStolen == null) {
                    this.cacheTargetsWhileStolen = new ArrayList<Integer>();
                }
                this.cacheTargetsWhileStolen.add(target.getIndexedInstance().getInstanceId());
                target.getIndexedInstance().setOnInstanceIdUpdated(oldInstanceId -> {
                    this.cacheTargetsWhileStolen.remove(oldInstanceId);
                    if (this.cacheTargetsWhileStolen.isEmpty()) {
                        this.cacheTargetsWhileStolen = null;
                    }
                });
            }
        }
    }

    public DataTable<CardIndex> getTargets() {
        DataTable<CardIndex> data = new DataTable<CardIndex>();
        for (int i = 0; i < this.targets.size(); ++i) {
            data.add(this.getTarget(i));
        }
        return data;
    }

    public CardIndex getTarget() {
        return this.getTarget(0);
    }

    public CardIndex getTarget(int arrayId) {
        if (this.targets.isEmpty() || arrayId < 0 || arrayId >= this.targets.size()) {
            return null;
        }
        CardIndex target = this.targets.get(arrayId);
        return target != null && target.getIndexedInstance() != null && (target.getLocation() == this.cacheTargetsLocations.get(arrayId) || GameConst.CardLocation.isSIGNI(target.getLocation()) && GameConst.CardLocation.isSIGNI(this.cacheTargetsLocations.get(arrayId))) && target.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_TARGETED).check(target, this.getSourceCardIndex(), this, new Object[]{this.getAbilityOwner()}) == RuleCheck.RuleCheckState.OK ? target : null;
    }

    public boolean wasTargetedWhileStolen(int instanceId) {
        return this.cacheTargetsWhileStolen != null && this.cacheTargetsWhileStolen.contains(instanceId);
    }

    @Override
    public void onAbilityEnd(boolean wasResolved) {
        this.targets.clear();
        this.hasPaidAdditional = false;
        this.hasUsedBet = false;
        if (this.reductionCostModifier != null) {
            this.reductionCostModifier.restore(this.getCostLists());
        }
        this.reductionForcedPaymentMinCount = 0;
        if (this.handlerOnAbilityEnd != null) {
            this.handlerOnAbilityEnd.handle(wasResolved);
            this.handlerOnAbilityEnd = null;
        }
    }

    public void setOnAbilityEnd(CheckZoneOnAbilityEndHandler handlerOnAbilityEnd) {
        this.handlerOnAbilityEnd = handlerOnAbilityEnd;
    }

    public void setCostModifier(CheckZoneCostModifierHandler handlerCostModifier) {
        this.handlerCostModifier = handlerCostModifier;
    }

    public void updateDynamicCost() {
        if (this.handlerCostModifier != null) {
            if (this.lastCostModifier != null) {
                this.lastCostModifier.restore(this.getCostLists());
            }
            TargetFilter.setDefaultSources(this.getSourceCardIndex(), this);
            this.lastCostModifier = this.handlerCostModifier.getCostModifier();
            if (this.lastCostModifier != null) {
                this.lastCostModifier.modify(this.getCostLists(), this.getSourceCardIndex(), this);
            }
        }
    }

    public void setAdditionalCost(AbilityCost cost) {
        AbilityCostList costList = new AbilityCostList(cost);
        costList.setSourceAbility(this);
        this.listCostsAdditional.add(costList);
    }

    public final List<AbilityCostList> getAdditionalCostLists() {
        return this.listCostsAdditional;
    }

    public void setBetCost(AbilityCost cost) {
        this.setBetCost(cost, null, null);
    }

    public void setBetCost(AbilityCost cost, String reductionEnerCostString, CostModifier.ModifierMode reductionCostModifierMode) {
        AbilityCostList costList = new AbilityCostList(cost);
        costList.setSourceAbility(this);
        this.listCostsBet.add(costList);
        if (reductionEnerCostString != null) {
            this.isBetReductionCost = true;
            this.setReductionCost(cost, reductionEnerCostString, reductionCostModifierMode);
        }
    }

    public final List<AbilityCostList> getBetCostLists() {
        return this.listCostsBet;
    }

    public void setOnUsedBet(CheckZoneFunctionalHandler handlerOnUsedBet) {
        this.handlerOnUsedBet = handlerOnUsedBet;
    }

    public void setReductionCost(AbilityCost payCost, String reductionEnerCostString) {
        this.setReductionCost(payCost, reductionEnerCostString, CostModifier.ModifierMode.REDUCE);
    }

    public void setReductionCost(AbilityCost payCost, String reductionEnerCostString, CostModifier.ModifierMode reductionCostModifierMode) {
        this.reductionPayCostList = new AbilityCostList(payCost);
        this.reductionPayCostList.setSourceAbility(this);
        this.reductionEnerCostString = reductionEnerCostString;
        this.reductionCostModifierMode = reductionCostModifierMode;
    }

    public AbilityCostList getReductionPayCostList() {
        return this.reductionPayCostList;
    }

    public String getReductionEnerCostString() {
        return this.reductionEnerCostString;
    }

    public CostModifier.ModifierMode getReductionCostModifierMode() {
        return this.reductionCostModifierMode;
    }

    public void setReductionCostModifier(CostModifier costModifier) {
        this.reductionCostModifier = costModifier;
        if (this.reductionCostModifier != null) {
            this.reductionCostModifier.modify(this.getCostLists(), this.getSourceCardIndex(), this);
        }
    }

    public int getReductionForcedPaymentMinCount() {
        return this.reductionForcedPaymentMinCount;
    }

    public boolean isBetReductionCost() {
        return this.isBetReductionCost;
    }

    public boolean canPayCost() {
        boolean canPayNormalCost = AbilityCostList.canPayDataCostLists(this.getCostLists());
        if (this.reductionPayCostList == null) {
            return canPayNormalCost;
        }
        AbilityCost reductionPayCost = this.reductionPayCostList.getDataArray().getFirst();
        reductionPayCost.getModifiableCostMinCount().resetValue();
        this.reductionForcedPaymentMinCount = 0;
        if (canPayNormalCost) {
            return true;
        }
        if (this.reductionCostModifierMode == CostModifier.ModifierMode.REDUCE) {
            reductionPayCost.getModifiableCostMinCount().setBaseValue(1);
        }
        if (!reductionPayCost.canBePaidWithResult() || reductionPayCost.getCanBePaidPrivately() != null && !reductionPayCost.getCanBePaidPrivately().booleanValue()) {
            return false;
        }
        if (this.reductionCostModifierMode == CostModifier.ModifierMode.SET) {
            this.reductionForcedPaymentMinCount = reductionPayCost.getCostMinCount();
            return true;
        }
        int countMax = reductionPayCost.getCostMaxCount();
        if (countMax == 100) {
            countMax = reductionPayCost.getFilter().getValidTargetsCount();
        }
        for (int i = 1; i <= countMax; ++i) {
            String reducedEnerCostString = this.reductionEnerCostString.repeat(i);
            CostModifier costModifier = new CostModifier(() -> new EnerCost(reducedEnerCostString), this.reductionCostModifierMode);
            this.setReductionCostModifier(costModifier);
            if (AbilityCostList.canPayDataCostListsPrivately(this.getCostLists())) {
                costModifier.restore(this.getCostLists());
                if (i > 1) {
                    ModifiableVariable.ModifiableValueReference<Integer> valueReference = reductionPayCost.getModifiableCostMinCount().setBaseValue(i);
                    if (!reductionPayCost.canBePaidWithResult() || reductionPayCost.getCanBePaidPrivately() != null && !reductionPayCost.getCanBePaidPrivately().booleanValue()) {
                        reductionPayCost.getModifiableCostMinCount().removeBaseValue(valueReference);
                        break;
                    }
                }
                this.reductionForcedPaymentMinCount = i;
                return true;
            }
            costModifier.restore(this.getCostLists());
        }
        return false;
    }

    public void setHasUsedBet() {
        this.hasUsedBet = true;
        if (this.handlerOnUsedBet != null) {
            this.handlerOnUsedBet.handle();
        }
    }

    public boolean hasUsedBet() {
        return this.hasUsedBet;
    }

    @Override
    public void onAbilityInit() {
        this.setCost(this.getSourceCardIndex().getIndexedInstance().getCost());
        super.onAbilityInit();
    }

    public void setHasPaidAdditionalCost() {
        this.hasPaidAdditional = true;
    }

    public boolean hasPaidAdditionalCost() {
        return this.hasPaidAdditional;
    }

    @Override
    public void dispose() {
        this.listCostsAdditional.forEach(AbilityCostList::dispose);
        this.listCostsAdditional.clear();
        this.listCostsBet.forEach(AbilityCostList::dispose);
        this.listCostsBet.clear();
        this.handlerPreTarget = null;
        this.targets.clear();
        this.handlerCostModifier = null;
        this.lastCostModifier = null;
        this.handlerOnUsedBet = null;
        this.handlerOnAbilityEnd = null;
        if (this.reductionPayCostList != null) {
            this.reductionPayCostList.dispose();
            this.reductionPayCostList = null;
        }
        this.reductionCostModifier = null;
        super.dispose();
    }

    @FunctionalInterface
    public static interface CheckZoneFunctionalHandler {
        public void handle();
    }

    @FunctionalInterface
    public static interface CheckZoneOnAbilityEndHandler {
        public void handle(boolean var1);
    }

    @FunctionalInterface
    public static interface CheckZoneCostModifierHandler {
        public CostModifier getCostModifier();
    }
}

