/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import open.batoru.core.Game;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.events.EventLifeBurst;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.overlay.log.OverlayGameLogLifeClothTracker;

public class LifeBurstAbility
extends Ability {
    private OverlayGameLogLifeClothTracker.LifeClothTrackerBox sourceLifeClothTrackerBox;

    public LifeBurstAbility(AbilityEffectNoSource effect) {
        this.setEffect(() -> {
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventLifeBurst(this));
            if (!this.isDisabled()) {
                effect.handle();
            }
        });
        this.setActiveEvent(GameConst.GameEventId.ABILITY_LIFEBURST);
        this.setActiveLocation(GameConst.CardLocation.CHECK_ZONE);
        this.getFlags().addValue(2);
    }

    @Override
    public boolean isActiveDuringEvent(GameEvent event) {
        return super.isActiveDuringEvent(event) && event.getSourceAbility() == this;
    }

    @Override
    public void onAbilityEnd(boolean wasResolved) {
        if (this.getSourceCardIndex().getLocation() != GameConst.CardLocation.CHECK_ZONE) {
            return;
        }
        EffectBucket sourceBucket = Game.getCurrentGame().getGameRules().getEffectProcessor().getSourceBucket(this);
        for (int i = sourceBucket.getCompletedEffectsNum() + 1; i < sourceBucket.getAbilitiesNum(); ++i) {
            Ability ability = sourceBucket.getAbilityList().get(i);
            if (!(ability instanceof LifeBurstAbility) || ability.getSourceCardIndex() != this.getSourceCardIndex()) continue;
            return;
        }
        this.getSourceCardIndex().getIndexedInstance().getCardStateFlags().addValue(256);
    }

    public void setSourceLifeClothTrackerBox(OverlayGameLogLifeClothTracker.LifeClothTrackerBox lifeClothTrackerBox) {
        this.sourceLifeClothTrackerBox = lifeClothTrackerBox;
    }

    public OverlayGameLogLifeClothTracker.LifeClothTrackerBox getSourceLifeClothTrackerBox() {
        return this.sourceLifeClothTrackerBox;
    }

    @Override
    public void dispose() {
        this.sourceLifeClothTrackerBox = null;
        super.dispose();
    }
}

