/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionDiscard;
import open.batoru.core.gameplay.actions.ActionManualDiscard;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.ui.UI;

public class DiscardCost
extends AbilityCost {
    private boolean forceAutoConfirm;

    public DiscardCost() {
    }

    public DiscardCost(int countMin) {
        super(countMin, countMin, null, null);
    }

    public DiscardCost(int countMin, int countMax) {
        super(countMin, countMax, null, null);
    }

    public DiscardCost(int countMin, int countMax, AbilityConst.ChoiceLogic choiceLogic) {
        super(countMin, countMax, null, null);
        this.setChoiceLogic(choiceLogic);
    }

    public DiscardCost(TargetFilter filter) {
        super(1, 1, filter.fromHand(), null);
    }

    public DiscardCost(int countMin, TargetFilter filter) {
        super(countMin, countMin, filter.fromHand(), null);
    }

    public DiscardCost(int countMin, int countMax, TargetFilter filter) {
        super(countMin, countMax, filter.fromHand(), null);
    }

    public DiscardCost(ModifiableVariable.ExternalValue<Integer> externalDynamicValue) {
        super(externalDynamicValue, null);
    }

    public DiscardCost forceAutoConfirm(boolean set) {
        this.forceAutoConfirm = set;
        return this;
    }

    @Override
    public boolean canBePaid() {
        if (!this.isSelfCost()) {
            if (this.getFilter() != null && this.getPayerRole() == Game.getCurrentGame().getPlayerRole() && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
                long count = this.getFilter().getExportedData().stream().filter(c -> ((CardIndex)c).getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check((CardIndex)c, this.getSourceCardIndex(), this.getSourceAbility(), new Object[]{GameConst.CardLocation.TRASH}) == RuleCheck.RuleCheckState.OK).count();
                this.setCanBePaidPrivately(count >= (long)this.getCostMinCount());
            }
            return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getPayerRole()).getHand().getTotalCards() >= this.getCostMinCount();
        }
        return this.getSourceCardIndex() == null || this.getSourceCardIndex().getLocation() == GameConst.CardLocation.HAND;
    }

    @Override
    protected void pay() {
        GameAction action;
        if (!this.isSelfCost() && PlayerControl.isChoosingPlayer(this.getPayerRole())) {
            int minCount = this.getCostMinCount();
            if (minCount == 0 && (this.checkForcedMandatoryState(true) || this.isPrecededByBaseCost())) {
                minCount = this.getCostMaxCount();
            }
            action = new ActionManualDiscard(minCount, this.getCostMaxCount(), this.getChoiceLogic(), this.getFilter(), this.getCondition());
            ((ActionManualDiscard)action).setAutoConfirm(this.forceAutoConfirm);
        } else {
            action = this.isSelfCost() && this.getSourceCardIndex() != null ? new ActionDiscard(this.getSourceCardIndex()) : new ActionDiscard();
        }
        this.addAction(action);
    }

    @Override
    public boolean isVisuallySignificant() {
        return this.getCostMaxCount() > 0 || this.hasDynamicCost();
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return this.getFilter() == null || this.getFilter().getHintTargetType() == TargetFilter.TargetHint.GENERIC ? TargetFilter.TargetHint.DISCARD : this.getFilter().getHintTargetType();
    }
}

