/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEmpty;
import open.batoru.core.gameplay.actions.ActionEnerPay;
import open.batoru.core.gameplay.actions.ActionManualEnerPay;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.DataTableRuleCheck;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataColor;
import open.batoru.data.DataTable;
import open.batoru.data.ModifiableString;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.ZoneEner;
import open.batoru.game._3d.Card3D;
import open.batoru.ui.UI;

public class EnerCost
extends AbilityCost {
    private final ModifiableString modCost;
    private ColorPayFilter colorPayFilter;

    public EnerCost(String costString) {
        this(costString, null);
    }

    public EnerCost(String costString, ColorPayFilter colorPayFilter) {
        super(1, 1, null, null);
        this.modCost = new ModifiableString(costString);
        this.colorPayFilter = colorPayFilter;
    }

    public void setColorPayFilter(ColorPayFilter colorPayFilter) {
        this.colorPayFilter = colorPayFilter;
    }

    public ColorPayFilter getColorPayFilter() {
        return this.colorPayFilter;
    }

    public ModifiableString getCostString() {
        return this.modCost;
    }

    @Override
    public boolean canBePaid() {
        String originalCostString = this.modCost.getValue();
        if (originalCostString.isEmpty()) {
            return true;
        }
        DataTableRuleCheck ruleCheckDataAltPayCosts = (DataTableRuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.getPayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.DATA_COSTS_ENER_ALT_PAY);
        DataTable dataAvailablePayCostStrings = (DataTable)ruleCheckDataAltPayCosts.check(this.getPayerRole(), this.getSourceCardIndex(), this.getSourceAbility(), this);
        dataAvailablePayCostStrings.add(originalCostString);
        return dataAvailablePayCostStrings.stream().anyMatch(costString -> costString.isEmpty() || this.checkCanBePaidLoop((String)costString, false) || this.checkCanBePaidLoop((String)costString, true));
    }

    private boolean checkCanBePaidLoop(String costString, boolean reversed) {
        StringBuilder remainingCost = new StringBuilder(costString);
        ZoneEner zoneEner = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getPayerRole()).getEnerZone();
        ArrayList<CardIndex> listPayable = new ArrayList<CardIndex>();
        for (int i = 0; i < zoneEner.getTotalCards(); ++i) {
            Card3D card3D;
            Card3D card3D2 = card3D = reversed ? zoneEner.getTopCard(i) : zoneEner.getBottomCard(i);
            if (!this.isEffect() && card3D.getCardIndex() == this.getSourceCardIndex()) continue;
            listPayable.add(card3D.getCardIndex());
        }
        DataTableRuleCheck ruleCheckDataEnerSubstitute = (DataTableRuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.getPayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.DATA_CARDS_ENER_SUBSTITUTE);
        DataTable dataCardsEnerSubstitute = (DataTable)ruleCheckDataEnerSubstitute.check(this.getPayerRole(), this.getSourceCardIndex(), this.getSourceAbility(), new Object[0]);
        for (int i = 0; i < dataCardsEnerSubstitute.size(); ++i) {
            listPayable.add((CardIndex)dataCardsEnerSubstitute.get(i));
        }
        ArrayList<CardIndex> listCurrentPayable = new ArrayList<CardIndex>();
        block2: for (CardIndex cardIndex : listPayable) {
            int countPayEner = cardIndex.getIndexedInstance().getRCRegistry().getRuleValue(CardRuleCheckRegistry.CardRuleValueType.PAY_ENER_COUNT).getValue();
            for (int ii = 0; ii < remainingCost.length(); ++ii) {
                char shortLabel = remainingCost.charAt(ii);
                CardConst.CardColor color = CardConst.CardColor.getColorByShortLabel(shortLabel);
                CardDataColor filteredData = this.colorPayFilter == null ? null : this.colorPayFilter.getData(color);
                boolean match = filteredData == null ? this.canPayColor(cardIndex, color, costString, listCurrentPayable) : filteredData.getValue().stream().anyMatch(c -> this.canPayColor(cardIndex, (CardConst.CardColor)((Object)c), costString, (List<CardIndex>)listCurrentPayable));
                if (!match) continue;
                remainingCost.deleteCharAt(ii);
                if (countPayEner > 1) {
                    int indexColor;
                    for (int i = 1; i < countPayEner && (indexColor = remainingCost.indexOf(String.valueOf(shortLabel))) != -1; ++i) {
                        remainingCost.deleteCharAt(indexColor);
                        if (indexColor > ii) continue;
                        --ii;
                    }
                }
                --ii;
                continue block2;
            }
        }
        return remainingCost.isEmpty();
    }

    private boolean canPayColor(CardIndex cardIndex, CardConst.CardColor color, String costString, List<CardIndex> listCurrentPayable) {
        if (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_PAY_COLOR).check(new CardRuleCheckData(cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), new Object[]{color})) == RuleCheck.RuleCheckState.BLOCK) {
            return false;
        }
        listCurrentPayable.add(cardIndex);
        if (Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.getPayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_PAY_ENER).check(this.getPayerRole(), this.getSourceCardIndex(), this.getSourceAbility(), costString, listCurrentPayable) == RuleCheck.RuleCheckState.BLOCK) {
            listCurrentPayable.remove(cardIndex);
            return false;
        }
        return true;
    }

    @Override
    protected void pay() {
        GameAction action;
        if (!this.modCost.getValue().isEmpty()) {
            action = PlayerControl.isChoosingPlayer(this.getPayerRole()) ? new ActionManualEnerPay(!this.checkForcedMandatoryState(false) && (this.checkForcedMandatoryState(true) || !this.isEffect()) || this.isPrecededByBaseCost()) : new ActionEnerPay();
        } else {
            action = new ActionEmpty();
            ActionEnerPay.PaidEnerData emptyData = new ActionEnerPay.PaidEnerData(null, null);
            action.getDataTable().add(emptyData);
            this.addPaidData(emptyData);
        }
        this.addAction(action);
    }

    @Override
    public boolean isVisuallySignificant() {
        return !this.modCost.getValue().isEmpty();
    }

    public static boolean canPayCost(Ability sourceAbility, String costString) {
        if (sourceAbility == null) {
            return false;
        }
        EnerCost cost = new EnerCost(costString);
        cost.treatAsEffect();
        cost.setSourceAbility(sourceAbility);
        cost.setPayerRole(sourceAbility.getAbilityOwner());
        return cost.canBePaid();
    }

    @FunctionalInterface
    public static interface ColorPayFilter {
        public CardDataColor getData(CardConst.CardColor var1);
    }
}

