/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.Deck;
import open.batoru.core.gameplay.actions.ActionMillDeck;
import open.batoru.core.gameplay.actions.ActionRequestInfoDeck;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.ui.UI;

public class MillCost
extends AbilityCost {
    private final Deck.DeckPosition position;

    public MillCost(int count) {
        this(count, Deck.DeckPosition.TOP);
    }

    public MillCost(int count, Deck.DeckPosition position) {
        super(count, count, null, null);
        this.position = position;
    }

    @Override
    public boolean canBePaid() {
        return UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getPayerRole()).getDeckZone(Deck.DeckType.MAIN).getTotalCards() >= this.getCostMinCount();
    }

    @Override
    protected void pay() {
        ActionRequestInfoDeck actionDeckInfo = new ActionRequestInfoDeck(this.getPayerRole(), this.getCostMinCount(), this.position);
        this.addAction(actionDeckInfo);
        ActionMillDeck actionMill = new ActionMillDeck(this.getPayerRole(), actionDeckInfo.getDataTable(), this.position);
        this.addAction(actionMill);
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return TargetFilter.TargetHint.TRASH;
    }
}

