/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionManualTargetCard;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.actions.ActionPutInEner;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.cost.AbilityCost;

public class PutInEnerCost
extends AbilityCost {
    public PutInEnerCost() {
    }

    public PutInEnerCost(TargetFilter filter) {
        super(1, 1, filter, null);
    }

    public PutInEnerCost(int countMin, TargetFilter filter) {
        super(countMin, countMin, filter, null);
    }

    public PutInEnerCost(int countMin, int countMax, TargetFilter filter) {
        super(countMin, countMax, filter, null);
    }

    public PutInEnerCost(int countMin, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        super(countMin, countMin, filter, condition);
    }

    public PutInEnerCost(int countMin, int countMax, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        super(countMin, countMax, filter, condition);
    }

    @Override
    public boolean canBePaid() {
        if (!this.isSelfCost()) {
            if (this.getPayerRole() == Game.getCurrentGame().getPlayerRole() && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
                this.setCanBePaidPrivately(this.getFilter().getValidTargetsCount() >= this.getCostMaxCount());
                return this.getFilter().getTotalTargetsCount() >= this.getCostMaxCount();
            }
            return this.getFilter().getValidTargetsCount() >= this.getCostMaxCount();
        }
        return this.getSourceCardIndex().getLocation() != GameConst.CardLocation.ENER;
    }

    @Override
    protected void pay() {
        if (!this.isSelfCost()) {
            GameAction action = PlayerControl.isChoosingPlayer(this.getPayerRole()) ? new ActionManualTargetCard(this.getCostMinCount(), this.getCostMaxCount(), this.getFilter(), this.getCondition(), AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(this.getFilter());
            this.addAction(action);
            if (action.getDataTable().get() != null) {
                ActionPutInEner prevAction = null;
                for (int i = 0; i < action.getDataTable().size(); ++i) {
                    ActionPutInEner actionPutInEner = new ActionPutInEner((CardIndex)action.getDataTable().get(i));
                    actionPutInEner.setAtOnce(prevAction, i, action.getDataTable().size());
                    prevAction = actionPutInEner;
                    this.addAction(actionPutInEner);
                }
            }
        } else {
            ActionPutInEner action = new ActionPutInEner(this.getSourceCardIndex());
            this.addAction(action);
        }
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return TargetFilter.TargetHint.ENER;
    }
}

