/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionAttach;
import open.batoru.core.gameplay.actions.ActionManualTargetCard;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.cost.AbilityCost;

public class PutUnderCost
extends AbilityCost {
    public PutUnderCost(TargetFilter filter) {
        this(1, filter);
    }

    public PutUnderCost(int count, TargetFilter filter) {
        this(count, count, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public PutUnderCost(int countMin, int countMax, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        super(countMin, countMax, filter, condition);
        this.setChoiceLogic(choiceLogic);
    }

    @Override
    public boolean canBePaid() {
        if (this.getPayerRole() == Game.getCurrentGame().getPlayerRole() && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
            this.setCanBePaidPrivately(this.getFilter().getValidTargetsCount() >= this.getCostMaxCount());
            return this.getFilter().getTotalTargetsCount() >= this.getCostMaxCount();
        }
        return this.getFilter().getValidTargetsCount() >= this.getCostMaxCount();
    }

    @Override
    protected void pay() {
        GameAction action = PlayerControl.isChoosingPlayer(this.getPayerRole()) ? new ActionManualTargetCard(this.getCostMinCount(), this.getCostMaxCount(), this.getFilter(), this.getCondition(), this.getChoiceLogic()) : new ActionPlayerChoiceCard(this.getFilter());
        this.addAction(action);
        if (action.getDataTable().get() != null) {
            ActionAttach prevAction = null;
            for (int i = 0; i < action.getDataTable().size(); ++i) {
                ActionAttach actionAttach = new ActionAttach(this.getSourceCardIndex(), (CardIndex)action.getDataTable().get(i), GameConst.CardUnderType.UNDER_GENERIC);
                actionAttach.setAtOnce(prevAction, i, action.getDataTable().size());
                prevAction = actionAttach;
                this.addAction(actionAttach);
            }
        }
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return TargetFilter.TargetHint.UNDER;
    }
}

