/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.Deck;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionManualSearchDeck;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.actions.ActionReturnToDeck;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.cost.AbilityCost;

public class ReturnToDeckCost
extends AbilityCost {
    private final Deck.DeckPosition position;

    public ReturnToDeckCost(Deck.DeckPosition position) {
        this.position = position;
    }

    public ReturnToDeckCost(Deck.DeckPosition position, TargetFilter filter) {
        super(1, 1, filter, null);
        this.position = position;
    }

    public ReturnToDeckCost(Deck.DeckPosition position, int countMin, TargetFilter filter) {
        super(countMin, countMin, filter, null);
        this.position = position;
    }

    public ReturnToDeckCost(Deck.DeckPosition position, int countMin, int countMax, TargetFilter filter) {
        super(countMin, countMax, filter, null);
        this.position = position;
    }

    public ReturnToDeckCost(Deck.DeckPosition position, int countMin, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        super(countMin, countMin, filter, condition);
        this.position = position;
    }

    public ReturnToDeckCost(Deck.DeckPosition position, int countMin, int countMax, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        super(countMin, countMax, filter, condition);
        this.position = position;
    }

    @Override
    public boolean canBePaid() {
        return !this.isSelfCost() ? this.getFilter().getValidTargetsCount() >= this.getCostMinCount() : this.getSourceCardIndex().getLocation() != GameConst.CardLocation.DECK_MAIN && this.getSourceCardIndex().getLocation() != GameConst.CardLocation.DECK_LRIG;
    }

    @Override
    protected void pay() {
        if (!this.isSelfCost()) {
            GameAction action;
            if (PlayerControl.isChoosingPlayer(this.getPayerRole())) {
                GameConst.CardLocation location = (GameConst.CardLocation)((Object)this.getFilter().getHintLocationsData().toArray()[0]);
                action = new ActionManualSearchDeck(this.getCostMinCount(), this.getCostMaxCount(), this.getFilter(), this.getCondition(), this.getPayerRole(), location);
            } else {
                action = new ActionPlayerChoiceCard(this.getFilter());
            }
            this.addAction(action);
            if (action.getDataTable().get() != null) {
                ActionReturnToDeck prevAction = null;
                for (int i = 0; i < action.getDataTable().size(); ++i) {
                    ActionReturnToDeck actionReturn = new ActionReturnToDeck((CardIndex)action.getDataTable().get(i), this.position);
                    actionReturn.setAtOnce(prevAction, i, action.getDataTable().size());
                    prevAction = actionReturn;
                    this.addAction(actionReturn);
                }
            }
        } else {
            ActionReturnToDeck action = new ActionReturnToDeck(this.getSourceCardIndex(), this.position);
            this.addAction(action);
        }
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return this.position == Deck.DeckPosition.TOP ? TargetFilter.TargetHint.TOP : TargetFilter.TargetHint.BOTTOM;
    }
}

