/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import java.util.ArrayList;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.DataTable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityFunctionalConditionalHandler;
import open.batoru.data.ability.events.EventAbilityGain;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.game.overlay.log.events.LogEventAbilityLost;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class AbilityCopyModifier
extends ConstantModifier {
    private TargetFilter filter;
    private AbilityFunctionalConditionalHandler handler;
    private DataTable<CardIndex> cachedData;
    private int lastSize;
    private final ArrayList<Ability> copiedAbilities = new ArrayList();

    public AbilityCopyModifier(TargetFilter filter, AbilityFunctionalConditionalHandler handler) {
        this.filter = filter;
        this.handler = handler;
    }

    @Override
    public boolean shouldForceUpdate(CardIndex cardIndex) {
        if (this.lastSize == 0) {
            this.lastSize = this.filter.getExportedData().size();
            return this.lastSize != 0;
        }
        return false;
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        if (this.cachedData == null) {
            this.cachedData = this.filter.getExportedData();
        }
        if (this.cachedData.isEmpty()) {
            return;
        }
        this.lastSize = this.cachedData.size();
        CardIndex source = this.cachedData.get();
        source.getIndexedInstance().getAbilityList().stream().filter(this.handler::handle).forEach(ability -> {
            Ability abilityCopy = cardIndex.getIndexedInstance().copyAbility((Ability)ability);
            if (abilityCopy != null) {
                this.copiedAbilities.add(abilityCopy);
            }
        });
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        if (!this.copiedAbilities.isEmpty()) {
            this.copiedAbilities.forEach(abilityCopy -> {
                cardIndex.getIndexedInstance().removeAbilitySafe((Ability)abilityCopy);
                LogEventAbilityLost logEventAbilityLost = new LogEventAbilityLost(new EventAbilityGain(cardIndex, (Ability)abilityCopy, this.getSourceAbility()));
                FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEventAbilityLost));
            });
            Game.getCurrentGame().getGameRules().getEffectProcessor().addConstantUpdatePostProcessingJob(() -> {
                if (cardIndex.getIndexedInstance() != null) {
                    cardIndex.getIndexedInstance().clearAllAbilitiesSafe();
                }
            });
            this.copiedAbilities.clear();
        }
    }

    @Override
    public void dispose() {
        this.filter = null;
        this.handler = null;
        this.cachedData = null;
        this.copiedAbilities.clear();
        super.dispose();
    }
}

