/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import java.util.HashMap;
import java.util.Map;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConditionNoSource;
import open.batoru.data.ability.AbilityConditionWithSource;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.events.EventAbilityGain;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.game.overlay.log.events.LogEventAbilityGained;
import open.batoru.game.overlay.log.events.LogEventAbilityLost;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class AbilityGainModifier
extends ConstantModifier {
    private SampleAbilityHandler handlerSample;
    private final Map<CardIndex, Ability> mapCacheAbilities = new HashMap<CardIndex, Ability>();
    private LogEvent logEventAbilityGain;

    public AbilityGainModifier(SampleAbilityHandler handlerSample) {
        this.handlerSample = handlerSample;
    }

    public AbilityGainModifier(AbilityConditionWithSource condition, SampleAbilityHandler handlerSample) {
        super(condition);
        this.handlerSample = handlerSample;
    }

    public AbilityGainModifier(AbilityConditionNoSource condition, SampleAbilityHandler handlerSample) {
        super(condition);
        this.handlerSample = handlerSample;
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        Ability ability = this.handlerSample.getAbility(cardIndex);
        if (ability == null) {
            return;
        }
        ability.setSourceAttachAbility(this.getSourceAbility());
        ability.onAbilityInit();
        EventAbilityGain event = new EventAbilityGain(cardIndex, ability, this.getSourceAbility());
        this.logEventAbilityGain = new LogEventAbilityGained(event);
        FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(this.logEventAbilityGain));
        if (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ABILITY_BE_ATTACHED).check(cardIndex, ability, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            cardIndex.getIndexedInstance().removeAbility(ability);
            FX.run(() -> this.logEventAbilityGain.disable());
            return;
        }
        this.mapCacheAbilities.put(cardIndex, ability);
        if (ability instanceof ConstantAbility) {
            ConstantAbility abilityConst = (ConstantAbility)ability;
            abilityConst.update();
        } else {
            ability.callOnAbilityEnabledHandler(cardIndex);
        }
        Game.getCurrentGame().getGameRules().getEffectProcessor().callConstantModifierEvent(this.getSourceAbility(), event);
        FX.run(() -> {
            if (UI.getTabGame().getFieldSceneOverlay().getCardPreview().getLastCardIndex() == cardIndex) {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(cardIndex);
            }
        });
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        Ability ability = this.mapCacheAbilities.get(cardIndex);
        if (ability != null) {
            cardIndex.getIndexedInstance().removeAbilitySafe(ability);
            Game.getCurrentGame().getGameRules().getEffectProcessor().addConstantUpdatePostProcessingJob(() -> {
                if (cardIndex.getIndexedInstance() != null) {
                    cardIndex.getIndexedInstance().clearAbilitySafe(ability);
                }
            });
            LogEventAbilityLost logEventAbilityLost = new LogEventAbilityLost(new EventAbilityGain(cardIndex, ability, this.getSourceAbility()));
            FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEventAbilityLost));
            this.mapCacheAbilities.remove(cardIndex);
        }
    }

    @Override
    public void dispose() {
        this.mapCacheAbilities.clear();
        this.handlerSample = null;
        this.logEventAbilityGain = null;
        super.dispose();
    }

    @FunctionalInterface
    public static interface SampleAbilityHandler {
        public Ability getAbility(CardIndex var1);
    }
}

