/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.events.EventPowerChanged;
import open.batoru.data.ability.modifiers.ConstantModifier;

public class BasePowerModifier
extends ConstantModifier {
    private final double basePower;
    private ModifiableVariable.ModifiableValueReference<Double> valueReference;

    public BasePowerModifier(double basePower) {
        this.basePower = basePower;
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        cardIndex.getIndexedInstance().getPower().setSourceAbility(this.getSourceAbility());
        this.valueReference = cardIndex.getIndexedInstance().getPower().setBaseValue(this.basePower);
        Game.getCurrentGame().getGameRules().getEffectProcessor().callConstantModifierEvent(this.getSourceAbility(), new EventPowerChanged(cardIndex, this.getSourceAbility(), cardIndex.getIndexedInstance().getPower().getValue(), 0.0));
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        cardIndex.getIndexedInstance().getPower().removeBaseValue(this.valueReference);
    }

    @Override
    public void dispose() {
        this.valueReference = null;
        super.dispose();
    }
}

