/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.ui.FX;

public class DisableAllAbilitiesModifier
extends ConstantModifier {
    private final Map<CardIndex, List<Ability>> mapDisabledAbilities = new HashMap<CardIndex, List<Ability>>();

    public DisableAllAbilitiesModifier() {
        this.decreasePriority();
    }

    @Override
    public boolean shouldForceUpdate(CardIndex cardIndex) {
        return cardIndex.getIndexedInstance().getAbilityList().stream().anyMatch(ability -> this.shouldDisableAbility(cardIndex, (Ability)ability));
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        for (Ability ability : cardIndex.getIndexedInstance().getAbilityList()) {
            if (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ABILITY_BE_DISABLED).check(cardIndex, this.getSourceAbility(), new Object[0]) == RuleCheck.RuleCheckState.BLOCK || !this.shouldDisableAbility(cardIndex, ability)) {
                return;
            }
            this.mapDisabledAbilities.computeIfAbsent(cardIndex, c -> new ArrayList()).add(ability);
        }
        List<Ability> listDisabledAbilities = this.mapDisabledAbilities.get(cardIndex);
        if (listDisabledAbilities != null) {
            for (Ability ability : listDisabledAbilities) {
                ability.disable();
            }
            FX.run(() -> cardIndex.getSourceCard3D().getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.DISABLED)));
        }
    }

    private boolean shouldDisableAbility(CardIndex cardIndex, Ability ability) {
        ConstantAbility sourceAttachedConst;
        Ability ability2;
        return !ability.isDisabled() && (ability.getAbilityId() < cardIndex.getIndexedInstance().getTotalBaseAbilities() || (ability2 = ability.getSourceAttachAbility()) instanceof ConstantAbility && (sourceAttachedConst = (ConstantAbility)ability2).getLastEnabledTimestamp() < this.getSourceAbility().getLastEnabledTimestamp());
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        this.mapDisabledAbilities.computeIfPresent(cardIndex, (c, listDisabledAbilities) -> {
            for (Ability ability : listDisabledAbilities) {
                ability.enable();
            }
            FX.run(() -> cardIndex.getSourceCard3D().getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.DISABLED.getAlias()));
            return null;
        });
    }

    @Override
    public void dispose() {
        this.mapDisabledAbilities.clear();
        super.dispose();
    }
}

