/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import java.util.Objects;
import java.util.function.Supplier;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.data.ability.modifiers.DynamicValueHandler;
import open.batoru.data.ability.modifiers.SampleModifiableVariableHandler;

public class ModifiableBaseValueModifier<T, V, M extends ModifiableVariable<T, V, M>>
extends ConstantModifier {
    private SampleModifiableVariableHandler<T, V, M> handlerSample;
    private V newBaseValue;
    private DynamicValueHandler<V> handlerDynamicValue;
    private ModifiableVariable.ModifiableValueReference<V> valueReference;

    public ModifiableBaseValueModifier(SampleModifiableVariableHandler<T, V, M> handlerSample, Supplier<V> constantValueSupplier) {
        this.handlerSample = handlerSample;
        this.newBaseValue = constantValueSupplier.get();
    }

    public ModifiableBaseValueModifier(SampleModifiableVariableHandler<T, V, M> handlerSample, DynamicValueHandler<V> handlerDynamicValue) {
        this.handlerSample = handlerSample;
        this.handlerDynamicValue = handlerDynamicValue;
    }

    @Override
    public boolean shouldForceUpdate(CardIndex cardIndex) {
        ModifiableVariable<T, V, M> mod = this.handlerSample.getModifiableVariable(cardIndex);
        if (mod == null) {
            return false;
        }
        if (this.handlerDynamicValue != null) {
            V oldBaseValue = this.newBaseValue;
            TargetFilter.setDefaultSources(this.getSourceAbility().getSourceCardIndex(), this.getSourceAbility());
            this.newBaseValue = this.handlerDynamicValue.getValue(oldBaseValue);
            if (!Objects.equals(oldBaseValue, this.newBaseValue)) {
                return true;
            }
        }
        return !mod.containsBaseValue(this.valueReference);
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        ModifiableVariable<T, V, M> mod = this.handlerSample.getModifiableVariable(cardIndex);
        if (mod != null) {
            this.valueReference = mod.setBaseValue(this.newBaseValue);
        }
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        ModifiableVariable<T, V, M> mod = this.handlerSample.getModifiableVariable(cardIndex);
        if (mod != null) {
            mod.removeBaseValue(this.valueReference);
        }
    }

    @Override
    public void dispose() {
        this.handlerSample = null;
        this.handlerDynamicValue = null;
        this.valueReference = null;
        super.dispose();
    }
}

