/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.modifiers.ConstantModifier;

public class PlayerRuleBaseValueModifier
extends ConstantModifier {
    private final PlayerRuleCheckRegistry.PlayerRuleValueType ruleValueType;
    private final int hintFlagsOwner;
    private final int newValue;
    private ModifiableVariable.ModifiableValueReference<Integer> valueReferenceOwn;
    private ModifiableVariable.ModifiableValueReference<Integer> valueReferenceOP;

    public PlayerRuleBaseValueModifier(PlayerRuleCheckRegistry.PlayerRuleValueType ruleValueType, int hintFlagsOwner, int newValue) {
        this.ruleValueType = ruleValueType;
        this.hintFlagsOwner = hintFlagsOwner;
        this.newValue = newValue;
        this.increasePriority();
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        if ((this.hintFlagsOwner & 1) != 0) {
            this.valueReferenceOwn = this.getRuleValueByRole(cardIndex.getCurrentOwnerSafe()).setBaseValue(this.newValue);
        }
        if ((this.hintFlagsOwner & 2) != 0) {
            this.valueReferenceOP = this.getRuleValueByRole(Game.GamePlayerRole.getOpponentRole(cardIndex.getCurrentOwnerSafe())).setBaseValue(this.newValue);
        }
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        this.getRuleValueByRole(cardIndex.getCurrentOwnerSafe()).removeBaseValue(this.valueReferenceOwn);
        this.getRuleValueByRole(Game.GamePlayerRole.getOpponentRole(cardIndex.getCurrentOwnerSafe())).removeBaseValue(this.valueReferenceOP);
    }

    private ModifiableInteger getRuleValueByRole(Game.GamePlayerRole rolePlayer) {
        return Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleValue(this.ruleValueType);
    }
}

