/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.modifiers.ConstantModifier;

public class RuleCheckModifier<T, V extends CardRuleCheckData>
extends ConstantModifier {
    private final CardRuleCheckRegistry.CardRuleCheckType ruleCheckType;
    private RuleCheck.RuleCheckHandler<T, V> modHandler;

    public RuleCheckModifier(CardRuleCheckRegistry.CardRuleCheckType ruleCheckType, RuleCheck.RuleCheckHandler<T, V> modHandler) {
        this.ruleCheckType = ruleCheckType;
        this.modHandler = modHandler;
        this.increasePriority();
    }

    public CardRuleCheckRegistry.CardRuleCheckType getRuleCheckType() {
        return this.ruleCheckType;
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        RuleCheck ruleCheck = (RuleCheck)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(this.ruleCheckType);
        ruleCheck.addRuleCheck(this.modHandler, this.getSourceAbility());
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        RuleCheck ruleCheck = (RuleCheck)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(this.ruleCheckType);
        ruleCheck.removeRuleCheck(this.modHandler);
    }

    @Override
    public void dispose() {
        this.modHandler = null;
        super.dispose();
    }
}

