/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ValueByReference;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.data.ability.modifiers.SampleModifiableVariableHandler;

public class ValueByReferenceModifier<T, V, M extends ModifiableVariable<T, V, M>>
extends ConstantModifier {
    private SampleModifiableVariableHandler<T, V, M> handlerSample;
    private ValueByReference<V> valueByRef;

    public ValueByReferenceModifier(SampleModifiableVariableHandler<T, V, M> handlerSample, ValueByReference<V> valueByRef) {
        this.handlerSample = handlerSample;
        this.valueByRef = valueByRef;
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        ModifiableVariable<T, V, M> mod = this.handlerSample.getModifiableVariable(cardIndex);
        if (mod != null) {
            mod.addByReferenceValue(this.valueByRef, this.getSourceAbility());
        }
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        ModifiableVariable<T, V, M> mod = this.handlerSample.getModifiableVariable(cardIndex);
        if (mod != null) {
            mod.removeByReferenceValue(this.valueByRef);
        }
    }

    @Override
    public void dispose() {
        this.handlerSample = null;
        this.valueByRef = null;
        super.dispose();
    }
}

